/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOBase;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseTree;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SymbolTable;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;

public final class InterpreterThread
extends Thread {
    private Machine _mach;
    private Console _console;
    private CaselessString _id;
    private IOBase _ins;
    private IOBase _outs;
    private CaselessString _insid;
    private CaselessString _outsid;
    private IOBase _savedins;
    private boolean _isRootThread;
    private SymbolTable _symStack;
    private LogoList _toInterpret;
    private ParseTree _treeInterpret;
    private boolean _isStopping;

    InterpreterThread(CaselessString caselessString, LogoList logoList, CaselessString caselessString2, IOBase iOBase, CaselessString caselessString3, IOBase iOBase2, SymbolTable symbolTable, Machine machine) {
        this._toInterpret = logoList;
        this._treeInterpret = null;
        this._id = caselessString;
        this._mach = machine;
        this._console = machine.console();
        this._insid = caselessString2;
        this._outsid = caselessString3;
        this._ins = iOBase;
        this._outs = iOBase2;
        this._symStack = symbolTable;
        this._isRootThread = caselessString.equals(".MAIN");
        this._savedins = null;
        this._isStopping = false;
    }

    InterpreterThread(CaselessString caselessString, ParseTree parseTree, CaselessString caselessString2, IOBase iOBase, CaselessString caselessString3, IOBase iOBase2, SymbolTable symbolTable, Machine machine) {
        this._toInterpret = null;
        this._treeInterpret = parseTree;
        this._id = caselessString;
        this._mach = machine;
        this._console = machine.console();
        this._insid = caselessString2;
        this._outsid = caselessString3;
        this._ins = iOBase;
        this._outs = iOBase2;
        this._symStack = symbolTable;
        this._isRootThread = caselessString.equals(".MAIN");
        this._savedins = null;
        this._isStopping = false;
    }

    public InterpreterThread(Machine machine, IOBase iOBase) {
        this._toInterpret = null;
        this._mach = machine;
        this._console = machine.console();
        this._id = new CaselessString(".PRIVATE");
        this._insid = new CaselessString(".PRIVATE");
        this._outsid = new CaselessString(".PRIVATE");
        this._ins = iOBase;
        this._outs = this._mach.console();
        this._symStack = new SymbolTable();
        this._isRootThread = true;
        this._savedins = null;
        this._isStopping = false;
    }

    public final boolean stopping() {
        return this._isStopping;
    }

    public final void signalStop() {
        this._isStopping = true;
    }

    public final Machine mach() {
        return this._mach;
    }

    public final CaselessString threadID() {
        return this._id;
    }

    public final IOBase inStream() {
        return this._ins;
    }

    public final CaselessString inStreamID() {
        return this._insid;
    }

    public final IOBase outStream() {
        return this._outs;
    }

    public final CaselessString outStreamID() {
        return this._outsid;
    }

    public final void setInStream(CaselessString caselessString, IOBase iOBase) {
        this._insid = caselessString;
        this._ins = iOBase;
        if (this._isRootThread && this._toInterpret != null) {
            this._mach.setInStream(caselessString, iOBase);
        }
    }

    public final void setOutStream(CaselessString caselessString, IOBase iOBase) {
        this._outsid = caselessString;
        this._outs = iOBase;
        if (this._isRootThread && this._toInterpret != null) {
            this._mach.setOutStream(caselessString, iOBase);
        }
    }

    public final void startLoading(IOBase iOBase) {
        this._savedins = this._ins;
        this._ins = iOBase;
    }

    public final void endLoading() {
        this._ins = this._savedins;
        this._savedins = null;
    }

    public final boolean isLoading() {
        return this._savedins != null;
    }

    public final void enterProcedure(SymbolTable symbolTable) {
        this._symStack = symbolTable.pushOn(this._symStack);
    }

    public final void exitProcedure() {
        this._symStack = this._symStack.next();
    }

    public final void localName(CaselessString caselessString) throws LanguageException {
        this._symStack.declare(caselessString, this._mach);
    }

    public final void makeName(CaselessString caselessString, LogoObject logoObject) {
        for (SymbolTable symbolTable = this._symStack; symbolTable != null; symbolTable = symbolTable.next()) {
            if (!symbolTable.make(caselessString, logoObject)) continue;
            return;
        }
        this._mach.makeName(caselessString, logoObject);
    }

    public final LogoObject resolveName(CaselessString caselessString) {
        for (SymbolTable symbolTable = this._symStack; symbolTable != null; symbolTable = symbolTable.next()) {
            LogoObject logoObject = symbolTable.resolve(caselessString);
            if (logoObject == null) continue;
            return logoObject;
        }
        return this._mach.resolveName(caselessString);
    }

    public final void eraseName(CaselessString caselessString) {
        for (SymbolTable symbolTable = this._symStack; symbolTable != null; symbolTable = symbolTable.next()) {
            symbolTable.erase(caselessString);
        }
        this._mach.eraseName(caselessString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LogoObject logoObject;
            block19: {
                logoObject = LogoVoid.obj;
                try {
                    if (this._toInterpret == null && this._treeInterpret == null) {
                        this._mach.executeStream(this._ins, this);
                    } else {
                        if (this._treeInterpret == null) {
                            this._treeInterpret = this._toInterpret.getRunnable(this._mach);
                        }
                        logoObject = this._treeInterpret.execute(new InterpEnviron(this));
                    }
                }
                catch (ThrowException throwException) {
                    CaselessString caselessString = throwException.getTag();
                    if (caselessString.equals("TOPLEVEL")) {
                        this._mach.terminateAllThreads();
                    }
                    if (caselessString.equals("GOODBYE")) {
                        this._mach.terminateAllThreads();
                        this._console.goodbye();
                    }
                    if (caselessString.equals("STOP")) {
                        throw new LanguageException("Can use STOP or OUTPUT only inside a procedure");
                    }
                    if (caselessString.equals("STOPTHREAD") || caselessString.equals(".SUDDENSTOPTHREAD")) break block19;
                    this._console.putLine("Uncaught: " + caselessString);
                    this._console.putLine("... with value " + throwException.getObj().toString());
                    if (!this._isRootThread) {
                        this._console.putLine("... in thread " + this._id.str);
                    }
                    this._mach.terminateAllThreads();
                }
            }
            if (!this._mach.isAutoIgnore() && logoObject != LogoVoid.obj) {
                throw new LanguageException("You don't say what to do with " + logoObject);
            }
        }
        catch (LanguageException languageException) {
            this._console.putLine(languageException.generateMessage());
            this._mach.setRuntimeErrorMessage(languageException.generateMessage());
            if (!this._isRootThread) {
                this._console.putLine("... in thread " + this._id.str);
            }
            this._mach.terminateAllThreads();
        }
        catch (Throwable throwable) {
            this._console.putLine(throwable.toString());
            if (!this._isRootThread) {
                this._console.putLine("... in thread " + this._id.str);
            }
            throwable.printStackTrace();
            this._mach.terminateAllThreads();
        }
        finally {
            this._mach.threadEnding(this._id);
        }
    }
}

