/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseTree;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Parser;
import java.util.Vector;

public class LogoList
extends LogoObject {
    private LogoObject[] _lis;
    private ParseTree _run;

    public LogoList() {
        this._lis = new LogoObject[0];
        this._run = null;
    }

    public LogoList(LogoObject[] logoObjectArray) {
        this._lis = logoObjectArray;
        this._run = null;
    }

    public LogoList(Vector vector) {
        this._lis = new LogoObject[vector.size()];
        for (int i = 0; i < this._lis.length; ++i) {
            this._lis[i] = (LogoObject)vector.elementAt(i);
        }
        this._run = null;
    }

    @Override
    public Object clone() {
        LogoObject[] logoObjectArray = new LogoObject[this._lis.length];
        for (int i = 0; i < this._lis.length; ++i) {
            logoObjectArray[i] = this._lis[i];
        }
        return new LogoList(logoObjectArray);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LogoList) {
            if (((LogoList)object).length() != this._lis.length) {
                return false;
            }
            for (int i = 0; i < this._lis.length; ++i) {
                if (this._lis[i].equals(((LogoList)object)._lis[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(' ');
        for (int i = 0; i < this._lis.length; ++i) {
            stringBuffer.append(this._lis[i].toString()).append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public String unparse() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(' ');
        for (int i = 0; i < this._lis.length; ++i) {
            stringBuffer.append(this._lis[i].unparse()).append(' ');
        }
        stringBuffer.append(']');
        return new String(stringBuffer);
    }

    public String toStringOpen() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._lis.length; ++i) {
            stringBuffer.append(this._lis[i].toString());
            if (i == this._lis.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    @Override
    public ParseTree getRunnable(Machine machine) throws LanguageException {
        if (this._run != null && this._run.testClock(machine.getClock())) {
            return this._run;
        }
        this._run = new Parser().parse(this, machine);
        return this._run;
    }

    @Override
    public LogoObject first() throws LanguageException {
        if (this._lis.length == 0) {
            throw new LanguageException("Empty list");
        }
        return this._lis[0];
    }

    @Override
    public LogoObject last() throws LanguageException {
        if (this._lis.length == 0) {
            throw new LanguageException("Empty list");
        }
        return this._lis[this._lis.length - 1];
    }

    @Override
    public LogoObject butFirst() throws LanguageException {
        if (this._lis.length == 0) {
            throw new LanguageException("Empty list");
        }
        LogoObject[] logoObjectArray = new LogoObject[this._lis.length - 1];
        for (int i = 1; i < this._lis.length; ++i) {
            logoObjectArray[i - 1] = this._lis[i];
        }
        return new LogoList(logoObjectArray);
    }

    @Override
    public LogoObject butLast() throws LanguageException {
        if (this._lis.length == 0) {
            throw new LanguageException("Empty list");
        }
        LogoObject[] logoObjectArray = new LogoObject[this._lis.length - 1];
        for (int i = 0; i < this._lis.length - 1; ++i) {
            logoObjectArray[i] = this._lis[i];
        }
        return new LogoList(logoObjectArray);
    }

    public LogoObject fput(LogoObject logoObject) {
        if (logoObject instanceof LogoVoid) {
            return this;
        }
        LogoObject[] logoObjectArray = new LogoObject[this._lis.length + 1];
        logoObjectArray[0] = logoObject;
        for (int i = 0; i < this._lis.length; ++i) {
            logoObjectArray[i + 1] = this._lis[i];
        }
        return new LogoList(logoObjectArray);
    }

    public LogoObject lput(LogoObject logoObject) {
        if (logoObject instanceof LogoVoid) {
            return this;
        }
        LogoObject[] logoObjectArray = new LogoObject[this._lis.length + 1];
        for (int i = 0; i < this._lis.length; ++i) {
            logoObjectArray[i] = this._lis[i];
        }
        logoObjectArray[this._lis.length] = logoObject;
        return new LogoList(logoObjectArray);
    }

    @Override
    public int length() {
        return this._lis.length;
    }

    public boolean isMember(LogoObject logoObject) {
        for (int i = 0; i < this._lis.length; ++i) {
            if (!this._lis[i].equals(logoObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LogoObject pick(int n) throws LanguageException {
        if (this._lis.length == 0) {
            throw new LanguageException("Empty list");
        }
        if (n < 1 || n > this._lis.length) {
            throw new LanguageException("Index out of bounds");
        }
        return this._lis[n - 1];
    }

    public LogoObject pickInPlace(int n) {
        return this._lis[n];
    }
}

