/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;

public class LogoWord
extends LogoObject {
    private String _str;
    private String _unparsed;
    private byte _type;
    private double _val;
    private static final String _true = "TRUE";
    private static final String _false = "FALSE";
    static final byte TYPE_WORD = 1;
    static final byte TYPE_PUNCT = 2;
    static final byte TYPE_INT = 3;
    static final byte TYPE_FLOAT = 4;

    public LogoWord() {
        this._str = "";
        this._unparsed = "";
        this._type = 1;
        this._val = 0.0;
    }

    private LogoWord(String string, String string2, byte by, double d) {
        this._str = string;
        this._unparsed = string2;
        this._type = by;
        this._val = d;
    }

    public LogoWord(String string, String string2) {
        this._str = string;
        this._unparsed = string2;
        if (this._str.length() == 0) {
            this._type = 1;
        } else {
            try {
                this._val = Double.valueOf(this._str);
                int n = (int)this._val;
                if ((double)n == this._val) {
                    this._str = String.valueOf(n);
                    this._type = (byte)3;
                } else {
                    this._type = (byte)4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this._type = 1;
            }
        }
    }

    public LogoWord(String string) {
        this(string, null);
    }

    public LogoWord(CaselessString caselessString, String string) {
        this(caselessString.str, string);
    }

    public LogoWord(CaselessString caselessString) {
        this(caselessString.str, null);
    }

    public LogoWord(boolean bl) {
        if (bl) {
            this._unparsed = _true;
            this._str = _true;
        } else {
            this._unparsed = _false;
            this._str = _false;
        }
        this._type = 1;
    }

    public LogoWord(double d) {
        this._val = d;
        int n = (int)this._val;
        if ((double)n == this._val) {
            this._str = this._unparsed = String.valueOf(n);
            this._type = (byte)3;
        } else {
            this._str = this._unparsed = String.valueOf(this._val);
            this._type = (byte)4;
        }
    }

    public LogoWord(int n) {
        this._val = n;
        this._str = this._unparsed = String.valueOf(n);
        this._type = (byte)3;
    }

    LogoWord(char c) {
        char[] cArray = new char[]{c};
        this._unparsed = this._str = new String(cArray);
        this._type = (byte)2;
    }

    LogoWord(char c, char c2) {
        char[] cArray = new char[]{c, c2};
        this._unparsed = this._str = new String(cArray);
        this._type = (byte)2;
    }

    @Override
    public Object clone() {
        return new LogoWord(this._str, this._unparsed, this._type, this._val);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LogoWord) {
            return CaselessString.staticEquals(this._str, object.toString());
        }
        return false;
    }

    public String toString() {
        return this._str;
    }

    @Override
    public String unparse() {
        if (this._unparsed == null) {
            this._unparsed = CaselessString.staticUnparse(this._str);
        }
        return this._unparsed;
    }

    byte getType() {
        return this._type;
    }

    @Override
    public LogoObject first() throws LanguageException {
        try {
            return new LogoWord(this._str.substring(0, 1));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new LanguageException("Empty word");
        }
    }

    @Override
    public LogoObject last() throws LanguageException {
        try {
            return new LogoWord(this._str.substring(this._str.length() - 1));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new LanguageException("Empty word");
        }
    }

    @Override
    public LogoObject butFirst() throws LanguageException {
        try {
            return new LogoWord(this._str.substring(1));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new LanguageException("Empty word");
        }
    }

    @Override
    public LogoObject butLast() throws LanguageException {
        try {
            return new LogoWord(this._str.substring(0, this._str.length() - 1));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new LanguageException("Empty word");
        }
    }

    @Override
    public double toNumber() throws LanguageException {
        if (this._type == 3 || this._type == 4) {
            return this._val;
        }
        throw new LanguageException("Number expected");
    }

    @Override
    public int toInteger() throws LanguageException {
        if (this._type == 3) {
            return (int)this._val;
        }
        throw new LanguageException("Integer expected");
    }

    @Override
    public boolean toBoolean() throws LanguageException {
        if (CaselessString.staticEquals(this._str, _true)) {
            return true;
        }
        if (CaselessString.staticEquals(this._str, _false)) {
            return false;
        }
        throw new LanguageException("Boolean expression expected");
    }

    @Override
    public int length() {
        return this._str.length();
    }

    @Override
    public LogoObject pick(int n) throws LanguageException {
        if (this._str.length() == 0) {
            throw new LanguageException("Empty word");
        }
        try {
            return new LogoWord(this._str.substring(n - 1, n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new LanguageException("Index out of bounds");
        }
    }
}

