/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpEnviron;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveSpec;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ThrowException;
import java.lang.reflect.InvocationTargetException;

public class ParsePrimitive
extends ParseObject {
    private PrimitiveSpec _spec;
    private String _name;
    private ParseObject[] _args;

    public ParsePrimitive(PrimitiveSpec primitiveSpec, String string, ParseObject[] parseObjectArray) {
        this._spec = primitiveSpec;
        this._name = string;
        this._args = parseObjectArray;
    }

    @Override
    public Object clone() {
        return new ParsePrimitive(this._spec, this._name, this._args);
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    @Override
    String procName() {
        return this._name;
    }

    @Override
    LogoObject evaluate(InterpEnviron interpEnviron) throws LanguageException, ThrowException {
        LogoObject[] logoObjectArray = new LogoObject[this._args.length];
        Object[] objectArray = new Object[2];
        for (int i = 0; i < this._args.length; ++i) {
            logoObjectArray[i] = this._args[i].evaluate(interpEnviron);
            if (logoObjectArray[i] != LogoVoid.obj) continue;
            throw new LanguageException(this._args[i].procName().toUpperCase() + " didn't output to " + this._name.toUpperCase());
        }
        Thread.yield();
        interpEnviron.mach().checkSuspend();
        if (interpEnviron.thread().stopping()) {
            throw new ThrowException(".SUDDENSTOPTHREAD");
        }
        objectArray[0] = interpEnviron;
        objectArray[1] = logoObjectArray;
        LogoObject logoObject = LogoVoid.obj;
        try {
            logoObject = (LogoObject)this._spec.method().invoke((Object)this._spec.group(), objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LanguageException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LanguageException) {
                LanguageException languageException = (LanguageException)throwable;
                if (languageException.getPrimName() == null && languageException.getProcName() == null) {
                    throw new LanguageException(languageException.getMessage(), this._name, null, languageException.getContChar());
                }
                throw languageException;
            }
            if (throwable instanceof ThrowException) {
                throw (ThrowException)throwable;
            }
            if (throwable instanceof SecurityException) {
                throw new LanguageException(throwable.toString(), this._name, null);
            }
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new LanguageException(throwable.toString(), this._name);
        }
        return logoObject;
    }
}

