/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParsePrimitive;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseProcedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseSpecial;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.ParseTree;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveSpec;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Procedure;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import java.util.Vector;

final class Parser {
    private static String STRING_OPEN_PAREN = "(";
    private static String STRING_CLOSE_PAREN = ")";
    private int _index;
    private LogoList _list;
    private Machine _mach;
    private boolean _paren;
    private LogoObject _next;
    private LogoWord _nextw;
    private LogoList _nextl;

    Parser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseTree parse(LogoList logoList, Machine machine) throws LanguageException {
        int n;
        this._mach = machine;
        this._list = new Tokenizer(0).tokenizeRunnable(logoList);
        this._index = 0;
        this.nextWord();
        if (this._next == LogoVoid.obj) {
            return new ParseTree(-1, new ParseObject[0]);
        }
        if (this._next.toCaselessString().equals("TO")) {
            ParseObject[] parseObjectArray = new ParseObject[]{new ParseSpecial(0, (LogoList)this._list.butFirst())};
            return new ParseTree(-1, parseObjectArray);
        }
        if (this._next.toCaselessString().equals("TOMACRO")) {
            ParseObject[] parseObjectArray = new ParseObject[]{new ParseSpecial(1, (LogoList)this._list.butFirst())};
            return new ParseTree(-1, parseObjectArray);
        }
        Vector<ParseObject> vector = new Vector<ParseObject>();
        Machine machine2 = this._mach;
        synchronized (machine2) {
            n = this._mach.getClock();
            while (this._next != LogoVoid.obj) {
                vector.addElement(this.parseD());
            }
        }
        return new ParseTree(n, vector);
    }

    private final ParseObject createPrimitive(String string, ParseObject parseObject, ParseObject parseObject2) throws LanguageException {
        PrimitiveSpec primitiveSpec = this._mach.findPrimitive(new CaselessString(string));
        if (primitiveSpec != null) {
            ParseObject[] parseObjectArray = new ParseObject[]{parseObject, parseObject2};
            return new ParsePrimitive(primitiveSpec, string, parseObjectArray);
        }
        throw new LanguageException("Fatal error: no primitive for " + string);
    }

    private final ParseObject parseC() throws LanguageException {
        if (this._nextw != null && this._nextw.getType() == 1) {
            ParseObject[] parseObjectArray;
            int n;
            PrimitiveSpec primitiveSpec = null;
            Procedure procedure = null;
            CaselessString caselessString = this._nextw.toCaselessString();
            procedure = this._mach.resolveProc(caselessString);
            if (procedure != null) {
                n = procedure.numArgs();
            } else {
                primitiveSpec = this._mach.findPrimitive(caselessString);
                if (primitiveSpec != null) {
                    n = primitiveSpec.numArgs();
                } else {
                    throw new LanguageException("I don't know how to " + caselessString);
                }
            }
            this.nextWord();
            if (this._paren) {
                Vector<ParseObject> vector = new Vector<ParseObject>();
                while (this._nextw == null || this._nextw.getType() != 2 || this._nextw.toString().equals(STRING_OPEN_PAREN)) {
                    vector.addElement(this.parseD());
                }
                parseObjectArray = new ParseObject[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    parseObjectArray[i] = (ParseObject)vector.elementAt(i);
                }
            } else {
                parseObjectArray = new ParseObject[n];
                for (int i = 0; i < n; ++i) {
                    parseObjectArray[i] = this.parseD();
                }
            }
            if (procedure != null) {
                return new ParseProcedure(procedure, parseObjectArray);
            }
            return new ParsePrimitive(primitiveSpec, caselessString.str, parseObjectArray);
        }
        return this.parseD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParseObject parseD() throws LanguageException {
        ParseObject parseObject;
        boolean bl = this._paren;
        this._paren = false;
        try {
            parseObject = this.parseDp(this.parseE());
        }
        finally {
            this._paren = bl;
        }
        return parseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParseObject parseDParen() throws LanguageException {
        ParseObject parseObject;
        boolean bl = this._paren;
        this._paren = true;
        try {
            parseObject = this.parseDp(this.parseE());
        }
        finally {
            this._paren = bl;
        }
        return parseObject;
    }

    private final ParseObject parseDp(ParseObject parseObject) throws LanguageException {
        String string;
        if (this._nextw != null && this._nextw.getType() == 2 && ((string = this._nextw.toString()).equals("=") || string.equals(">") || string.equals("<") || string.equals(">=") || string.equals("<="))) {
            this.nextWord();
            return this.parseDp(this.createPrimitive(string, parseObject, this.parseE()));
        }
        return parseObject;
    }

    private final ParseObject parseE() throws LanguageException {
        return this.parseEp(this.parseT());
    }

    private final ParseObject parseEp(ParseObject parseObject) throws LanguageException {
        String string;
        if (this._nextw != null && this._nextw.getType() == 2 && ((string = this._nextw.toString()).equals("+") || string.equals("-"))) {
            this.nextWord();
            return this.parseEp(this.createPrimitive(string, parseObject, this.parseT()));
        }
        return parseObject;
    }

    private final ParseObject parseT() throws LanguageException {
        return this.parseTp(this.parseF());
    }

    private final ParseObject parseTp(ParseObject parseObject) throws LanguageException {
        String string;
        if (this._nextw != null && this._nextw.getType() == 2 && ((string = this._nextw.toString()).equals("*") || string.equals("/"))) {
            this.nextWord();
            return this.parseTp(this.createPrimitive(string, parseObject, this.parseF()));
        }
        return parseObject;
    }

    private final ParseObject parseF() throws LanguageException {
        ParseObject parseObject = LogoVoid.obj;
        if (this._nextw != null) {
            String string;
            if (this._nextw.getType() == 2) {
                string = this._nextw.toString();
                if (string.equals(STRING_OPEN_PAREN)) {
                    this.nextWord();
                    parseObject = this.parseDParen();
                    if (this._nextw == null) {
                        throw new LanguageException("Missing closing paren", '(');
                    }
                    if (!this._nextw.toString().equals(STRING_CLOSE_PAREN)) {
                        throw new LanguageException("Closing paren expected");
                    }
                    this.nextWord();
                    return parseObject;
                }
                if (string.equals(STRING_CLOSE_PAREN)) {
                    throw new LanguageException("Unexpected closing paren");
                }
                if (!string.equals("-")) {
                    throw new LanguageException("Not enough inputs to " + this._nextw);
                }
            }
            if (this._nextw.getType() == 4 || this._nextw.getType() == 3) {
                parseObject = this._next;
                this.nextWord();
                return parseObject;
            }
            string = this._nextw.toString();
            if (string.length() > 0) {
                if (string.equals("-")) {
                    this.nextWord();
                    PrimitiveSpec primitiveSpec = this._mach.findPrimitive(new CaselessString("MINUS"));
                    if (primitiveSpec == null) {
                        throw new LanguageException("Fatal error: no primitive for operator -");
                    }
                    ParseObject[] parseObjectArray = new ParseObject[]{this.parseF()};
                    return new ParsePrimitive(primitiveSpec, "-", parseObjectArray);
                }
                if (string.charAt(0) == '\"') {
                    parseObject = this._next.butFirst();
                    this.nextWord();
                    return parseObject;
                }
                if (string.charAt(0) == ':') {
                    PrimitiveSpec primitiveSpec = this._mach.findPrimitive(new CaselessString("THING"));
                    if (primitiveSpec == null) {
                        throw new LanguageException("Fatal error: no primitive for operator :");
                    }
                    ParseObject[] parseObjectArray = new ParseObject[]{this._next.butFirst()};
                    parseObject = new ParsePrimitive(primitiveSpec, null, parseObjectArray);
                    this.nextWord();
                    return parseObject;
                }
                return this.parseC();
            }
            throw new LanguageException("Empty word in list");
        }
        if (this._nextl != null) {
            parseObject = this._next;
            this.nextWord();
            return parseObject;
        }
        throw new LanguageException("Not enough inputs");
    }

    private final void nextWord() {
        if (this._index >= this._list.length()) {
            this._next = LogoVoid.obj;
            this._nextw = null;
            this._nextl = null;
        } else {
            this._next = this._list.pickInPlace(this._index++);
            if (this._next instanceof LogoWord) {
                this._nextw = (LogoWord)this._next;
                this._nextl = null;
            } else {
                this._nextw = null;
                this._nextl = (LogoList)this._next;
            }
        }
    }
}

