/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOBase;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Tokenizer;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Procedure
implements Cloneable {
    private Machine _mach;
    private CaselessString _name;
    private String[] _codeStrs;
    private LogoList _params;
    private LogoList _code;
    private boolean _isMacro;

    private Procedure(Machine machine, CaselessString caselessString, LogoList logoList, String[] stringArray, boolean bl) {
        this._mach = machine;
        this._name = caselessString;
        this._params = logoList;
        this._code = null;
        this._codeStrs = stringArray;
        this._isMacro = bl;
    }

    public Procedure(Machine machine, CaselessString caselessString, LogoList logoList, Vector vector, boolean bl) {
        this._mach = machine;
        this._name = caselessString;
        this._params = logoList;
        this._code = null;
        this._codeStrs = new String[vector.size()];
        for (int i = 0; i < this._codeStrs.length; ++i) {
            this._codeStrs[i] = (String)vector.elementAt(i);
        }
        this._isMacro = bl;
    }

    public Procedure(Machine machine, CaselessString caselessString, LogoList logoList, LogoList logoList2, boolean bl) {
        this._mach = machine;
        this._params = logoList;
        this._code = logoList2;
        this._name = caselessString;
        this._codeStrs = new String[1];
        this._codeStrs[0] = this._code.toStringOpen();
        this._isMacro = bl;
    }

    public Object clone() {
        return new Procedure(this._mach, this._name, this._params, this._codeStrs, this._isMacro);
    }

    public boolean equals(Object object) {
        if (object instanceof Procedure) {
            return ((Procedure)object)._name.equals(this._name);
        }
        if (object instanceof CaselessString || object instanceof String) {
            return this._name.equals(object);
        }
        return false;
    }

    public static void checkParamNames(LogoList logoList) throws LanguageException {
        for (int i = 0; i < logoList.length(); ++i) {
            LogoObject logoObject = logoList.pickInPlace(i);
            if (!(logoObject instanceof LogoWord)) {
                throw new LanguageException("Parameter symbol names must be words");
            }
            for (int j = i + 1; j < logoList.length(); ++j) {
                if (!logoObject.equals(logoList.pickInPlace(j))) continue;
                throw new LanguageException("Duplicate parameter symbol name: " + logoObject);
            }
        }
    }

    public final CaselessString getName() {
        return this._name;
    }

    public final LogoList getParams() {
        return this._params;
    }

    public final String getHeaderString() {
        StringBuffer stringBuffer = this._isMacro ? new StringBuffer("TOMACRO ") : new StringBuffer("TO ");
        StringTokenizer stringTokenizer = new StringTokenizer(this._params.toStringOpen());
        stringBuffer.append(this._name);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(' ').append(':').append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getHeaderString());
        for (int i = 0; i < this._codeStrs.length; ++i) {
            stringBuffer.append(Machine.LINE_SEPARATOR).append(this._codeStrs[i]);
        }
        return stringBuffer.append(Machine.LINE_SEPARATOR).append("END").append(Machine.LINE_SEPARATOR).toString();
    }

    public final void writeToIO(IOBase iOBase) throws LanguageException {
        iOBase.putLine(this.getHeaderString());
        for (int i = 0; i < this._codeStrs.length; ++i) {
            iOBase.putLine(this._codeStrs[i]);
        }
        iOBase.putLine("END");
    }

    public final synchronized LogoList getCode() throws LanguageException {
        if (this._code == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this._codeStrs.length; ++i) {
                stringBuffer.append(this._codeStrs[i]).append(Machine.LINE_SEPARATOR);
            }
            this._code = new Tokenizer(this._mach.getTokenizerCommentFlags()).tokenize(stringBuffer.toString());
        }
        return this._code;
    }

    public final int numArgs() {
        return this._params.length();
    }

    public final boolean isMacro() {
        return this._isMacro;
    }

    public static final void checkName(String string) throws LanguageException {
        if (string.length() == 0) {
            throw new LanguageException("Bad name: empty string");
        }
        try {
            double d = Double.valueOf(string);
            throw new LanguageException("Bad name: \"" + string + "\" looks like a number.");
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }
}

