/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.CaselessString;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoVoid;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SymbolTable {
    private Hashtable _hash = new Hashtable(4);
    private SymbolTable _next = null;

    SymbolTable pushOn(SymbolTable symbolTable) {
        this._next = symbolTable;
        return this;
    }

    SymbolTable next() {
        return this._next;
    }

    public final synchronized void declare(CaselessString caselessString, Machine machine) {
        if (!this._hash.containsKey(caselessString)) {
            LogoObject logoObject = machine.resolveName(caselessString);
            this._hash.put(caselessString, logoObject == null ? LogoVoid.obj : logoObject);
        }
    }

    public final synchronized boolean make(CaselessString caselessString, LogoObject logoObject) {
        if (this._hash.remove(caselessString) == null) {
            return false;
        }
        this._hash.put(caselessString, logoObject);
        return true;
    }

    public final synchronized void makeForced(CaselessString caselessString, LogoObject logoObject) {
        this._hash.remove(caselessString);
        this._hash.put(caselessString, logoObject);
    }

    public final synchronized LogoObject resolve(CaselessString caselessString) {
        LogoObject logoObject = (LogoObject)this._hash.get(caselessString);
        return logoObject == LogoVoid.obj ? null : logoObject;
    }

    public final synchronized boolean exists(CaselessString caselessString) {
        return this._hash.containsKey(caselessString);
    }

    public final synchronized boolean erase(CaselessString caselessString) {
        return this._hash.remove(caselessString) != null;
    }

    public final synchronized void eraseAll() {
        this._hash.clear();
    }

    public final synchronized LogoList getNames() {
        Vector<LogoWord> vector = new Vector<LogoWord>();
        Enumeration enumeration = this._hash.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new LogoWord((CaselessString)enumeration.nextElement()));
        }
        return new LogoList(vector);
    }

    final synchronized Enumeration getEnumeratedNames() {
        return this._hash.keys();
    }
}

