/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoList;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoObject;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LogoWord;
import java.util.Vector;

public final class Tokenizer {
    private int _index;
    private String _str;
    private char _ch;
    private int _flags;
    public static final int HONOR_COMMENTS = 1;
    public static final int HASH_COMMENT = 2;

    public Tokenizer(int n) {
        this._flags = n;
    }

    public LogoList tokenize(String string) throws LanguageException {
        this._index = 0;
        this._str = string;
        this.nextChar();
        return new LogoList(this.build(true));
    }

    final LogoList tokenizeRunnable(LogoList logoList) throws LanguageException {
        Vector<LogoObject> vector = new Vector<LogoObject>();
        for (int i = 0; i < logoList.length(); ++i) {
            LogoObject logoObject = logoList.pickInPlace(i);
            if (logoObject instanceof LogoList) {
                vector.addElement(logoObject);
                continue;
            }
            if (!(logoObject instanceof LogoWord)) continue;
            if (((LogoWord)logoObject).getType() == 1) {
                String string = logoObject.toString();
                if (string.length() > 0 && string.charAt(0) == ';') break;
                this._index = 0;
                this._str = logoObject.unparse();
                this.nextChar();
                this.buildRunnable(vector);
                continue;
            }
            vector.addElement(logoObject);
        }
        return new LogoList(vector);
    }

    private final Vector build(boolean bl) throws LanguageException {
        Vector<LogoObject> vector = new Vector<LogoObject>();
        block5: while (true) {
            this.skipWhiteSpace();
            switch (this._ch) {
                case '[': {
                    this.nextChar();
                    vector.addElement(new LogoList(this.build(false)));
                    continue block5;
                }
                case ']': {
                    if (bl) {
                        throw new LanguageException("Unmatched closing bracket");
                    }
                    this.nextChar();
                    return vector;
                }
                case '\u0000': {
                    if (!bl) {
                        throw new LanguageException("Unmatched opening bracket", '~');
                    }
                    return vector;
                }
            }
            if (this.isComment()) {
                while (true) {
                    if (this._ch == '\n' || this._ch == '\r' || this._ch == '\u0000') continue block5;
                    this.nextChar();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            block7: while (!this.isWhiteSpace() && this._ch != '[' && this._ch != ']' && this._ch != '\u0000' && !this.isComment()) {
                stringBuffer2.append(this._ch);
                if (this._ch == '\\') {
                    this.nextChar();
                    if (this._ch == '\u0000') {
                        throw new LanguageException("Hanging backslash", '\\');
                    }
                    stringBuffer2.append(this._ch);
                    this.appendEscape(stringBuffer);
                    this.nextChar();
                    continue;
                }
                if (this._ch == '|') {
                    this.nextChar();
                    while (true) {
                        if (this._ch == '\u0000') {
                            throw new LanguageException("Unmatched \"|\"", '|');
                        }
                        stringBuffer2.append(this._ch);
                        if (this._ch == '|') {
                            this.nextChar();
                            continue block7;
                        }
                        stringBuffer.append(this._ch);
                        this.nextChar();
                    }
                }
                stringBuffer.append(this._ch);
                this.nextChar();
            }
            vector.addElement(new LogoWord(stringBuffer.toString(), stringBuffer2.toString()));
        }
    }

    private final void buildRunnable(Vector vector) throws LanguageException {
        boolean bl = true;
        block7: while (true) {
            switch (this._ch) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '/': 
                case '=': {
                    vector.addElement(new LogoWord(this._ch));
                    bl = this._ch == '(';
                    this.nextChar();
                    continue block7;
                }
                case '-': {
                    this.nextChar();
                    if (bl && !this.isWhiteSpace() && this._ch != '\u0000') {
                        vector.addElement(new LogoWord("-", "-"));
                    } else {
                        vector.addElement(new LogoWord('-'));
                    }
                    bl = false;
                    continue block7;
                }
                case '<': {
                    this.nextChar();
                    if (this._ch == '=') {
                        vector.addElement(new LogoWord('<', '='));
                        this.nextChar();
                    } else {
                        vector.addElement(new LogoWord('<'));
                    }
                    bl = false;
                    continue block7;
                }
                case '>': {
                    this.nextChar();
                    if (this._ch == '=') {
                        vector.addElement(new LogoWord('>', '='));
                        this.nextChar();
                    } else {
                        vector.addElement(new LogoWord('>'));
                    }
                    bl = false;
                    continue block7;
                }
                case '\u0000': {
                    return;
                }
            }
            boolean bl2 = this._ch == '\"';
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            block8: while (!this.isWhiteSpace() && this._ch != '\u0000' && this._ch != '(' && this._ch != ')' && (bl2 || this._ch != '*' && this._ch != '/' && this._ch != '+' && this._ch != '-' && this._ch != '=' && this._ch != '<' && this._ch != '>')) {
                stringBuffer2.append(this._ch);
                if (this._ch == '\\') {
                    this.nextChar();
                    if (this._ch == '\u0000') {
                        throw new LanguageException("Hanging backslash", '\\');
                    }
                    stringBuffer2.append(this._ch);
                    this.appendEscape(stringBuffer);
                    this.nextChar();
                    continue;
                }
                if (this._ch == '|') {
                    this.nextChar();
                    while (true) {
                        if (this._ch == '\u0000') {
                            throw new LanguageException("Unmatched \"|\"", '|');
                        }
                        stringBuffer2.append(this._ch);
                        if (this._ch == '|') {
                            this.nextChar();
                            continue block8;
                        }
                        stringBuffer.append(this._ch);
                        this.nextChar();
                    }
                }
                stringBuffer.append(this._ch);
                this.nextChar();
            }
            vector.addElement(new LogoWord(stringBuffer.toString(), stringBuffer2.toString()));
            bl = false;
        }
    }

    private final boolean isWhiteSpace() {
        return this._ch == ' ' || this._ch == '\t' || this._ch == '\n' || this._ch == '\r';
    }

    private final boolean isComment() {
        return (this._flags & 1) != 0 && this._ch == ';' || this._ch == '#' && (this._flags & 2) != 0;
    }

    private final void skipWhiteSpace() {
        while (this.isWhiteSpace()) {
            this.nextChar();
        }
    }

    private final void nextChar() {
        this._ch = this._index == this._str.length() ? (char)'\u0000' : this._str.charAt(this._index++);
    }

    private final void appendEscape(StringBuffer stringBuffer) {
        if (this._ch == 'n') {
            stringBuffer.append('\n');
        } else if (this._ch == 't') {
            stringBuffer.append('\t');
        } else if (this._ch == 'r') {
            stringBuffer.append('\r');
        } else if (this._ch == '0') {
            stringBuffer.append('\u0000');
        } else {
            stringBuffer.append(this._ch);
        }
    }
}

