/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.app;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOStream;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.IOWriteFile;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.InterpreterThread;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.LanguageException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.app.InteractiveConsole;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.app.MessageWind;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

public class GuiConsole
extends InteractiveConsole {
    static final int BUFFER_SIZE = 4096;
    static final int OUTPUT_LENGTH = 4096;
    static final int HISTORY_SIZE = 20;
    GuiConsoleWind _wind;
    MenuActor _menuActor;
    Vector _buf;
    Vector _editors;
    String _curPrompt;
    boolean _copyPrompt;
    Clipboard _clipboard;
    Font _monofont;

    @Override
    protected void setup() throws SetupException {
        try {
            this._monofont = Font.decode("Monospaced");
            this._clipboard = new Clipboard("private");
            this._menuActor = new MenuActor();
            this._wind = new GuiConsoleWind();
        }
        catch (Throwable throwable) {
            throw new SetupException("Unable to set up graphical console: " + throwable.toString());
        }
        this._buf = new Vector();
        this._editors = new Vector();
        this._curPrompt = new String();
        this._copyPrompt = false;
        this.putStatusMessage("Turtle Tracks graphical console and editor v1.0");
    }

    synchronized String popBuffer() {
        if (this._buf.size() == 0) {
            return null;
        }
        String string = (String)this._buf.firstElement();
        this._buf.removeElementAt(0);
        return string;
    }

    synchronized void pushBuffer(String string) {
        this._buf.addElement(string);
        this.notifyAll();
    }

    @Override
    public synchronized boolean eof() {
        return false;
    }

    @Override
    public synchronized String getLine() {
        String string = this.popBuffer();
        while (string == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string = this.popBuffer();
        }
        this.putLine(string);
        if (string.length() > 0) {
            this._wind.insertHistory(string);
        }
        return string;
    }

    @Override
    public synchronized String promptGetLine(char c) {
        this.put(c);
        this.put(' ');
        char[] cArray = new char[]{c, ' '};
        this._curPrompt = new String(cArray);
        this._copyPrompt = true;
        String string = this.popBuffer();
        while (string == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string = this.popBuffer();
        }
        this._curPrompt = new String();
        this.putLine(string);
        if (string.length() > 0) {
            this._wind.insertHistory(string);
        }
        return string;
    }

    @Override
    public synchronized int getAvailable(char[] cArray) {
        String string = null;
        if (this._buf.size() != 0) {
            string = (String)this._buf.firstElement();
            if (string.length() > cArray.length - 1) {
                this._buf.setElementAt(string.substring(cArray.length - 1), 0);
                string = string.substring(0, cArray.length - 1).concat(Machine.LINE_SEPARATOR);
            } else {
                this._buf.removeElementAt(0);
                string = string.concat(Machine.LINE_SEPARATOR);
            }
        }
        if (string == null) {
            return 0;
        }
        string.getChars(0, string.length(), cArray, 0);
        return string.length();
    }

    @Override
    public synchronized void put(char c) {
        this._wind.put(String.valueOf(c));
    }

    @Override
    public synchronized void put(String string) {
        this._wind.put(string);
    }

    @Override
    public synchronized void put(char[] cArray, int n) {
        this._wind.put(new String(cArray, 0, n));
    }

    @Override
    public synchronized void putLine(String string) {
        this._wind.put(string + '\n');
    }

    @Override
    public synchronized char getChar() {
        return this._wind.getChar();
    }

    @Override
    public synchronized boolean charAvail() {
        return this._wind.charAvail();
    }

    @Override
    public synchronized void createEditor(String string) throws LanguageException {
        this._editors.addElement(new GuiEditorWind(string));
    }

    @Override
    protected void exiting() {
        for (int i = 0; i < this._editors.size(); ++i) {
            ((GuiEditorWind)this._editors.elementAt(i)).dispose();
        }
        this._wind.dispose();
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            if (window instanceof GuiConsoleWind) {
                int n = MessageWind.execute(MessageWind.genStrings("Are you sure you want to quit Turtle Tracks?"), MessageWind.genStrings("Quit", "Cancel"), (GuiConsoleWind)window);
                if (n == 0) {
                    GuiConsole.this.goodbye();
                    GuiConsole.this.mach().terminateAllThreads();
                    GuiConsole.this.pushBuffer(new String());
                }
            } else if (window instanceof GuiEditorWind) {
                GuiEditorWind guiEditorWind = (GuiEditorWind)window;
                int n = MessageWind.execute(MessageWind.genStrings("Do you want to execute or save your edits before closing?"), MessageWind.genStrings("Execute", "Save To File", "Discard", "Cancel"), guiEditorWind);
                if (n == 0) {
                    guiEditorWind.acceptEdits();
                } else if (n == 1 && !guiEditorWind.saveToFile()) {
                    return;
                }
                if (n != 3) {
                    GuiConsole.this._editors.removeElement(guiEditorWind);
                    guiEditorWind.dispose();
                }
            }
        }
    }

    class GuiEditorWind
    extends Frame
    implements ActionListener {
        TextArea _textArea;

        GuiEditorWind(String string) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.setTitle("Turtle Tracks Editor");
            this.setBackground(Color.lightGray);
            this._textArea = new TextArea(string, 30, 80);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this._textArea, gridBagConstraints);
            this._textArea.setBackground(Color.white);
            this._textArea.setFont(GuiConsole.this._monofont);
            this.add(this._textArea);
            MenuBar menuBar = new MenuBar();
            Menu menu = new Menu("File");
            MenuItem menuItem = new MenuItem("New Editor");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("NEW ");
            menuItem.setShortcut(new MenuShortcut(78));
            menu.add(menuItem);
            menuItem = new MenuItem("Open Into Editor...");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("OPEN");
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new MenuItem("Execute without closing");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("ACCP");
            menuItem.setShortcut(new MenuShortcut(69));
            menu.add(menuItem);
            menuItem = new MenuItem("Close And Execute");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("CLAC");
            menuItem.setShortcut(new MenuShortcut(87));
            menu.add(menuItem);
            menuItem = new MenuItem("Close And Discard");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("CLDS");
            menu.add(menuItem);
            menuItem = new MenuItem("Save As...");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("SAVE");
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new MenuItem("Quit");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("QUIT");
            menuItem.setShortcut(new MenuShortcut(81));
            menu.add(menuItem);
            menuBar.add(menu);
            menu = new Menu("Edit");
            menuItem = new MenuItem("Undo");
            menuItem.setEnabled(false);
            menuItem.addActionListener(this);
            menuItem.setActionCommand("UNDO");
            menuItem.setShortcut(new MenuShortcut(90));
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new MenuItem("Cut");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("CUT ");
            menuItem.setShortcut(new MenuShortcut(88));
            menu.add(menuItem);
            menuItem = new MenuItem("Copy");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("COPY");
            menuItem.setShortcut(new MenuShortcut(67));
            menu.add(menuItem);
            menuItem = new MenuItem("Paste");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("PAST");
            menuItem.setShortcut(new MenuShortcut(86));
            menu.add(menuItem);
            menuItem = new MenuItem("Clear");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("CLER");
            menuItem.setShortcut(new MenuShortcut(66));
            menu.add(menuItem);
            menuBar.add(menu);
            this.setMenuBar(menuBar);
            this.addWindowListener(new WindowHandler());
            this.pack();
            this.show();
            this._textArea.requestFocus();
        }

        void acceptEdits() {
            InterpreterThread interpreterThread = new InterpreterThread(GuiConsole.this.mach(), new IOStream(new BufferedReader(new StringReader(this._textArea.getText()))));
            interpreterThread.setPriority(GuiConsole.this._priority);
            interpreterThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean saveToFile() {
            FileDialog fileDialog = new FileDialog((Frame)this, "Save Edits", 1);
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string == null) {
                return false;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(fileDialog.getDirectory(), string)));
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(this._textArea.getText()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        bufferedWriter.write(string2);
                        bufferedWriter.newLine();
                    }
                    bufferedReader.close();
                }
                finally {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                GuiConsole.this.putLine("Error saving file: " + iOException.toString());
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ACCP")) {
                this.acceptEdits();
            } else if (string.equals("CLAC")) {
                this.acceptEdits();
                GuiConsole.this._editors.removeElement(this);
                this.dispose();
            } else if (string.equals("CLDS")) {
                GuiConsole.this._editors.removeElement(this);
                this.dispose();
            } else if (string.equals("SAVE")) {
                this.saveToFile();
            } else if (string.equals("QUIT")) {
                int n = MessageWind.execute(MessageWind.genStrings("Are you sure you want to quit Turtle Tracks?"), MessageWind.genStrings("Quit", "Cancel"), this);
                if (n == 0) {
                    GuiConsole.this.goodbye();
                    GuiConsole.this.mach().terminateAllThreads();
                    GuiConsole.this.pushBuffer(new String());
                }
            } else if (!string.equals("UNDO")) {
                if (string.equals("CUT ")) {
                    int n = this._textArea.getSelectionStart();
                    int n2 = this._textArea.getSelectionEnd();
                    StringSelection stringSelection = new StringSelection(this._textArea.getText().substring(n, n2));
                    try {
                        this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                    }
                    catch (SecurityException securityException) {
                        GuiConsole.this._clipboard.setContents(stringSelection, stringSelection);
                    }
                    this._textArea.replaceRange(new String(), n, n2);
                    this._textArea.setCaretPosition(n);
                    this._textArea.select(n, n);
                } else if (string.equals("COPY")) {
                    StringSelection stringSelection = new StringSelection(this._textArea.getSelectedText());
                    try {
                        this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                    }
                    catch (SecurityException securityException) {
                        GuiConsole.this._clipboard.setContents(stringSelection, stringSelection);
                    }
                } else if (string.equals("PAST")) {
                    try {
                        String string2;
                        try {
                            Transferable transferable = this.getToolkit().getSystemClipboard().getContents(this);
                            string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        }
                        catch (SecurityException securityException) {
                            Transferable transferable = GuiConsole.this._clipboard.getContents(this);
                            string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        }
                        int n = this._textArea.getSelectionStart();
                        int n3 = n + string2.length();
                        this._textArea.replaceRange(string2, n, this._textArea.getSelectionEnd());
                        this._textArea.setCaretPosition(n3);
                        this._textArea.select(n3, n3);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {}
                } else if (string.equals("CLER")) {
                    int n = this._textArea.getSelectionStart();
                    this._textArea.replaceRange(new String(), n, this._textArea.getSelectionEnd());
                    this._textArea.setCaretPosition(n);
                    this._textArea.select(n, n);
                }
            }
        }

        public boolean equals(Object object) {
            if (object instanceof GuiEditorWind) {
                return (GuiEditorWind)object == this;
            }
            return false;
        }
    }

    class GuiConsoleWind
    extends Frame
    implements ActionListener,
    FocusListener,
    KeyListener {
        TextArea _entryArea;
        TextArea _historyArea;
        int _historyLength;
        Vector _history;
        int _historyPos;
        MenuItem _cutItem;
        MenuItem _pasteItem;
        MenuItem _clearItem;

        GuiConsoleWind() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.setTitle("Turtle Tracks Console");
            this.setBackground(Color.lightGray);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 16;
            Label label = new Label("  History:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            this._historyArea = new TextArea(24, 80);
            this._historyArea.setEditable(false);
            this._historyArea.setBackground(Color.white);
            this._historyArea.setFont(GuiConsole.this._monofont);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this._historyArea, gridBagConstraints);
            this.add(this._historyArea);
            this._historyLength = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            label = new Label("  Enter command:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            this._entryArea = new TextArea(4, 80);
            this._entryArea.setBackground(Color.white);
            this._entryArea.addFocusListener(this);
            this._entryArea.addKeyListener(this);
            this._entryArea.setFont(GuiConsole.this._monofont);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this._entryArea, gridBagConstraints);
            this.add(this._entryArea);
            MenuBar menuBar = new MenuBar();
            Menu menu = new Menu("File");
            MenuItem menuItem = new MenuItem("New Editor");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("NEW ");
            menuItem.setShortcut(new MenuShortcut(78));
            menu.add(menuItem);
            menuItem = new MenuItem("Open Into Editor...");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("OPEN");
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new MenuItem("Load State...");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("LODM");
            menuItem.setShortcut(new MenuShortcut(76));
            menu.add(menuItem);
            menuItem = new MenuItem("Save State...");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("SAVM");
            menuItem.setShortcut(new MenuShortcut(83));
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new MenuItem("Quit");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("QUIT");
            menuItem.setShortcut(new MenuShortcut(81));
            menu.add(menuItem);
            menuBar.add(menu);
            menu = new Menu("Edit");
            menuItem = new MenuItem("Undo");
            menuItem.setEnabled(false);
            menuItem.addActionListener(this);
            menuItem.setActionCommand("UNDO");
            menuItem.setShortcut(new MenuShortcut(90));
            menu.add(menuItem);
            menu.addSeparator();
            this._cutItem = new MenuItem("Cut");
            this._cutItem.addActionListener(this);
            this._cutItem.setActionCommand("CUT ");
            this._cutItem.setShortcut(new MenuShortcut(88));
            menu.add(this._cutItem);
            menuItem = new MenuItem("Copy");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("COPY");
            menuItem.setShortcut(new MenuShortcut(67));
            menu.add(menuItem);
            this._pasteItem = new MenuItem("Paste");
            this._pasteItem.addActionListener(this);
            this._pasteItem.setActionCommand("PAST");
            this._pasteItem.setShortcut(new MenuShortcut(86));
            menu.add(this._pasteItem);
            this._clearItem = new MenuItem("Clear");
            this._clearItem.addActionListener(this);
            this._clearItem.setActionCommand("CLER");
            this._clearItem.setShortcut(new MenuShortcut(66));
            menu.add(this._clearItem);
            menu.addSeparator();
            menuItem = new MenuItem("Clear History");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("CLRH");
            menu.add(menuItem);
            menuBar.add(menu);
            menu = new Menu("Environment");
            menuItem = new MenuItem("Reset Environment");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("RSET");
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new MenuItem("Interrupt");
            menuItem.addActionListener(GuiConsole.this._menuActor);
            menuItem.setActionCommand("INTR");
            menuItem.setShortcut(new MenuShortcut(73));
            menu.add(menuItem);
            menuBar.add(menu);
            this.setMenuBar(menuBar);
            this._history = new Vector(22);
            this._historyPos = -1;
            this.addWindowListener(new WindowHandler());
            this.pack();
            this.show();
            this._entryArea.requestFocus();
        }

        private void cropHistory() {
            String string = this._historyArea.getText();
            int n = 0;
            while (this._historyLength > 4096) {
                int n2 = string.indexOf(10, n);
                if (n2 >= this._historyLength - 10 || n2 == -1) {
                    return;
                }
                this._historyArea.replaceRange(new String(), 0, n2 - n + 1);
                n = n2 + 1;
                this._historyLength -= n2 + 1;
            }
        }

        void insertHistory(String string) {
            this._history.insertElementAt(string, 0);
            if (this._history.size() > 20) {
                this._history.removeElementAt(this._history.size() - 1);
            }
        }

        void put(String string) {
            if (GuiConsole.this._curPrompt.length() > 0) {
                if (GuiConsole.this._copyPrompt) {
                    this._historyArea.append("\n" + string + GuiConsole.this._curPrompt);
                    GuiConsole.this._copyPrompt = false;
                    this._historyLength += GuiConsole.this._curPrompt.length() + 1;
                } else {
                    this._historyArea.insert(string, this._historyLength - GuiConsole.this._curPrompt.length());
                }
            } else {
                this._historyArea.append(string);
            }
            this._historyLength += string.length();
            this._historyArea.setCaretPosition(this._historyLength + 1);
            this.cropHistory();
        }

        char getChar() {
            String string = this._entryArea.getText();
            if (string.length() == 0) {
                return '\u0000';
            }
            this._entryArea.setText(string.substring(1));
            return string.charAt(0);
        }

        boolean charAvail() {
            return this._entryArea.getText().length() > 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("QUIT")) {
                int n = MessageWind.execute(MessageWind.genStrings("Are you sure you want to quit Turtle Tracks?"), MessageWind.genStrings("Quit", "Cancel"), this);
                if (n == 0) {
                    GuiConsole.this.goodbye();
                    GuiConsole.this.mach().terminateAllThreads();
                    GuiConsole.this.pushBuffer(new String());
                }
            } else if (string.equals("CLRH")) {
                this._historyArea.setText(GuiConsole.this._curPrompt);
                this._historyLength = GuiConsole.this._curPrompt.length();
            }
            Component component = this.getFocusOwner();
            if (!(component instanceof TextArea)) {
                return;
            }
            TextArea textArea = (TextArea)component;
            if (textArea == null) {
                return;
            }
            if (!string.equals("UNDO")) {
                if (string.equals("CUT ")) {
                    if (textArea == this._entryArea) {
                        int n = textArea.getSelectionStart();
                        int n2 = textArea.getSelectionEnd();
                        StringSelection stringSelection = new StringSelection(textArea.getText().substring(n, n2));
                        try {
                            this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                        }
                        catch (SecurityException securityException) {
                            GuiConsole.this._clipboard.setContents(stringSelection, stringSelection);
                        }
                        textArea.replaceRange(new String(), n, n2);
                        textArea.setCaretPosition(n);
                        textArea.select(n, n);
                    }
                } else if (string.equals("COPY")) {
                    StringSelection stringSelection = new StringSelection(textArea.getSelectedText());
                    try {
                        this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                    }
                    catch (SecurityException securityException) {
                        GuiConsole.this._clipboard.setContents(stringSelection, stringSelection);
                    }
                } else if (string.equals("PAST")) {
                    if (textArea == this._entryArea) {
                        try {
                            String string2;
                            try {
                                Transferable transferable = this.getToolkit().getSystemClipboard().getContents(this);
                                string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            }
                            catch (SecurityException securityException) {
                                Transferable transferable = GuiConsole.this._clipboard.getContents(this);
                                string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            }
                            int n = textArea.getSelectionStart();
                            int n3 = n + string2.length();
                            textArea.replaceRange(string2, n, textArea.getSelectionEnd());
                            textArea.setCaretPosition(n3);
                            textArea.select(n3, n3);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                        }
                        catch (IOException iOException) {}
                    }
                } else if (string.equals("CLER") && textArea == this._entryArea) {
                    int n = textArea.getSelectionStart();
                    textArea.replaceRange(new String(), n, textArea.getSelectionEnd());
                    textArea.setCaretPosition(n);
                    textArea.select(n, n);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this._cutItem.setEnabled(true);
            this._pasteItem.setEnabled(true);
            this._clearItem.setEnabled(true);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this._cutItem.setEnabled(false);
            this._pasteItem.setEnabled(false);
            this._clearItem.setEnabled(false);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\n' || c == '\r') {
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                GuiConsole.this.pushBuffer(this._entryArea.getText());
                this._entryArea.setText("");
                this._historyPos = -1;
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 38) {
                if (this._historyPos < this._history.size() - 1) {
                    ++this._historyPos;
                    String string = (String)this._history.elementAt(this._historyPos);
                    int n = string.length();
                    this._entryArea.setText(string);
                    this._entryArea.setCaretPosition(n);
                    this._entryArea.select(n, n);
                }
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 40) {
                if (this._historyPos > -1) {
                    --this._historyPos;
                    if (this._historyPos > -1) {
                        String string = (String)this._history.elementAt(this._historyPos);
                        int n = string.length();
                        this._entryArea.setText(string);
                        this._entryArea.setCaretPosition(n);
                        this._entryArea.select(n, n);
                    } else {
                        this._entryArea.setText("");
                    }
                }
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class MenuActor
    implements ActionListener {
        MenuActor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("NEW ")) {
                try {
                    GuiConsole.this.createEditor("");
                }
                catch (LanguageException languageException) {}
            } else if (string.equals("OPEN")) {
                FileDialog fileDialog = new FileDialog((Frame)GuiConsole.this._wind, "Open File");
                fileDialog.show();
                String string2 = fileDialog.getFile();
                if (string2 == null) {
                    return;
                }
                try {
                    int n;
                    File file = new File(fileDialog.getDirectory(), string2);
                    FileReader fileReader = new FileReader(file);
                    char[] cArray = new char[4096];
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = fileReader.read(cArray)) != -1) {
                        stringBuffer.append(cArray, 0, n);
                    }
                    try {
                        GuiConsole.this.createEditor(stringBuffer.toString());
                    }
                    catch (LanguageException languageException) {
                    }
                }
                catch (IOException iOException) {
                    GuiConsole.this.putLine("Couldn't read file: " + iOException.toString());
                }
            } else if (string.equals("LODM")) {
                FileDialog fileDialog = new FileDialog((Frame)GuiConsole.this._wind, "Load Contents");
                fileDialog.show();
                String string3 = fileDialog.getFile();
                if (string3 == null) {
                    return;
                }
                try {
                    File file = new File(fileDialog.getDirectory(), string3);
                    InterpreterThread interpreterThread = new InterpreterThread(GuiConsole.this.mach(), new IOStream(new BufferedReader(new FileReader(file))));
                    interpreterThread.setPriority(GuiConsole.this._priority);
                    interpreterThread.start();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    GuiConsole.this.putLine("File \"" + string3 + "\" not found.");
                }
            } else if (string.equals("SAVM")) {
                FileDialog fileDialog = new FileDialog((Frame)GuiConsole.this._wind, "Save Contents", 1);
                fileDialog.show();
                String string4 = fileDialog.getFile();
                if (string4 == null) {
                    return;
                }
                try {
                    IOWriteFile iOWriteFile = new IOWriteFile(new File(fileDialog.getDirectory(), string4));
                    GuiConsole.this.mach().printout(iOWriteFile, null, null, null);
                    iOWriteFile.close();
                }
                catch (LanguageException languageException) {
                    GuiConsole.this.putLine("Error saving state: " + languageException.generateMessage());
                }
            } else if (string.equals("RSET")) {
                GuiConsole.this.mach().terminateAllThreads();
                GuiConsole.this.mach().eraseAll();
            } else if (string.equals("INTR")) {
                GuiConsole.this.mach().terminateAllThreads();
            } else if (string.equals("PAUS")) {
                // empty if block
            }
        }
    }
}

