/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.logoturtleide.virtuoso.logo.app;

import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Console;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.Machine;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.PrimitiveGroup;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.SetupException;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.app.GuiConsole;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib.LibraryPrimitives;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib.NetworkPrimitives;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib.StandardPrimitives;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib.ThreadPrimitives;
import ch.karatojava.kapps.logoturtleide.virtuoso.logo.lib.TurtlePrimitives;
import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TurtleApplet
extends Applet
implements Runnable,
ActionListener {
    private Thread machineThread = null;
    private Machine machine = null;
    private Label label;
    private Button button;
    private Thread myThread;

    @Override
    public void init() {
        this.setLayout(new GridLayout(0, 1));
        this.label = new Label("Initializing...", 1);
        this.button = new Button("Start");
        this.button.setEnabled(false);
        this.button.addActionListener(this);
        this.add(this.label);
        this.add(this.button);
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    @Override
    public void destroy() {
        if (this.machineThread != null && !this.machineThread.isAlive()) {
            this.machine.console().goodbye();
            this.machine.terminateAllThreads();
            try {
                this.machineThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.machineThread != null && this.machineThread.isAlive()) {
            return;
        }
        TurtleApplet turtleApplet = this;
        synchronized (turtleApplet) {
            this.label.setText("Turtle Tracks Loading...");
            this.button.setEnabled(false);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Runnable runnable = this;
            synchronized (runnable) {
                this.label.setText("Turtle Tracks Stopped");
                this.button.setEnabled(true);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            runnable = new GuiConsole();
            PrimitiveGroup[] primitiveGroupArray = new PrimitiveGroup[]{new StandardPrimitives(), new NetworkPrimitives(), new ThreadPrimitives(), new LibraryPrimitives(), new TurtlePrimitives()};
            this.machine = new Machine((Console)runnable, primitiveGroupArray);
            try {
                this.machine.setup();
            }
            catch (SetupException setupException) {
                System.err.println("The environment couldn't be started.");
                System.err.println(setupException.getMessage());
                return;
            }
            this.machineThread = new Thread(runnable);
            this.machineThread.start();
            this.label.setText("Turtle Tracks Running");
            try {
                this.machineThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.machine.cleanup();
            this.label.setText("Turtle Tracks Stopped");
        }
    }
}

