/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.SensorType;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.multikaraide.worldobjects.MEETINGROOMFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.MONITORFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.STREET;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldObjectInterface;
import javax.swing.ImageIcon;

public class MultiKaraExtendedWorldSensor
extends SensorType {
    private WorldObjectInterface[] worldObjects = new WorldObjectInterface[4];

    public MultiKaraExtendedWorldSensor(String string) {
        super(string);
    }

    public MultiKaraExtendedWorldSensor(String string, String string2, ImageIcon imageIcon) {
        super(string, string2, imageIcon);
    }

    public MultiKaraExtendedWorldSensor(String string, String string2) {
        super(string, string2);
    }

    public void setField(int n, WorldObjectInterface worldObjectInterface) {
        this.worldObjects[n] = worldObjectInterface;
    }

    public static int getRelativeXCoord(int n) {
        return n - 1 - 2 * (n / 3);
    }

    public static int getRelativeYCoord(int n) {
        return n / 3;
    }

    public static int getImageXCoord(int n) {
        return n - 2 * (n / 3);
    }

    public static int getImageYCoord(int n) {
        return 1 - n / 3;
    }

    public WorldObjectInterface getWorldObject(int n) {
        return this.worldObjects[n];
    }

    private int getXCoord(double d, int n, int n2, World world) {
        int n3 = (int)d;
        if (n2 == 3) {
            if (n == 1) {
                return (n3 - 1 + world.getSizeX()) % world.getSizeX();
            }
            if (n == 3) {
                return (n3 + 1) % world.getSizeX();
            }
        }
        if (n2 == 0) {
            if (n == 0) {
                return (n3 - 1 + world.getSizeX()) % world.getSizeX();
            }
            if (n == 2) {
                return (n3 + 1) % world.getSizeX();
            }
        }
        if (n2 == 2) {
            if (n == 0) {
                return (n3 + 1) % world.getSizeX();
            }
            if (n == 2) {
                return (n3 - 1 + world.getSizeX()) % world.getSizeX();
            }
        }
        return n3;
    }

    private int getYCoord(double d, int n, int n2, World world) {
        int n3 = (int)d;
        if (n2 == 3) {
            if (n == 0) {
                return (n3 - 1 + world.getSizeY()) % world.getSizeY();
            }
            if (n == 2) {
                return (n3 + 1) % world.getSizeY();
            }
        } else if (n2 % 2 == 0 && n % 2 == 1) {
            return (n3 + (2 - n) * (1 - n2) + world.getSizeY()) % world.getSizeY();
        }
        return n3;
    }

    @Override
    public boolean evaluate(Object object) {
        Kara kara = (Kara)object;
        World world = kara.getWorld();
        boolean bl = true;
        for (int i = 0; i < this.worldObjects.length; ++i) {
            int n;
            boolean bl2;
            Object object2;
            if (this.worldObjects[i] == null) continue;
            int n2 = this.getXCoord(kara.getPosition().getX(), kara.getDirection(), i, world);
            int n3 = this.getYCoord(kara.getPosition().getY(), kara.getDirection(), i, world);
            if (this.worldObjects[i].getType() == 0 && i == 1) {
                WorldField worldField = world.getWorldFieldAt(n2, n3);
                object2 = worldField.getStack();
                bl2 = false;
                for (n = 0; n < ((WorldObjectInterface[])object2).length && !bl2; ++n) {
                    if (object2[n] == null || object2[n].getType() == kara.getType() || object2[n].equals(MEETINGROOMFIELD.getInstance()) || object2[n].equals(MONITORFIELD.getInstance())) continue;
                    bl2 = true;
                }
                bl = bl && !bl2;
                continue;
            }
            if (this.worldObjects[i].getType() == 0) {
                WorldField worldField = world.getWorldFieldAt(n2, n3);
                object2 = worldField.getStack();
                bl2 = false;
                for (n = 0; n < ((WorldObjectInterface[])object2).length && !bl2; ++n) {
                    if (object2[n] == null || object2[n].equals(MEETINGROOMFIELD.getInstance()) || object2[n].equals(MONITORFIELD.getInstance())) continue;
                    bl2 = true;
                }
                bl = bl && !bl2;
                continue;
            }
            if (this.worldObjects[i].getType() == 8) {
                bl = bl && world.isObjectOfTypeAt(this.worldObjects[i], n2, n3);
                continue;
            }
            if (this.worldObjects[i].getType() == 2) {
                if (((LEAF)this.worldObjects[i]).getLeafType() == 0) {
                    bl = bl && world.isObjectOfTypeAt(LEAF.getInstance(), n2, n3);
                    continue;
                }
                bl = bl && world.isObjectAt(LEAF.getInstance(Kara.getKara(kara.getIdentity()).getIntegerIdentifier()), n2, n3);
                continue;
            }
            if (this.worldObjects[i].getType() == 16) {
                int n4 = ((STREET)this.worldObjects[i]).getStreetType() << kara.getDirection();
                object2 = (STREET)world.getObjectOfTypeAt(STREET.getInstance(n4 = n4 % 16 + n4 / 16), n2, n3);
                if (object2 != null) {
                    bl = (((STREET)object2).getStreetType() & n4) > 0 && bl;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = bl && world.isObjectAt(this.worldObjects[i], n2, n3);
        }
        return bl;
    }
}

