/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.kapps.actorfsm.CommandTypeInterface;
import ch.karatojava.kapps.actorfsm.SingleActorFsmInterpreter;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.multikaraide.ConcurrencyObject;
import ch.karatojava.kapps.multikaraide.Meetingroom;
import ch.karatojava.kapps.multikaraide.Monitor;
import ch.karatojava.kapps.multikaraide.MultiKaraScheduler;
import ch.karatojava.kapps.multikaraide.MultiKaraWorldEditorFacade;
import ch.karatojava.kapps.multikaraide.worldobjects.FORBIDDENFIELD;
import ch.karatojava.kapps.world.World;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;

public class MultiKaraFsmInterpreter
extends SingleActorFsmInterpreter {
    protected Hashtable<Transition, ArrayList<Point>> simulationStructure;
    protected MultiKaraScheduler scheduler;
    protected World worldBackup = null;
    protected MultiKaraWorldEditorFacade worldEditorFacade;
    protected int currentCommandMoveCount;
    protected int maxMoveCount;
    protected boolean forbiddenTransition;
    protected int forbiddenX;
    protected int forbiddenY;
    protected ArrayList<Integer> interpreterActions;
    protected ArrayList<Object> interpreterActionObjects;
    protected ArrayList<String> interpreterActionKaraIDs;
    protected boolean abortExecutingThatStep;

    public MultiKaraFsmInterpreter(MultiKaraScheduler multiKaraScheduler, MultiKaraWorldEditorFacade multiKaraWorldEditorFacade) {
        this.scheduler = multiKaraScheduler;
        this.worldEditorFacade = multiKaraWorldEditorFacade;
    }

    @Override
    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
        super.setStateMachine(stateMachine);
    }

    public State getStartState() {
        if (this.stateMachine != null) {
            return this.stateMachine.getStartState();
        }
        return null;
    }

    @Override
    public void getReady() throws InterpreterException {
        ConcurrencyObject concurrencyObject;
        super.getReady();
        this.interpreterActions = new ArrayList();
        this.interpreterActionObjects = new ArrayList();
        this.interpreterActionKaraIDs = new ArrayList();
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        Kara kara = Kara.findKaraInWorld(world, this.actor.getName());
        Point point = kara.getPosition();
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        ConcurrencyObject concurrencyObject2 = this.checkPositionForMeetingroom(n, n2);
        if (concurrencyObject2 != null) {
            this.setInterpreterAction(200, concurrencyObject2, this.actor.getName());
        }
        if ((concurrencyObject = this.checkPositionForMonitor(n, n2)) != null) {
            this.setInterpreterAction(300, concurrencyObject, this.actor.getName());
        }
        if (this.currentState.isBarrierState()) {
            this.setInterpreterAction(400, this.currentState, this.actor.getName());
        }
        if (this.currentState.isCriticalSectionState()) {
            this.setInterpreterAction(500, this.currentState, this.actor.getName());
        }
        this.processActions();
        this.simulationStructure = new Hashtable();
        State[] stateArray = this.stateMachine.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            State state = stateArray[i];
            Transition[] transitionArray = state.getTransitions();
            for (int j = 0; j < transitionArray.length; ++j) {
                Transition transition = transitionArray[j];
                ArrayList<Point> arrayList = new ArrayList<Point>();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                CommandTypeInterface[] commandTypeInterfaceArray = transition.getCommands();
                for (int k = 0; k < commandTypeInterfaceArray.length; ++k) {
                    if (commandTypeInterfaceArray[k].getName().equals("move")) {
                        if (n3 == 0) {
                            --n5;
                        }
                        if (n3 == 1) {
                            --n4;
                        }
                        if (n3 == 3) {
                            ++n4;
                        }
                        if (n3 == 2) {
                            ++n5;
                        }
                        arrayList.add(new Point(n4, n5));
                        n4 = 0;
                        n5 = 0;
                    }
                    if (commandTypeInterfaceArray[k].getName().equals("turnLeft")) {
                        n3 = (n3 + 1) % 4;
                    }
                    if (!commandTypeInterfaceArray[k].getName().equals("turnRight")) continue;
                    n3 = (n3 + 3) % 4;
                }
                this.simulationStructure.put(transition, arrayList);
            }
        }
    }

    @Override
    public void beginCompositeStep() throws InterpreterException {
        this.currentTransition = this.getNextTransition();
        this.currentCommandIndex = 0;
        this.maxMoveCount = 0;
        this.currentCommandMoveCount = 0;
        this.abortExecutingThatStep = false;
        if (this.currentTransition.getTo().isCriticalSectionState() && this.scheduler.criticalSectionBelongsTo.equals("")) {
            this.setInterpreterAction(500, this.currentState, this.actor.getName());
        }
        if (this.currentTransition.getTo().isCriticalSectionState() && !this.scheduler.criticalSectionBelongsTo.equals("") && !this.actor.getName().equals(this.scheduler.criticalSectionBelongsTo)) {
            this.abortExecutingThatStep = true;
            this.setInterpreterAction(100, MultiKaraScheduler.WAITING_FOR_CRITICALSECTION, this.actor.getName());
            this.currentCommandIndex = -1;
        }
        this.processActions();
        this.simulateTransition();
    }

    @Override
    public void executeStep() throws InterpreterException {
        if (this.abortExecutingThatStep) {
            this.currentCommandIndex = this.currentTransition.size();
            return;
        }
        if (this.currentTransition.size() > 0) {
            CommandTypeInterface commandTypeInterface = this.currentTransition.getCommand(this.currentCommandIndex);
            if (this.forbiddenTransition && this.currentCommandMoveCount >= this.maxMoveCount && commandTypeInterface.getName().equals("move")) {
                World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
                int n = this.scheduler.getStepableInterpreterWaitInterval();
                n = n * 2 / 5;
                try {
                    world.putObjectAt(FORBIDDENFIELD.getInstance(), this.forbiddenX, this.forbiddenY);
                    Thread.sleep(n);
                    world.removeObjectAt(FORBIDDENFIELD.getInstance(), this.forbiddenX, this.forbiddenY);
                    Thread.sleep(n);
                    world.putObjectAt(FORBIDDENFIELD.getInstance(), this.forbiddenX, this.forbiddenY);
                    Thread.sleep(n);
                    world.removeObjectAt(FORBIDDENFIELD.getInstance(), this.forbiddenX, this.forbiddenY);
                    Thread.sleep(n);
                    world.putObjectAt(FORBIDDENFIELD.getInstance(), this.forbiddenX, this.forbiddenY);
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.scheduler.changeWorld(this.worldBackup);
                this.processActions();
                this.currentCommandIndex = this.currentTransition.size();
            } else {
                this.actor.execute(commandTypeInterface);
                ++this.currentCommandIndex;
                if (commandTypeInterface.getName().equals("move")) {
                    ++this.currentCommandMoveCount;
                }
            }
        }
    }

    @Override
    public void endCompositeStep() throws InterpreterException {
        if (this.abortExecutingThatStep) {
            this.currentTransition = null;
            this.currentCommandIndex = -1;
            return;
        }
        if (this.forbiddenTransition) {
            this.forbiddenTransition = false;
        } else {
            State state = this.currentState;
            this.currentState = this.currentTransition.getTo();
            if (this.currentState.isBarrierState()) {
                this.setInterpreterAction(400, this.currentState, this.actor.getName());
            }
            if (state.isBarrierState()) {
                this.setInterpreterAction(401, state, this.actor.getName());
            }
            if (this.actor.getName().equals(this.scheduler.criticalSectionBelongsTo) && !this.currentState.isCriticalSectionState()) {
                this.setInterpreterAction(501, state, this.actor.getName());
            }
            this.processActions();
        }
        this.currentTransition = null;
        this.currentCommandIndex = -1;
    }

    public void setConcurrencyStatusOfAllBarrierStatesTo(State.ConcurrencyStatus concurrencyStatus) {
        State[] stateArray = this.stateMachine.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            if (!stateArray[i].isBarrierState()) continue;
            stateArray[i].setConcurrencyStatus(concurrencyStatus);
        }
    }

    public void setConcurrencyStatusOfAllCriticalSectionStatesTo(State.ConcurrencyStatus concurrencyStatus) {
        State[] stateArray = this.stateMachine.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            if (!stateArray[i].isCriticalSectionState()) continue;
            stateArray[i].setConcurrencyStatus(concurrencyStatus);
        }
    }

    protected void simulateTransition() throws InterpreterException {
        ConcurrencyObject concurrencyObject;
        ConcurrencyObject concurrencyObject2;
        this.clearInterpreterActions();
        this.worldBackup = new World((World)this.worldEditorFacade.getWorldEditor().getContent());
        ArrayList<Point> arrayList = this.simulationStructure.get(this.currentTransition);
        Kara kara = Kara.findKaraInWorld(this.worldBackup, this.actor.getName());
        Point point = kara.getPosition();
        int n = kara.getDirection();
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        ConcurrencyObject concurrencyObject3 = concurrencyObject2 = this.checkPositionForMeetingroom(n2, n3);
        ConcurrencyObject concurrencyObject4 = concurrencyObject = this.checkPositionForMonitor(n2, n3);
        int n4 = this.worldBackup.getSizeX();
        int n5 = this.worldBackup.getSizeY();
        for (int i = 0; i < arrayList.size(); ++i) {
            Point point2 = arrayList.get(i);
            if (n == 0) {
                n2 = (n2 + (int)point2.getX() + n4) % n4;
                n3 = (n3 + (int)point2.getY() + n5) % n5;
            }
            if (n == 1) {
                n2 = (n2 + (int)point2.getY() + n4) % n4;
                n3 = (n3 - (int)point2.getX() + n5) % n5;
            }
            if (n == 3) {
                n2 = (n2 - (int)point2.getY() + n4) % n4;
                n3 = (n3 + (int)point2.getX() + n5) % n5;
            }
            if (n == 2) {
                n2 = (n2 - (int)point2.getX() + n4) % n4;
                n3 = (n3 - (int)point2.getY() + n5) % n5;
            }
            if ((concurrencyObject3 = this.checkPositionForMeetingroom(n2, n3)) != null && concurrencyObject3.getState() == 2 && concurrencyObject2 != concurrencyObject3) {
                this.forbiddenTransition = true;
                this.forbiddenX = n2;
                this.forbiddenY = n3;
                this.maxMoveCount = i;
                this.setInterpreterAction(100, concurrencyObject3, this.actor.getName());
                return;
            }
            concurrencyObject4 = this.checkPositionForMonitor(n2, n3);
            if (concurrencyObject4 == null || concurrencyObject4.getState() != 2 || concurrencyObject == concurrencyObject4) continue;
            this.forbiddenTransition = true;
            this.forbiddenX = n2;
            this.forbiddenY = n3;
            this.maxMoveCount = i;
            this.setInterpreterAction(100, concurrencyObject4, this.actor.getName());
            return;
        }
        if (concurrencyObject3 != concurrencyObject2) {
            if (concurrencyObject2 != null && concurrencyObject2.getState() == 2) {
                this.setInterpreterAction(201, concurrencyObject2, this.actor.getName());
            }
            if (concurrencyObject3 != null && concurrencyObject3.getState() == 1) {
                this.setInterpreterAction(200, concurrencyObject3, this.actor.getName());
            }
        }
        if (concurrencyObject4 != concurrencyObject) {
            if (concurrencyObject != null && concurrencyObject.getState() == 2) {
                this.setInterpreterAction(301, concurrencyObject, this.actor.getName());
            }
            if (concurrencyObject4 != null && concurrencyObject4.getState() == 1) {
                this.setInterpreterAction(300, concurrencyObject4, this.actor.getName());
            }
        }
    }

    protected void processActions() {
        int n = 0;
        Object object = null;
        String string = "";
        for (int i = 0; i < this.interpreterActions.size(); ++i) {
            n = this.interpreterActions.get(i);
            object = this.interpreterActionObjects.get(i);
            string = this.interpreterActionKaraIDs.get(i);
            this.scheduler.processInterpreterAction(n, object, string);
        }
        this.clearInterpreterActions();
    }

    protected void clearInterpreterActions() {
        this.interpreterActions.clear();
        this.interpreterActionObjects.clear();
        this.interpreterActionKaraIDs.clear();
    }

    protected void setInterpreterAction(int n, Object object, String string) {
        this.interpreterActions.add(new Integer(n));
        this.interpreterActionObjects.add(object);
        this.interpreterActionKaraIDs.add(string);
    }

    public ConcurrencyObject checkPositionForMonitor(int n, int n2) {
        for (int i = 0; i < Monitor.getInstance().getFields().size(); ++i) {
            if (Monitor.getInstance().getFields().get(i).getX() != (double)n || Monitor.getInstance().getFields().get(i).getY() != (double)n2) continue;
            return Monitor.getInstance();
        }
        return null;
    }

    public ConcurrencyObject checkPositionForMeetingroom(int n, int n2) {
        for (int i = 0; i < Meetingroom.getInstance().getFields().size(); ++i) {
            if (Meetingroom.getInstance().getFields().get(i).getX() != (double)n || Meetingroom.getInstance().getFields().get(i).getY() != (double)n2) continue;
            return Meetingroom.getInstance();
        }
        return null;
    }
}

