/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.Konstants;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.worldobjects.EMPTY;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.MUSHROOM;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.multikaraide.MultiKaraSensorFactory;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiKaraObjectsViewComponent
extends JPanel {
    private static final long serialVersionUID = 1L;

    public MultiKaraObjectsViewComponent() {
        Dimension dimension = new Dimension(3, 34);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/worldcontroller/bordertitle"));
        this.add(this.getEmptyFieldPanel(dimension));
        this.add(this.getPaindetObjectsPanel(dimension));
        this.add(this.getWorldObjectsPanel(dimension));
        this.add(this.getStreetObjectsPanel(dimension));
        this.add(Box.createVerticalGlue());
    }

    private JPanel getEmptyFieldPanel(Dimension dimension) {
        ImageIcon imageIcon = new ImageIcon(MultiKaraSensorFactory.getInstance().getEmptyFieldImage());
        EMPTY.getInstance().setClientProperty("imageicon", imageIcon);
        DragableLabel dragableLabel = new DragableLabel(imageIcon, EMPTY.getInstance());
        dragableLabel.setToolTipText(Configuration.getInstance().getString("language/$language/kawomodel/objectdescriptions/emptyfield"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(dragableLabel);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel getStreetObjectsPanel(Dimension dimension) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        WorldObjectInterface[] worldObjectInterfaceArray = Konfig.getWorldObjects();
        for (int i = 0; i < worldObjectInterfaceArray.length; ++i) {
            if (worldObjectInterfaceArray[i].getType() != 16) continue;
            DragableLabel dragableLabel = new DragableLabel((ImageIcon)worldObjectInterfaceArray[i].getClientProperty("imageicon"), worldObjectInterfaceArray[i]);
            dragableLabel.setToolTipText(Configuration.getInstance().getString("language/$language/kawomodel/objectdescriptions/street"));
            jPanel.add(Box.createRigidArea(dimension));
            jPanel.add(dragableLabel);
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel getWorldObjectsPanel(Dimension dimension) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(dimension));
        Kara kara = MultiKaraSensorFactory.getInstance().getNeutralKara();
        DragableLabel dragableLabel = new DragableLabel(GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/neutralbug"), kara);
        dragableLabel.setToolTipText(Configuration.getInstance().getString("language/$language/kawomodel/objectdescriptions/kara"));
        jPanel.add(dragableLabel);
        jPanel.add(Box.createRigidArea(dimension));
        dragableLabel = new DragableLabel((ImageIcon)TREE.getInstance().getClientProperty("imageicon"), TREE.getInstance());
        dragableLabel.setToolTipText(Configuration.getInstance().getString(Konstants.WORLDOBJECT_DESCRIPTIONS[TREE.getInstance().getType()]));
        jPanel.add(dragableLabel);
        jPanel.add(Box.createRigidArea(dimension));
        dragableLabel = new DragableLabel((ImageIcon)MUSHROOM.getInstance().getClientProperty("imageicon"), MUSHROOM.getInstance());
        dragableLabel.setToolTipText(Configuration.getInstance().getString(Konstants.WORLDOBJECT_DESCRIPTIONS[MUSHROOM.getInstance().getType()]));
        jPanel.add(dragableLabel);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel getPaindetObjectsPanel(Dimension dimension) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(dimension));
        DragableLabel dragableLabel = new DragableLabel(GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/neutralleaf"), LEAF.getInstance(0));
        LEAF.getInstance(0).setClientProperty("imageicon", GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/neutralleaf"));
        dragableLabel.setToolTipText(Configuration.getInstance().getString("language/$language/kawomodel/objectdescriptions/anyleaf"));
        jPanel.add(dragableLabel);
        jPanel.add(Box.createRigidArea(dimension));
        dragableLabel = new DragableLabel(GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/ownleaf"), LEAF.getInstance(5));
        LEAF.getInstance(5).setClientProperty("imageicon", GuiFactory.getInstance().createImageIcon("schemes/ladybugscheme/ownleaf"));
        dragableLabel.setToolTipText(Configuration.getInstance().getString("language/$language/kawomodel/objectdescriptions/ownleaf"));
        jPanel.add(dragableLabel);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private class DragableLabel
    extends JLabel
    implements LightweightDragDrop {
        private static final long serialVersionUID = 1L;
        private WorldObjectInterface dragObject;
        private ImageIcon dragIcon;

        public DragableLabel(ImageIcon imageIcon, WorldObjectInterface worldObjectInterface) {
            super(imageIcon);
            this.dragObject = worldObjectInterface;
            this.dragIcon = imageIcon;
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            BufferedImage bufferedImage = new BufferedImage(29, 29, 6);
            bufferedImage.getGraphics().drawImage(this.dragIcon.getImage(), 0, 0, null);
            return bufferedImage;
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            return this.dragObject;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            return false;
        }
    }
}

