/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.interpreter.InterpreterException;
import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.interpreter.InterpreterListenerAdapter;
import ch.karatojava.interpreter.RunnableInterface;
import ch.karatojava.interpreter.Scheduler;
import ch.karatojava.interpreter.StepableInterpreter;
import ch.karatojava.interpreter.StepperInterface;
import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.actorfsm.ActorInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.StateMachine;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActor;
import ch.karatojava.kapps.karaide.KaraActorKonfig;
import ch.karatojava.kapps.multikaraide.ConcurrencyObject;
import ch.karatojava.kapps.multikaraide.Meetingroom;
import ch.karatojava.kapps.multikaraide.Monitor;
import ch.karatojava.kapps.multikaraide.MultiKaraFsmInterpreter;
import ch.karatojava.kapps.multikaraide.MultiKaraWorldEditorFacade;
import ch.karatojava.kapps.multikaraide.worldobjects.MEETINGROOMFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.MONITORFIELD;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldListener;
import ch.karatojava.kapps.world.WorldListenerAdapter;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class MultiKaraScheduler
extends Scheduler {
    protected MultiKaraWorldEditorFacade worldEditorFacade;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected boolean deterministic = true;
    protected boolean randomOrderExecution = true;
    protected int fixedOrderExecutionPriorityCount = 0;
    protected int visibleIndex = 0;
    private ArrayList<Integer> visiblePosition = new ArrayList();
    private ArrayList<Integer> savedVisiblePosition = new ArrayList();
    protected boolean running = false;
    protected Random randomSchedulerValues = new Random();
    protected MultiKaraFsmInterpreter currentInterpreter;
    protected ActorInterface currentActor;
    protected Hashtable<Object, Integer> actorPriorities;
    protected Hashtable<Object, Integer> actorPrioritiesBeforeRunning;
    protected int currentIndex;
    protected List<KaraActor> runningActors;
    protected Hashtable<String, KaraActor> runningActorFromName;
    protected List<Boolean> runningActorIsSleeping;
    protected List<Object> runningActorIsWaitingFor;
    protected List<State> barrierIsWaitingFor;
    protected String criticalSectionBelongsTo;
    protected StepableInterpreter stepableInterpreter;
    protected boolean executingStep = false;
    protected WorldListener worldListener = new WorldListenerAdapter(){

        @Override
        public void worldObjectAdded(WorldObjectInterface worldObjectInterface, int n, int n2) {
            World world = (World)MultiKaraScheduler.this.worldEditorFacade.getWorldEditor().getContent();
            if (worldObjectInterface.getType() == 11) {
                Monitor.getInstance().addField(n, n2);
                if (world.isObjectOfTypeAt(Kara.getKara("Lara"), n, n2) && MultiKaraScheduler.this.isKaraRunning(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity()) && Monitor.getInstance().getState() == 1) {
                    Monitor.getInstance().addField(n, n2);
                    MultiKaraScheduler.this.actionMonitorEntered(Monitor.getInstance());
                }
            }
            if (worldObjectInterface.getType() == 10) {
                Meetingroom.getInstance().addField(n, n2);
                if (world.isObjectOfTypeAt(Kara.getKara("Lara"), n, n2) && MultiKaraScheduler.this.isKaraRunning(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity()) && Meetingroom.getInstance().getState() == 1) {
                    Meetingroom.getInstance().addField(n, n2);
                    MultiKaraScheduler.this.actionMeetingroomEntered(Meetingroom.getInstance(), ((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity());
                    MultiKaraScheduler.this.checkIfNextActorIsStillReadyToRun();
                    MultiKaraScheduler.this.repaintCurrentActor();
                }
            }
        }

        @Override
        public void worldObjectMoved(WorldObjectInterface worldObjectInterface, int n, int n2, int n3, int n4) {
            World world = (World)MultiKaraScheduler.this.worldEditorFacade.getWorldEditor().getContent();
            if (worldObjectInterface.getType() == 11) {
                Monitor.getInstance().deleteField(n, n2);
                Monitor.getInstance().addField(n3, n4);
                if (world.isObjectOfTypeAt(Kara.getKara("Lara"), n3, n4) && MultiKaraScheduler.this.isKaraRunning(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n3, n4)).getIdentity()) && Monitor.getInstance().getState() == 1) {
                    MultiKaraScheduler.this.actionMonitorEntered(Monitor.getInstance());
                }
            }
            if (worldObjectInterface.getType() == 10) {
                Meetingroom.getInstance().deleteField(n, n2);
                Meetingroom.getInstance().addField(n3, n4);
                if (world.isObjectOfTypeAt(Kara.getKara("Lara"), n3, n4) && MultiKaraScheduler.this.isKaraRunning(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n3, n4)).getIdentity()) && Meetingroom.getInstance().getState() == 1) {
                    MultiKaraScheduler.this.actionMeetingroomEntered(Meetingroom.getInstance(), ((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n3, n4)).getIdentity());
                    MultiKaraScheduler.this.checkIfNextActorIsStillReadyToRun();
                    MultiKaraScheduler.this.repaintCurrentActor();
                }
            }
            if (worldObjectInterface.getType() == 8 && MultiKaraScheduler.this.isKaraRunning(((Kara)worldObjectInterface).getIdentity()) && !MultiKaraScheduler.this.executingStep) {
                String string = ((Kara)worldObjectInterface).getIdentity();
                int n5 = MultiKaraScheduler.this.runningActors.indexOf(MultiKaraScheduler.this.runningActorFromName.get(string));
                if (MultiKaraScheduler.this.isKaraSleeping(string) && (MultiKaraScheduler.this.runningActorIsWaitingFor.get(n5) == Monitor.getInstance() || MultiKaraScheduler.this.runningActorIsWaitingFor.get(n5) == Meetingroom.getInstance()) && !world.isObjectOfTypeAt(MEETINGROOMFIELD.getInstance(), n3, n4)) {
                    MultiKaraScheduler.this.wakeUpKara(string);
                }
                if (Monitor.getInstance().isFieldUsed(n, n2) && !Monitor.getInstance().isFieldUsed(n3, n4)) {
                    MultiKaraScheduler.this.actionMonitorLeaved(Monitor.getInstance());
                }
                if (!Monitor.getInstance().isFieldUsed(n, n2) && Monitor.getInstance().isFieldUsed(n3, n4)) {
                    MultiKaraScheduler.this.actionMonitorEntered(Monitor.getInstance());
                }
                if (Meetingroom.getInstance().isFieldUsed(n, n2) && !Meetingroom.getInstance().isFieldUsed(n3, n4)) {
                    MultiKaraScheduler.this.actionMeetingroomLeaved(Meetingroom.getInstance(), string);
                }
                if (!Meetingroom.getInstance().isFieldUsed(n, n2) && Meetingroom.getInstance().isFieldUsed(n3, n4)) {
                    MultiKaraScheduler.this.actionMeetingroomEntered(Meetingroom.getInstance(), string);
                    MultiKaraScheduler.this.checkIfNextActorIsStillReadyToRun();
                    MultiKaraScheduler.this.repaintCurrentActor();
                }
            }
        }

        @Override
        public void worldObjectRemoved(WorldObjectInterface worldObjectInterface, int n, int n2) {
            World world = (World)MultiKaraScheduler.this.worldEditorFacade.getWorldEditor().getContent();
            if (worldObjectInterface.getType() == 11) {
                Monitor.getInstance().deleteField(n, n2);
                if (world.isObjectOfTypeAt(Kara.getKara("Lara"), n, n2) && MultiKaraScheduler.this.isKaraRunning(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity()) && Monitor.getInstance().getState() == 2) {
                    Monitor.getInstance().deleteField(n, n2);
                    MultiKaraScheduler.this.actionMonitorLeaved(Monitor.getInstance());
                }
            }
            if (worldObjectInterface.getType() == 10) {
                Meetingroom.getInstance().deleteField(n, n2);
                if (world.isObjectOfTypeAt(Kara.getKara("Lara"), n, n2) && MultiKaraScheduler.this.isKaraRunning(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity())) {
                    MultiKaraScheduler.this.wakeUpKara(((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity());
                    Meetingroom.getInstance().deleteField(n, n2);
                    MultiKaraScheduler.this.actionMeetingroomLeaved(Meetingroom.getInstance(), ((Kara)world.getObjectOfTypeAt(Kara.getKara("Lara"), n, n2)).getIdentity());
                }
            }
        }
    };
    protected InterpreterListener interpreterListener = new InterpreterListenerAdapter(){

        @Override
        public void gotReady(RunnableInterface runnableInterface) {
        }

        @Override
        public void playing(RunnableInterface runnableInterface) {
        }

        @Override
        public void pausing(RunnableInterface runnableInterface) {
        }

        @Override
        public void stepped(RunnableInterface runnableInterface) {
        }

        @Override
        public void stopped(RunnableInterface runnableInterface) {
            int n;
            int n2;
            MultiKaraScheduler.this.restoreVisibleOrder();
            MultiKaraScheduler.this.setClientProperty(MultiKaraScheduler.RESET_PRIORITY_PANEL_CLIENT_PROPERTY, "");
            World world = (World)MultiKaraScheduler.this.worldEditorFacade.getWorldEditor().getContent();
            Kara[] karaArray = Kara.getKaras();
            for (n2 = 0; n2 < karaArray.length; ++n2) {
                MultiKaraScheduler.this.fireDeactivated(karaArray[n2].getIdentity());
                MultiKaraScheduler.this.fireWakeUp(karaArray[n2].getIdentity());
            }
            if (MultiKaraScheduler.this.running) {
                MultiKaraScheduler.this.actorPriorities = (Hashtable)MultiKaraScheduler.this.actorPrioritiesBeforeRunning.clone();
                for (n2 = 0; n2 < karaArray.length; ++n2) {
                    MultiKaraScheduler.this.firePriorityChanged(karaArray[n2].getIdentity(), MultiKaraScheduler.this.actorPriorities.get(karaArray[n2].getIdentity()));
                }
            }
            MultiKaraScheduler.this.running = false;
            Monitor.getInstance().setState(0, world);
            world.fireWorldObjectChangedEvent(MONITORFIELD.getInstance());
            Meetingroom.getInstance().setState(0, world);
            world.fireWorldObjectChangedEvent(MEETINGROOMFIELD.getInstance());
            for (n = 0; n < MultiKaraScheduler.this.runningActors.size(); ++n) {
                MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)MultiKaraScheduler.this.getStepper(MultiKaraScheduler.this.runningActors.get(n));
                multiKaraFsmInterpreter.setConcurrencyStatusOfAllBarrierStatesTo(State.ConcurrencyStatus.NORMAL);
            }
            for (n = 0; n < MultiKaraScheduler.this.runningActors.size(); ++n) {
                MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)MultiKaraScheduler.this.getStepper(MultiKaraScheduler.this.runningActors.get(n));
                multiKaraFsmInterpreter.setConcurrencyStatusOfAllCriticalSectionStatesTo(State.ConcurrencyStatus.NORMAL);
            }
            MultiKaraScheduler.this.runningActors.clear();
            MultiKaraScheduler.this.runningActorIsSleeping.clear();
            MultiKaraScheduler.this.runningActorIsWaitingFor.clear();
            MultiKaraScheduler.this.runningActorFromName.clear();
        }

        @Override
        public void errorStop(RunnableInterface runnableInterface) {
            this.stopped(runnableInterface);
        }
    };
    public static final String CLEAR_KARA_PARKING_CLIENT_PROPERTY = "clearkaraparking";
    public static final String PUT_TO_KARA_PARKING_CLIENT_PROPERTY = "puttokaraparking";
    public static final String PUT_TO_SPECIFIED_KARA_PARKING_CLIENT_PROPERTY = "puttospecifiedkaraparking";
    public static final String RESET_PRIORITY_PANEL_CLIENT_PROPERTY = "resetprioritypanel";
    public static final String SAVE_PRIORITIES_CLIENT_PROPERTY = "savepriorities";
    public static final String CHANGE_CUBE_CLIENT_PROPERTY = "changecube";
    public static final String STARTING_ORDER_CLIENT_PROPERTY = "startingorder";
    public static final String STARTING_ORDER_FOR_SAVING_CLIENT_PROPERTY = "startingorderforsaving";
    public static final String PRIORITIES_FOR_SAVING_CLIENT_PROPERTY = "prioritiesforsaving";
    public static final String PARKING_ORDER_FOR_SAVING_CLIENT_PROPERTY = "parkingorderforsaging";
    public static final String STARTING_ORDER_SEPARATOR = ",";
    public static final String EMPTY_KARA_PARKING = "-";
    public static final int ACTION_NONE = 0;
    public static final int ACTION_PUT_KARA_TO_SLEEP = 100;
    public static final int ACTION_MEETINGROOM_ENTERED = 200;
    public static final int ACTION_MEETINGROOM_LEAVED = 201;
    public static final int ACTION_MONITOR_ENTERED = 300;
    public static final int ACTION_MONITOR_LEAVED = 301;
    public static final int ACTION_BARRIER_ENTERED = 400;
    public static final int ACTION_BARRIER_LEAVED = 401;
    public static final int ACTION_CRITICALSECTION_ENTERED = 500;
    public static final int ACTION_CRITICALSECTION_LEAVED = 501;
    public static final String WAITING_FOR_BARRIER = new String("waitingforbarrier");
    public static final String WAITING_FOR_CRITICALSECTION = new String("waitingforcriticalsection");

    public MultiKaraScheduler(MultiKaraWorldEditorFacade multiKaraWorldEditorFacade, ProgramEditorFacadeInterface programEditorFacadeInterface) {
        this.worldEditorFacade = multiKaraWorldEditorFacade;
        this.programEditorFacade = programEditorFacadeInterface;
        this.actorPriorities = new Hashtable();
        this.runningActors = new ArrayList<KaraActor>();
        this.runningActorIsSleeping = new ArrayList<Boolean>();
        this.runningActorIsWaitingFor = new ArrayList<Object>();
        this.runningActorFromName = new Hashtable();
        this.barrierIsWaitingFor = new ArrayList<State>();
        this.criticalSectionBelongsTo = "";
        this.initSteppers();
        World world = (World)multiKaraWorldEditorFacade.getWorldEditor().getContent();
        world.addWorldListener(this.worldListener);
        MONITORFIELD.getInstance().setScheduler(this);
        MEETINGROOMFIELD.getInstance().setScheduler(this);
    }

    public boolean runningActorIsReady(String string) {
        int n = this.runningActors.indexOf(this.runningActorFromName.get(string));
        return n >= 0 && this.runningActorIsSleeping.get(n) == false;
    }

    public void setNextActorTo(String string) {
        int n = this.runningActors.indexOf(this.runningActorFromName.get(string));
        if (n >= 0 && !this.runningActorIsSleeping.get(n).booleanValue()) {
            this.currentIndex = n;
            if (this.currentActor != null) {
                this.fireDeactivated(this.currentActor.getName());
            }
            this.currentActor = this.runningActors.get(this.currentIndex);
            this.fireActivated(this.currentActor.getName());
        }
    }

    public void setStartingOrderForSaving(ArrayList arrayList) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + (String)arrayList.get(i) + STARTING_ORDER_SEPARATOR;
            string2 = string2 + this.getStepperPriority(arrayList.get(i)) + STARTING_ORDER_SEPARATOR;
        }
        this.setClientProperty(STARTING_ORDER_FOR_SAVING_CLIENT_PROPERTY, string);
        this.setClientProperty(PRIORITIES_FOR_SAVING_CLIENT_PROPERTY, string2);
    }

    public void setParkingOrderForSaving(String string) {
        this.setClientProperty(PARKING_ORDER_FOR_SAVING_CLIENT_PROPERTY, string);
    }

    public void setPrioritiesForSaving() {
        String string = (String)this.getClientProperty(STARTING_ORDER_FOR_SAVING_CLIENT_PROPERTY);
        if ("".equals(string)) {
            return;
        }
        List<String> list = Configuration.split(string, STARTING_ORDER_SEPARATOR);
        String string2 = "";
        for (int i = 0; i < list.size(); ++i) {
            string2 = string2 + this.getStepperPriority(list.get(i)) + STARTING_ORDER_SEPARATOR;
        }
        this.setClientProperty(PRIORITIES_FOR_SAVING_CLIENT_PROPERTY, string2);
    }

    @Override
    public void setClientProperty(Object object, Object object2) {
        super.setClientProperty(object, object2);
        this.fireClientPropertySet(object, object2);
    }

    @Override
    public void setStepperPriority(Object object, int n) {
        this.actorPriorities.put(object, new Integer(n));
        this.firePriorityChanged(object, n);
        this.setPrioritiesForSaving();
    }

    @Override
    public InterpreterListener getInterpreterListener() {
        return this.interpreterListener;
    }

    public void setStepableInterpreter(StepableInterpreter stepableInterpreter) {
        this.stepableInterpreter = stepableInterpreter;
    }

    public int getStepableInterpreterWaitInterval() {
        return this.stepableInterpreter.getWaitInterval();
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
        Iterator iterator = this.steppers.values().iterator();
        while (iterator.hasNext()) {
            ((MultiKaraFsmInterpreter)iterator.next()).setDeterministic(bl);
        }
    }

    public boolean getDeterministic() {
        return this.deterministic;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void getReady() throws InterpreterException {
        int n;
        this.currentIndex = -1;
        this.currentActor = null;
        this.fixedOrderExecutionPriorityCount = 0;
        this.saveVisibleOrder();
        this.running = false;
        Hashtable hashtable = (Hashtable)this.programEditorFacade.getProgramEditor().getContent();
        assert (hashtable != null) : "MultiKaraScheduler.getReadyImpl: programs == null";
        KaraActor[] karaActorArray = KaraActorKonfig.getInstance().getKaraActors();
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        this.initSteppers();
        boolean bl = false;
        this.runningActors.clear();
        this.runningActorIsSleeping.clear();
        this.runningActorIsWaitingFor.clear();
        this.runningActorFromName.clear();
        this.barrierIsWaitingFor.clear();
        this.criticalSectionBelongsTo = "";
        this.actorPrioritiesBeforeRunning = (Hashtable)this.actorPriorities.clone();
        this.createMeetingroomArea();
        this.createMonitorArea();
        this.fireClientPropertySet(SAVE_PRIORITIES_CLIENT_PROPERTY, "");
        for (n = 0; n < karaActorArray.length; ++n) {
            karaActorArray[n].resetKara();
            StateMachine stateMachine = (StateMachine)hashtable.get(karaActorArray[n]);
            Kara kara = Kara.findKaraInWorld(world, karaActorArray[n].getName());
            if ((stateMachine.size() == 1 || kara == null) && this.actorPriorities.get(karaActorArray[n].getName()) > 0) {
                this.fireTerminated(karaActorArray[n].getName());
            }
            if (stateMachine.size() <= 1 || kara == null || this.getStepperPriority(karaActorArray[n].getName()) <= 0) continue;
            karaActorArray[n].setKara(kara);
            this.setActorStepper(stateMachine, karaActorArray[n]);
            bl = true;
            this.runningActors.add(karaActorArray[n]);
            this.runningActorFromName.put(karaActorArray[n].getName(), karaActorArray[n]);
            this.runningActorIsSleeping.add(new Boolean(false));
            this.runningActorIsWaitingFor.add(null);
            this.barrierIsWaitingFor.add(null);
        }
        if (!bl) {
            this.setClientProperty(RESET_PRIORITY_PANEL_CLIENT_PROPERTY, "");
            throw new InterpreterException(Configuration.getInstance().getString("language/$language/multikara/noprogramerror"));
        }
        this.checkWorld((World)this.worldEditorFacade.getWorldEditor().getContent());
        for (n = 0; n < this.runningActors.size(); ++n) {
            KaraActor karaActor = this.runningActors.get(n);
            ((MultiKaraFsmInterpreter)this.getStepper(karaActor)).getReady();
        }
        this.getNextActor();
        this.running = true;
    }

    @Override
    public synchronized StepperInterface getCurrentStepper() {
        return this.currentInterpreter;
    }

    @Override
    public int getStepperPriority(Object object) {
        return this.actorPriorities.get(object);
    }

    public void resetPriorities() {
        KaraActor[] karaActorArray = KaraActorKonfig.getInstance().getKaraActors();
        for (int i = 0; i < karaActorArray.length; ++i) {
            this.actorPriorities.put(karaActorArray[i].getName(), new Integer(2));
            this.firePriorityChanged(karaActorArray[i], 2);
            this.runningActorIsSleeping.add(new Boolean(false));
            this.runningActorIsSleeping.add(null);
        }
        Kara[] karaArray = Kara.getKaras();
        this.clearVisibleOrder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < karaArray.length; ++i) {
            arrayList.add(karaArray[i].getIdentity());
        }
        this.setStartingOrderForSaving(arrayList);
    }

    @Override
    public void beginCompositeStep() throws InterpreterException {
        this.changeInterpreterTo(this.currentActor);
        this.currentInterpreter.beginCompositeStep();
    }

    @Override
    public void executeStep() throws InterpreterException {
        this.executingStep = true;
        this.currentInterpreter.executeStep();
        this.executingStep = false;
    }

    @Override
    public void endCompositeStep() throws InterpreterException {
        this.currentInterpreter.endCompositeStep();
        this.changeActor();
    }

    protected void changeActor() throws InterpreterException {
        if (!this.runningActorIsSleeping.get(this.currentIndex).booleanValue()) {
            this.fireDeactivated(this.currentActor.getName());
        }
        if (this.currentInterpreter.executionFinished()) {
            this.terminateAndCleanUp();
        }
        if (this.runningActors.size() == 0) {
            this.currentIndex = -1;
            this.setClientProperty(RESET_PRIORITY_PANEL_CLIENT_PROPERTY, "");
            this.running = false;
        } else {
            this.getNextActor();
        }
    }

    protected void changeInterpreterTo(ActorInterface actorInterface) {
        if (!this.executionFinished()) {
            this.currentInterpreter = (MultiKaraFsmInterpreter)this.getStepper(actorInterface);
        }
    }

    protected void terminateAndCleanUp() {
        int n;
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        Kara kara = Kara.findKaraInWorld(world, this.currentActor.getName());
        ConcurrencyObject concurrencyObject = this.currentInterpreter.checkPositionForMonitor((int)kara.getPosition().getX(), (int)kara.getPosition().getY());
        if (concurrencyObject != null) {
            concurrencyObject.setState(1, world);
        }
        for (int i = 0; i < this.runningActorIsSleeping.size(); ++i) {
            if (!this.runningActorIsSleeping.get(i).booleanValue() || this.runningActorIsWaitingFor.get(i) != concurrencyObject) continue;
            this.runningActorIsWaitingFor.set(i, null);
            this.runningActorIsSleeping.set(i, new Boolean(false));
            this.fireWakeUp(this.runningActors.get(i).getName());
        }
        ConcurrencyObject concurrencyObject2 = this.currentInterpreter.checkPositionForMeetingroom((int)kara.getPosition().getX(), (int)kara.getPosition().getY());
        if (concurrencyObject2 != null && concurrencyObject2.getState() == 2) {
            int n2;
            List<Point> list = concurrencyObject2.getFields();
            n = 1;
            for (n2 = 0; n2 < this.runningActorIsSleeping.size(); ++n2) {
                if (this.currentIndex == n2) continue;
                Kara kara2 = Kara.findKaraInWorld(world, this.runningActors.get(n2).getName());
                Point point = kara2.getPosition();
                for (int i = 0; i < list.size(); ++i) {
                    if (!point.equals(list.get(i))) continue;
                    n = 0;
                }
            }
            if (n != 0) {
                concurrencyObject2.setState(1, world);
                for (n2 = 0; n2 < this.runningActorIsSleeping.size(); ++n2) {
                    if (!this.runningActorIsSleeping.get(n2).booleanValue() || concurrencyObject2 != this.runningActorIsWaitingFor.get(n2)) continue;
                    this.runningActorIsWaitingFor.set(n2, null);
                    this.runningActorIsSleeping.set(n2, new Boolean(false));
                    this.fireWakeUp(this.runningActors.get(n2).getName());
                }
            }
        }
        if (Meetingroom.getInstance() != null && Meetingroom.getInstance().getState() == 1) {
            boolean bl = true;
            for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                if (this.runningActorIsSleeping.get(n).booleanValue() && Meetingroom.getInstance() == this.runningActorIsWaitingFor.get(n) || this.currentIndex == n) continue;
                bl = false;
            }
            if (bl) {
                for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                    this.runningActorIsWaitingFor.set(n, null);
                    this.runningActorIsSleeping.set(n, new Boolean(false));
                    this.fireWakeUp(this.runningActors.get(n).getName());
                }
                Meetingroom.getInstance().setState(2, world);
            }
        }
        boolean bl = true;
        for (n = 0; n < this.barrierIsWaitingFor.size(); ++n) {
            if (this.barrierIsWaitingFor.get(n) != null || n == this.currentIndex) continue;
            bl = false;
        }
        if (bl) {
            for (n = 0; n < this.barrierIsWaitingFor.size(); ++n) {
                this.barrierIsWaitingFor.set(n, null);
                this.runningActorIsSleeping.set(n, new Boolean(false));
                this.fireWakeUp(this.runningActors.get(n).getName());
                MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)this.getStepper(this.runningActors.get(n));
                multiKaraFsmInterpreter.setConcurrencyStatusOfAllBarrierStatesTo(State.ConcurrencyStatus.NORMAL);
            }
        }
        if (this.criticalSectionBelongsTo.equals(kara.getIdentity())) {
            this.criticalSectionBelongsTo = "";
        }
        this.runningActors.remove(this.currentActor);
        this.runningActorFromName.remove(this.currentActor.getName());
        this.runningActorIsSleeping.remove(this.currentIndex);
        this.runningActorIsWaitingFor.remove(this.currentIndex);
        this.barrierIsWaitingFor.remove(this.currentIndex);
        this.fireDeactivated(this.currentActor.getName());
        this.fireTerminated(this.currentActor.getName());
    }

    @Override
    public boolean executionFinished() {
        return !this.running;
    }

    @Override
    public boolean compositeStepFinished() {
        return this.currentInterpreter.compositeStepFinished();
    }

    public void actionPutKaraToSleep(Object object, String string) {
        int n = this.runningActors.indexOf(this.runningActorFromName.get(string));
        this.runningActorIsSleeping.set(n, Boolean.TRUE);
        this.runningActorIsWaitingFor.set(n, object);
        this.firePutToSleep(string);
    }

    public void actionMonitorEntered(Object object) {
        assert (object instanceof Monitor) : "MultiKaraScheduler.actionMonitorEntered: object isn't a Monitor";
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        ((Monitor)object).setState(2, world);
    }

    public void actionMonitorLeaved(Object object) {
        assert (object instanceof Monitor) : "MultiKaraScheduler.actionMonitorLeaved: object isn't a Monitor";
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        ((Monitor)object).setState(1, world);
        for (int i = 0; i < this.runningActorIsSleeping.size(); ++i) {
            if (!this.runningActorIsSleeping.get(i).booleanValue() || this.runningActorIsWaitingFor.get(i) != object) continue;
            this.runningActorIsWaitingFor.set(i, null);
            this.runningActorIsSleeping.set(i, new Boolean(false));
            this.fireWakeUp(this.runningActors.get(i).getName());
        }
    }

    public void actionMeetingroomEntered(Object object, String string) {
        assert (object instanceof Meetingroom) : "MultiKaraScheduler.actionMeetingroomEntered: object isn't a Meetingroom";
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        if (((Meetingroom)object).getState() == 1) {
            int n;
            int n2 = this.runningActors.indexOf(this.runningActorFromName.get(string));
            this.runningActorIsSleeping.set(n2, new Boolean(true));
            this.runningActorIsWaitingFor.set(n2, object);
            this.firePutToSleep(string);
            boolean bl = true;
            for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                if (this.runningActorIsSleeping.get(n).booleanValue() && object == this.runningActorIsWaitingFor.get(n)) continue;
                bl = false;
            }
            if (bl) {
                for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                    this.runningActorIsWaitingFor.set(n, null);
                    this.runningActorIsSleeping.set(n, new Boolean(false));
                    this.fireWakeUp(this.runningActors.get(n).getName());
                }
                ((Meetingroom)object).setState(2, world);
            }
        }
    }

    public void actionMeetingroomLeaved(Object object, String string) {
        assert (object instanceof Meetingroom) : "MultiKaraScheduler.actionMeetingroomLeaved: object isn't a Meetingroom";
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        if (((Meetingroom)object).getState() == 2) {
            int n;
            List<Point> list = ((Meetingroom)object).getFields();
            boolean bl = true;
            for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                Kara kara = Kara.findKaraInWorld(world, this.runningActors.get(n).getName());
                Point point = kara.getPosition();
                for (int i = 0; i < list.size(); ++i) {
                    if (!point.equals(list.get(i))) continue;
                    bl = false;
                }
            }
            if (bl) {
                ((Meetingroom)object).setState(1, world);
                for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                    if (!this.runningActorIsSleeping.get(n).booleanValue() || object != this.runningActorIsWaitingFor.get(n)) continue;
                    this.runningActorIsWaitingFor.set(n, null);
                    this.runningActorIsSleeping.set(n, new Boolean(false));
                    this.fireWakeUp(this.runningActors.get(n).getName());
                }
            }
        }
    }

    public void actionBarrierEntered(Object object, String string) {
        int n;
        assert (object instanceof State) : "MultiKaraScheduler.actionBarrierEntered: object isn't a State";
        int n2 = this.runningActors.indexOf(this.runningActorFromName.get(string));
        State state = (State)object;
        this.barrierIsWaitingFor.set(n2, state);
        state.setConcurrencyStatus(State.ConcurrencyStatus.BARRIER_WAIT);
        this.runningActorIsSleeping.set(n2, new Boolean(true));
        this.runningActorIsWaitingFor.set(n2, WAITING_FOR_BARRIER);
        this.firePutToSleep(string);
        boolean bl = true;
        for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
            if (this.runningActorIsSleeping.get(n).booleanValue() && this.runningActorIsWaitingFor.get(n) == WAITING_FOR_BARRIER) continue;
            bl = false;
        }
        if (bl) {
            for (n = 0; n < this.runningActorIsSleeping.size(); ++n) {
                this.runningActorIsWaitingFor.set(n, null);
                this.runningActorIsSleeping.set(n, new Boolean(false));
                this.fireWakeUp(this.runningActors.get(n).getName());
                this.barrierIsWaitingFor.get(n).setConcurrencyStatus(State.ConcurrencyStatus.NORMAL);
                this.barrierIsWaitingFor.set(n, null);
            }
        }
    }

    public void actionCriticalsectionEntered(Object object, String string) {
        if (this.criticalSectionBelongsTo.equals("")) {
            this.criticalSectionBelongsTo = string;
            assert (object instanceof State) : "MultiKaraScheduler.actionCriticalsectionEntered: Object isn't a State";
            for (int i = 0; i < this.runningActors.size(); ++i) {
                KaraActor karaActor = this.runningActors.get(i);
                MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)this.getStepper(karaActor);
                if (karaActor.getName().equals(string)) continue;
                multiKaraFsmInterpreter.setConcurrencyStatusOfAllCriticalSectionStatesTo(State.ConcurrencyStatus.CRITICALSECTION_WAIT);
            }
        } else {
            int n = this.runningActors.indexOf(this.runningActorFromName.get(string));
            this.runningActorIsSleeping.set(n, new Boolean(true));
            this.runningActorIsWaitingFor.set(n, WAITING_FOR_CRITICALSECTION);
            this.firePutToSleep(string);
        }
    }

    public void actionCriticalsectionLeaved() {
        this.criticalSectionBelongsTo = "";
        for (int i = 0; i < this.runningActorIsSleeping.size(); ++i) {
            if (this.runningActorIsWaitingFor.get(i) == WAITING_FOR_CRITICALSECTION) {
                this.runningActorIsWaitingFor.set(i, null);
                this.runningActorIsSleeping.set(i, new Boolean(false));
                this.fireWakeUp(this.runningActors.get(i).getName());
            }
            KaraActor karaActor = this.runningActors.get(i);
            MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)this.getStepper(karaActor);
            multiKaraFsmInterpreter.setConcurrencyStatusOfAllCriticalSectionStatesTo(State.ConcurrencyStatus.NORMAL);
        }
    }

    public void processInterpreterAction(int n, Object object, String string) {
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        if (n == 100) {
            this.actionPutKaraToSleep(object, string);
        }
        if (n == 300) {
            this.actionMonitorEntered(object);
            world.fireWorldObjectChangedEvent(MONITORFIELD.getInstance());
        }
        if (n == 301) {
            this.actionMonitorLeaved(object);
            world.fireWorldObjectChangedEvent(MONITORFIELD.getInstance());
        }
        if (n == 200) {
            this.actionMeetingroomEntered(object, string);
            world.fireWorldObjectChangedEvent(MEETINGROOMFIELD.getInstance());
        }
        if (n == 201) {
            this.actionMeetingroomLeaved(object, string);
            world.fireWorldObjectChangedEvent(MEETINGROOMFIELD.getInstance());
        }
        if (n == 400) {
            this.actionBarrierEntered(object, string);
        }
        if (n == 401) {
            // empty if block
        }
        if (n == 500) {
            this.actionCriticalsectionEntered(object, string);
        }
        if (n == 501) {
            this.actionCriticalsectionLeaved();
        }
    }

    public void changeWorld(World world) {
        for (int i = 0; i < this.runningActors.size(); ++i) {
            KaraActor karaActor = this.runningActors.get(i);
            Kara kara = Kara.findKaraInWorld(world, karaActor.getName());
            karaActor.setKara(kara);
        }
        ((WorldEditor)this.worldEditorFacade.getWorldEditor()).setWorld(world);
    }

    protected void setActorStepper(StateMachine stateMachine, ActorInterface actorInterface) {
        assert (stateMachine != null) : "MultiKaraScheduler.setActorStepper: stateMachine == null";
        assert (actorInterface != null) : "MultiKaraScheduler.setActorStepper: actor == null";
        MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)this.getStepper(actorInterface);
        if (multiKaraFsmInterpreter == null) {
            multiKaraFsmInterpreter = new MultiKaraFsmInterpreter(this, this.worldEditorFacade);
        }
        multiKaraFsmInterpreter.setStateMachine(stateMachine);
        multiKaraFsmInterpreter.setActor(actorInterface);
        multiKaraFsmInterpreter.setDeterministic(this.deterministic);
        this.setStepper(multiKaraFsmInterpreter, actorInterface);
    }

    protected void checkIfNextActorIsStillReadyToRun() {
        if (this.isKaraSleeping(this.currentActor.getName()) && !this.executingStep) {
            try {
                this.getNextActor();
            }
            catch (InterpreterException interpreterException) {
                ExceptionActionListener.reportException(KaraGuiFactory.getInstance().getApplicationFrame(), "", new Exception(Configuration.getInstance().getString("language/$language/multikara/nokarareadytorun")));
            }
        }
    }

    protected void repaintCurrentActor() {
        this.fireActivated(this.currentActor.getName());
    }

    public void setExecutionOrderMode(String string) {
        this.randomOrderExecution = "executionorderrandom".equals(string);
    }

    public void saveVisibleOrder() {
        this.savedVisiblePosition = (ArrayList)this.visiblePosition.clone();
    }

    public void restoreVisibleOrder() {
        if (this.savedVisiblePosition.size() > 0) {
            this.visiblePosition = (ArrayList)this.savedVisiblePosition.clone();
        }
    }

    public void clearVisibleOrder() {
        this.visiblePosition.clear();
        Kara[] karaArray = Kara.getKaras();
        for (int i = 0; i < karaArray.length; ++i) {
            this.visiblePosition.add(new Integer(i));
        }
    }

    public void printVisibleOrder() {
        Kara[] karaArray = Kara.getKaras();
        System.out.print("Visible Order of Karas: ");
        for (int i = 0; i < this.visiblePosition.size(); ++i) {
            System.out.print("[ " + karaArray[i].getIdentity() + " -> " + this.getVisiblePosition(i) + " ]  ");
        }
        System.out.println();
    }

    public void setVisiblePosition(int n, int n2) {
        this.visiblePosition.set(n, new Integer(n2));
    }

    public int getVisiblePosition(int n) {
        int n2 = this.visiblePosition.get(n);
        return n2;
    }

    public int getIndexOfVisiblePosition(int n) {
        int n2 = -1;
        for (int i = 0; i < this.visiblePosition.size(); ++i) {
            if (this.visiblePosition.get(i) != n) continue;
            n2 = i;
        }
        return n2;
    }

    public void putActorToLastVisiblePosition(String string) {
        Kara[] karaArray = Kara.getKaras();
        this.putActorToVisiblePosition(string, karaArray.length);
    }

    public void putActorToVisiblePosition(String string, int n) {
        int n2;
        Kara[] karaArray = Kara.getKaras();
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < karaArray.length; ++n2) {
            if (!karaArray[n2].getIdentity().equals(string)) continue;
            n3 = this.getVisiblePosition(n2);
            n4 = n2;
        }
        assert (n4 >= 0) : "MultiKaraSchedulerView.putActorToVisiblePosition: no such karaIdentity found (" + string + ")";
        for (n2 = 0; n2 < karaArray.length; ++n2) {
            if (this.getVisiblePosition(n2) > n3 && this.getVisiblePosition(n2) < n) {
                this.setVisiblePosition(n2, this.getVisiblePosition(n2) - 1);
            }
            if (this.getVisiblePosition(n2) >= n3 || this.getVisiblePosition(n2) < n) continue;
            this.setVisiblePosition(n2, this.getVisiblePosition(n2) + 1);
        }
        if (n > n3) {
            this.setVisiblePosition(n4, n - 1);
        } else {
            this.setVisiblePosition(n4, n);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < karaArray.length; ++i) {
            arrayList.add(karaArray[this.getIndexOfVisiblePosition(i)].getIdentity());
        }
        this.setStartingOrderForSaving(arrayList);
    }

    protected void getNextActor() throws InterpreterException {
        if (this.randomOrderExecution) {
            this.getNextActorRandomOrder();
        } else {
            this.getNextActorFixedOrder();
        }
        assert (this.currentIndex != -1) : "MultiKaraScheduler.getNextActor: currentIndex == -1";
    }

    protected void getNextActorFixedOrder() throws InterpreterException {
        int n;
        int n2 = this.currentIndex;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.runningActors.size(); ++i) {
            if (this.runningActorIsSleeping.get(i).booleanValue()) continue;
            ++n3;
        }
        if (n3 > 0) {
            Kara[] karaArray = Kara.getKaras();
            if (this.currentIndex == -1) {
                this.visibleIndex = 0;
                this.fixedOrderExecutionPriorityCount = 1;
            } else if (this.currentInterpreter.executionFinished()) {
                this.fixedOrderExecutionPriorityCount = 1;
            } else {
                n4 = this.getStepperPriority(this.runningActors.get(this.currentIndex).getName());
                if (this.fixedOrderExecutionPriorityCount < n4) {
                    ++this.fixedOrderExecutionPriorityCount;
                } else {
                    this.visibleIndex = (this.visibleIndex + 1) % karaArray.length;
                    this.fixedOrderExecutionPriorityCount = 1;
                }
            }
            int n5 = this.getIndexOfVisiblePosition(this.visibleIndex);
            n = this.runningActors.indexOf(this.runningActorFromName.get(karaArray[n5].getIdentity()));
            while (this.getStepperPriority(karaArray[n5].getIdentity()) == 0 || n == -1 || this.runningActorIsSleeping.get(n).booleanValue()) {
                this.visibleIndex = (this.visibleIndex + 1) % karaArray.length;
                this.fixedOrderExecutionPriorityCount = 1;
                n5 = this.getIndexOfVisiblePosition(this.visibleIndex);
                n = this.runningActors.indexOf(this.runningActorFromName.get(karaArray[n5].getIdentity()));
            }
            n4 = this.getStepperPriority(karaArray[n5].getIdentity());
            if (this.currentActor != null && n2 != -1 && n2 < this.runningActors.size() && !this.runningActorIsSleeping.get(n2).booleanValue()) {
                this.fireDeactivated(this.currentActor.getName());
            }
        } else {
            throw new InterpreterException(Configuration.getInstance().getString("language/$language/multikara/nokarareadytorun"));
        }
        this.currentIndex = n;
        this.currentActor = this.runningActors.get(this.currentIndex);
        this.fireActivated(this.currentActor.getName());
    }

    protected void getNextActorRandomOrder() throws InterpreterException {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.runningActors.size()];
        int[] nArray2 = new int[this.runningActors.size()];
        for (n = 0; n < this.runningActors.size(); ++n) {
            nArray[n] = n2;
            if (!this.runningActorIsSleeping.get(n).booleanValue()) {
                n2 += this.getStepperPriority(this.runningActors.get(n).getName());
            }
            nArray2[n] = n2 - 1;
        }
        if (n2 == 0) {
            throw new InterpreterException(Configuration.getInstance().getString("language/$language/multikara/nokarareadytorun"));
        }
        n = this.randomSchedulerValues.nextInt(n2);
        this.currentIndex = -1;
        for (int i = 0; i < this.runningActors.size(); ++i) {
            if (n < nArray[i] || n > nArray2[i]) continue;
            if (this.currentActor != null && this.currentIndex >= 0 && !this.runningActorIsSleeping.get(this.currentIndex).booleanValue()) {
                this.fireDeactivated(this.currentActor.getName());
            }
            this.currentIndex = i;
            this.currentActor = this.runningActors.get(this.currentIndex);
            this.fireActivated(this.currentActor.getName());
        }
    }

    public void wakeUpKara(String string) {
        int n;
        KaraActor karaActor = this.runningActorFromName.get(string);
        if (karaActor != null && this.runningActorIsSleeping.get(n = this.runningActors.indexOf(karaActor)).booleanValue()) {
            this.runningActorIsSleeping.set(n, new Boolean(false));
            this.runningActorIsWaitingFor.set(n, null);
            this.fireWakeUp(string);
        }
    }

    public boolean isKaraSleeping(String string) {
        if (this.isRunning() && this.runningActorFromName.get(string) != null) {
            int n = this.runningActors.indexOf(this.runningActorFromName.get(string));
            return this.runningActorIsSleeping.get(n);
        }
        return false;
    }

    public boolean isKaraRunning(String string) {
        return this.isRunning() && this.runningActorFromName.get(string) != null;
    }

    public boolean isKaraInMonitor(String string) {
        assert (string != null) : "MultiKaraScheduler.isKaraInMonitor: karaID is null!";
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        int n = 0;
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < Monitor.getInstance().getFields().size(); ++i) {
            int n2 = (int)Monitor.getInstance().getFields().get(i).getX();
            int n3 = (int)Monitor.getInstance().getFields().get(i).getY();
            for (int j = 0; j < this.runningActors.size(); ++j) {
                Kara kara = Kara.getKara(this.runningActors.get(j).getName());
                if (!world.isObjectAt(kara, n2, n3)) continue;
                ++n;
                string2 = string2 + kara.getIdentity() + ", ";
                if (!string.equals(kara.getIdentity())) continue;
                bl = true;
            }
        }
        string2 = string2.substring(0, string2.length() - 2);
        assert (n <= 1) : "MultiKaraScheduler.isKaraInMonitor: More than one Kara found on a Monitor! [" + string2 + "]";
        return bl;
    }

    public boolean isKaraInMeetingroom(String string) {
        assert (string != null) : "MultiKaraScheduler.isKaraInMeetingrooom: karaID is null!";
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        boolean bl = false;
        for (int i = 0; i < Meetingroom.getInstance().getFields().size(); ++i) {
            int n = (int)Meetingroom.getInstance().getFields().get(i).getX();
            int n2 = (int)Meetingroom.getInstance().getFields().get(i).getY();
            for (int j = 0; j < this.runningActors.size(); ++j) {
                Kara kara = Kara.getKara(this.runningActors.get(j).getName());
                if (!world.isObjectAt(kara, n, n2) || !string.equals(kara.getIdentity())) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected void checkWorld(World world) throws InterpreterException {
        int n;
        int n2 = 0;
        n2 = 0;
        for (int i = 0; i < Monitor.getInstance().getFields().size(); ++i) {
            n = (int)Monitor.getInstance().getFields().get(i).getX();
            int n3 = (int)Monitor.getInstance().getFields().get(i).getY();
            for (int j = 0; j < this.runningActors.size(); ++j) {
                Kara kara = Kara.getKara(this.runningActors.get(j).getName());
                if (!world.isObjectAt(kara, n, n3)) continue;
                ++n2;
            }
        }
        if (n2 > 1) {
            throw new InterpreterException(Configuration.getInstance().getString("language/$language/multikara/morethanonekarainmonitor"));
        }
        n2 = 0;
        for (n = 0; n < this.runningActors.size(); ++n) {
            MultiKaraFsmInterpreter multiKaraFsmInterpreter = (MultiKaraFsmInterpreter)this.getStepper(this.runningActors.get(n));
            State state = multiKaraFsmInterpreter.getStartState();
            if (state == null || !state.isCriticalSectionState()) continue;
            ++n2;
        }
        if (n2 > 1) {
            throw new InterpreterException(Configuration.getInstance().getString("language/$language/multikara/morethanonekaraincriticalsection"));
        }
    }

    protected void createMeetingroomArea() {
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        Meetingroom.getInstance().clear();
        Meetingroom.getInstance().setState(1, world);
        for (int i = 0; i < world.getSizeY(); ++i) {
            for (int j = 0; j < world.getSizeX(); ++j) {
                if (!world.isObjectOfTypeAt(MEETINGROOMFIELD.getInstance(), j, i)) continue;
                Meetingroom.getInstance().addField(j, i);
            }
        }
    }

    protected void createMonitorArea() {
        World world = (World)this.worldEditorFacade.getWorldEditor().getContent();
        Monitor.getInstance().clear();
        Monitor.getInstance().setState(1, world);
        for (int i = 0; i < world.getSizeY(); ++i) {
            for (int j = 0; j < world.getSizeX(); ++j) {
                if (!world.isObjectOfTypeAt(MONITORFIELD.getInstance(), j, i)) continue;
                Monitor.getInstance().addField(j, i);
            }
        }
    }
}

