/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.multikaraide.MultiKaraSensorFactory;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiKaraSensorViewComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private WorldObjectInterface[] fields = new WorldObjectInterface[4];
    private int dragOrigin = -1;
    private DragableLabel[] labels;
    private BufferedImage[] gridImages;

    public MultiKaraSensorViewComponent() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = null;
        }
        this.createGridImages();
        this.createGUI();
    }

    private void createGridImages() {
        this.gridImages = new BufferedImage[4];
        this.gridImages[0] = new BufferedImage(28, 29, 6);
        this.gridImages[1] = new BufferedImage(29, 29, 6);
        this.gridImages[2] = new BufferedImage(28, 29, 6);
        this.gridImages[3] = new BufferedImage(29, 28, 6);
    }

    private void createGUI() {
        this.labels = new DragableLabel[4];
        for (int i = 0; i < this.labels.length; ++i) {
            this.createIconImage(i, null);
            this.labels[i] = new DragableLabel(new ImageIcon(this.gridImages[i]), i);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JLabel jLabel = new JLabel(new ImageIcon(new BufferedImage(28, 28, 6)));
        jPanel.add(jLabel);
        jPanel.add(this.labels[3]);
        jLabel = new JLabel(new ImageIcon(new BufferedImage(28, 28, 6)));
        jPanel.add(jLabel);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.labels[0]);
        jPanel.add(this.labels[1]);
        jPanel.add(this.labels[2]);
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
    }

    private void createIconImage(int n, WorldObjectInterface worldObjectInterface) {
        Graphics graphics = this.gridImages[n].getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, 29, 29);
        graphics.setColor(new Color(170, 170, 170));
        if (n == 1) {
            graphics.drawRect(0, 0, 29, 29);
            if (worldObjectInterface != null) {
                graphics.drawImage(((ImageIcon)worldObjectInterface.getClientProperty("imageicon")).getImage(), 0, 0, null);
            } else {
                graphics.drawImage(MultiKaraSensorFactory.getInstance().getDontCareImage(), 0, 0, null);
            }
            graphics.drawImage(MultiKaraSensorFactory.getInstance().neutralActorImage, 0, 0, null);
        } else if (n == 2) {
            graphics.drawRect(-1, 0, 29, 29);
            if (worldObjectInterface != null) {
                graphics.drawImage(((ImageIcon)worldObjectInterface.getClientProperty("imageicon")).getImage(), -1, 0, null);
            } else {
                graphics.drawImage(MultiKaraSensorFactory.getInstance().getDontCareImage(), -1, 0, null);
            }
        } else {
            graphics.drawRect(0, 0, 29, 29);
            if (worldObjectInterface != null) {
                graphics.drawImage(((ImageIcon)worldObjectInterface.getClientProperty("imageicon")).getImage(), 0, 0, null);
            } else {
                graphics.drawImage(MultiKaraSensorFactory.getInstance().getDontCareImage(), 0, 0, null);
            }
        }
    }

    public void reset() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = null;
            this.createIconImage(i, null);
        }
    }

    public int getDragOrigin() {
        return this.dragOrigin;
    }

    public SensorTypeInterface getSensor(String string) {
        return MultiKaraSensorFactory.getInstance().createWorldSensor(this.fields, string);
    }

    private class DragableLabel
    extends JLabel
    implements LightweightDragDrop {
        private static final long serialVersionUID = 1L;
        private WorldObjectInterface dragObject;
        private int fieldIndex;

        public DragableLabel(ImageIcon imageIcon, int n) {
            super(imageIcon);
            this.fieldIndex = n;
            this.dragObject = MultiKaraSensorViewComponent.this.fields[n];
        }

        @Override
        public BufferedImage getDragImage(Object object) {
            BufferedImage bufferedImage = new BufferedImage(29, 29, 6);
            bufferedImage.getGraphics().drawImage(((ImageIcon)this.dragObject.getClientProperty("imageicon")).getImage(), 0, 0, null);
            return bufferedImage;
        }

        @Override
        public void draggingFinished(MouseEvent mouseEvent, Object object, boolean bl) {
            if (bl) {
                ((MultiKaraSensorViewComponent)MultiKaraSensorViewComponent.this).fields[this.fieldIndex] = null;
                MultiKaraSensorViewComponent.this.createIconImage(this.fieldIndex, null);
                this.dragObject = MultiKaraSensorViewComponent.this.fields[this.fieldIndex];
                MultiKaraSensorViewComponent.this.dragOrigin = -1;
            }
        }

        @Override
        public void dropTransferObject(MouseEvent mouseEvent, Object object) {
            ((MultiKaraSensorViewComponent)MultiKaraSensorViewComponent.this).fields[this.fieldIndex] = (WorldObjectInterface)object;
            MultiKaraSensorViewComponent.this.createIconImage(this.fieldIndex, MultiKaraSensorViewComponent.this.fields[this.fieldIndex]);
            this.dragObject = MultiKaraSensorViewComponent.this.fields[this.fieldIndex];
        }

        @Override
        public Object acceptsDrag(MouseEvent mouseEvent) {
            if (MultiKaraSensorViewComponent.this.fields[this.fieldIndex] != null) {
                MultiKaraSensorViewComponent.this.dragOrigin = this.fieldIndex;
                return this.dragObject;
            }
            return null;
        }

        @Override
        public boolean acceptsDrop(MouseEvent mouseEvent, Object object) {
            int n = ((WorldObjectInterface)object).getType();
            return this.fieldIndex != MultiKaraSensorViewComponent.this.dragOrigin && (n >= 16 || this.fieldIndex != 1 || n == 2 || n == 0);
        }
    }
}

