/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.multikaraide;

import ch.karatojava.interpreter.SchedulerListener;
import ch.karatojava.kapps.Konfig;
import ch.karatojava.kapps.Konstants;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.KaraActorCommandsToolbar;
import ch.karatojava.kapps.karaide.KaraWorldEditorFacade;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.multikaraide.MultiKara;
import ch.karatojava.kapps.multikaraide.MultiKaraActorCommandsToolbar;
import ch.karatojava.kapps.multikaraide.MultiKaraSchedulerView;
import ch.karatojava.kapps.multikaraide.worldio.MultiKaraWorldBuilder;
import ch.karatojava.kapps.multikaraide.worldio.MultiKaraWorldOutputter;
import ch.karatojava.kapps.multikaraide.worldobjects.FORBIDDENFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.MEETINGROOMFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.MONITORFIELD;
import ch.karatojava.kapps.multikaraide.worldobjects.STREET;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class MultiKaraWorldEditorFacade
extends KaraWorldEditorFacade {
    private MultiKaraSchedulerView schedulerView;
    protected SchedulerListener schedulerListener = new SchedulerListener.Adapter(){

        @Override
        public void processPriorityChanged(Object object, int n) {
            if (MultiKaraWorldEditorFacade.this.worldEditorIOToolbar != null) {
                MultiKaraWorldEditorFacade.this.worldEditor.setModified();
            }
        }

        @Override
        public void processClientPropertySet(Object object, Object object2) {
            if (MultiKaraWorldEditorFacade.this.worldEditorIOToolbar != null && ((String)object).equals("puttokaraparking")) {
                MultiKaraWorldEditorFacade.this.worldEditor.setModified();
            }
            if (MultiKaraWorldEditorFacade.this.worldEditorIOToolbar != null && ((String)object).equals("resetprioritypanel")) {
                MultiKaraWorldEditorFacade.this.worldEditor.setModified();
            }
        }
    };
    private MouseListener mouseActivationListener = new MouseAdapter(){
        private Point start;
        private int clickDistance = 3;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Point point2 = MultiKaraWorldEditorFacade.this.worldEditor.getWorldView().getFieldPos(point.x, point.y);
            if (point2 != null && MultiKaraWorldEditorFacade.this.worldEditor.getWorld().isObjectOfTypeAt(Kara.getKaras()[0], point2.x, point2.y)) {
                MultiKara multiKara = (MultiKara)MultiKaraWorldEditorFacade.this.worldEditor.getWorld().getObjectOfTypeAt(Kara.getKaras()[0], point2.x, point2.y);
                ((MultiKaraActorCommandsToolbar)MultiKaraWorldEditorFacade.this.karaCommandToolbar).setActorToControl(multiKara.getIdentity());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.start = mouseEvent.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.start != null && this.start.distance(mouseEvent.getPoint()) < (double)this.clickDistance) {
                this.mouseClicked(mouseEvent);
            }
            this.start = null;
        }
    };
    private PropertyChangeListener actorActivationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("kara removed")) {
                ((MultiKaraActorCommandsToolbar)MultiKaraWorldEditorFacade.this.karaCommandToolbar).resetActorToControl((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof MultiKara) {
                ((MultiKaraActorCommandsToolbar)MultiKaraWorldEditorFacade.this.karaCommandToolbar).setActorToControl(((MultiKara)propertyChangeEvent.getNewValue()).getIdentity());
            }
        }
    };

    @Override
    public JComponent getNorthPanel() {
        this.schedulerView.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/worldeditor/schedulerpanel/title"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.schedulerView, "Center");
        return jPanel;
    }

    public MultiKaraSchedulerView getSchedulerView() {
        return this.schedulerView;
    }

    @Override
    public int getNumberOfInitSteps() {
        return 9;
    }

    @Override
    public SchedulerListener[] getSchedulerListeners() {
        return new SchedulerListener[]{this.schedulerListener};
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        jLabel.setText("creating karas ...");
        this.createKaraPrototypes();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world objects ...");
        super.createWorldObjects();
        jProgressBar.setValue(++n);
        jLabel.setText("creating street objects ...");
        this.createWorldStreetObjects();
        jProgressBar.setValue(++n);
        jLabel.setText("creating concurrency objects ...");
        this.createWorldConcurrencyObjects();
        jProgressBar.setValue(++n);
        jLabel.setText("creating world editor ...");
        this.worldEditor = this.createWorldEditor();
        this.worldEditor.getWorldView().addPropertyChangeListener("kara put", this.actorActivationListener);
        this.worldEditor.getWorldView().addPropertyChangeListener("kara removed", this.actorActivationListener);
        this.worldEditor.getWorldView().addMouseListener(this.mouseActivationListener);
        jProgressBar.setValue(++n);
        jLabel.setText("creating world editor io toolbar  ...");
        this.worldEditorIOToolbar = this.createWorldEditorIOToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating kara toolbar  ...");
        this.karaCommandToolbar = this.createkaraCommandToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating world toolbar ...");
        this.worldEditorToolbar = this.createworldEditorToolbar(this.worldEditor);
        jProgressBar.setValue(++n);
        jLabel.setText("creating zoom toolbar  ...");
        this.westPanel = this.createWestPanel(this.worldEditor);
        jProgressBar.setValue(++n);
        return n;
    }

    protected void createWorldStreetObjects() {
        Konfig.addWorldObject(STREET.getInstance(1));
        Konfig.addWorldObject(STREET.getInstance(2));
        Konfig.addWorldObject(STREET.getInstance(4));
        Konfig.addWorldObject(STREET.getInstance(8));
        for (int i = 1; i < 16; ++i) {
            Konfig.addWorldImage(STREET.getInstance(i), Configuration.getInstance().getImageIcon("schemes/ladybugscheme/street/streeticon" + i));
            STREET.getInstance(i).setClientProperty("WorldEditorToolbarTooltip", "language/$language/kawomodel/objectdescriptions/street");
        }
    }

    protected void createWorldConcurrencyObjects() {
        MEETINGROOMFIELD.getInstance().setClientProperty("WorldEditorToolbarTooltip", Konstants.WORLDOBJECT_DESCRIPTIONS[MEETINGROOMFIELD.getInstance().getType()]);
        Konfig.addWorldObject(MEETINGROOMFIELD.getInstance());
        Konfig.addWorldImage(MEETINGROOMFIELD.getInstance(), Configuration.getInstance().getImageIcon(Konstants.MEETINGROOMOBJECT_ICONS[1]));
        Konfig.addWorldImage(MEETINGROOMFIELD.getInstance(), Configuration.getInstance().getImageIcon(Konstants.MEETINGROOMOBJECT_ICONS[0]));
        MONITORFIELD.getInstance().setClientProperty("WorldEditorToolbarTooltip", Konstants.WORLDOBJECT_DESCRIPTIONS[MONITORFIELD.getInstance().getType()]);
        Konfig.addWorldObject(MONITORFIELD.getInstance());
        Konfig.addWorldImage(MONITORFIELD.getInstance(), Configuration.getInstance().getImageIcon(Konstants.MONITOROBJECT_ICONS[1]));
        Konfig.addWorldImage(MONITORFIELD.getInstance(), Configuration.getInstance().getImageIcon(Konstants.MONITOROBJECT_ICONS[0]));
        Konfig.addWorldImage(FORBIDDENFIELD.getInstance(), Configuration.getInstance().getImageIcon("schemes/ladybugscheme/concurrency/forbiddenfield"));
    }

    @Override
    protected void createKaraPrototypes() {
        int n = 1;
        String string = Configuration.getInstance().getString("karamodel/$karamodel/karaidentities");
        List<String> list = Configuration.split(string, ",");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            MultiKara multiKara = new MultiKara(string2, n);
            Kara.addKaraPrototype(multiKara);
            ImageIcon imageIcon = Configuration.getInstance().getImageIcon("schemes/ladybugscheme/" + string2 + "/paintedicon");
            Konfig.addWorldImage(LEAF.getInstance(n), imageIcon);
            ImageIcon[] imageIconArray = multiKara.getKaraImageIcons();
            for (int j = 0; j < imageIconArray.length; ++j) {
                Konfig.addWorldImage(multiKara, imageIconArray[j]);
            }
            multiKara.setGUIID(multiKara.getGUIID() - multiKara.getDirection() - 3);
            multiKara.setDirection(0);
            ++n;
        }
    }

    protected MultiKaraSchedulerView createSchedulerView() {
        return new MultiKaraSchedulerView();
    }

    @Override
    protected WorldEditor createWorldEditor() {
        this.schedulerView = this.createSchedulerView();
        return new WorldEditor(MultiKaraWorldBuilder.getInstance(), MultiKaraWorldOutputter.getInstance());
    }

    @Override
    protected KaraActorCommandsToolbar createkaraCommandToolbar(WorldEditor worldEditor) {
        return new MultiKaraActorCommandsToolbar(worldEditor);
    }
}

