/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.kapps.tasks.TaskControllerInterface;
import ch.karatojava.kapps.tasks.TestCaseInterface;
import ch.karatojava.kapps.tasks.WorldResource;
import ch.karatojava.kapps.world.World;
import ch.karatojava.util.Configuration;

public abstract class AbstractTestCase
implements TestCaseInterface {
    protected Exception exception;
    protected String nameKey;
    protected String worldFilePath;
    protected World world;

    @Override
    public void initializeFromConfig(TaskControllerInterface taskControllerInterface, String string) {
        this.nameKey = Configuration.getInstance().getString(string + "namekey");
        this.worldFilePath = Configuration.getInstance().getString(string + "file");
        if (!this.worldFilePath.equals("")) {
            try {
                this.world = taskControllerInterface.loadWorld(this.worldFilePath);
            }
            catch (Exception exception) {
                throw new RuntimeException("AbstractTestCase.initializeFromConfig: can not load world " + this.worldFilePath + "\n" + "Original exception was: " + exception.getMessage());
            }
        }
    }

    public boolean initialized() {
        return this.nameKey != null;
    }

    @Override
    public String getNameKey() {
        return this.nameKey;
    }

    @Override
    public World getInitialWorld() {
        World world = null;
        if (this.world != null) {
            world = new World(this.world);
        }
        return world;
    }

    @Override
    public WorldResource getInitialWorldAsResource() {
        return new WorldResource(this, this.nameKey);
    }

    @Override
    public String causeOfFailure() {
        String string = this.exception != null ? this.exception.getMessage() : "";
        return string;
    }

    @Override
    public void setProgramException(Exception exception) {
        this.exception = exception;
    }
}

