/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.tasks.DummyTask;
import ch.karatojava.kapps.tasks.ProgramPanel;
import ch.karatojava.kapps.tasks.ProgramResource;
import ch.karatojava.kapps.tasks.TaskControllerInterface;
import ch.karatojava.kapps.tasks.TaskControllerListener;
import ch.karatojava.kapps.tasks.TaskInterface;
import ch.karatojava.kapps.tasks.TestCasesPanel;
import ch.karatojava.kapps.tasks.WorldsPanel;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.FrameChangeListener;
import ch.karatojava.util.gui.HTMLEditorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;

public class TaskControllerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected TaskControllerInterface taskController;
    protected TaskInterface currentTask;
    protected TaskInterface[] allTasks;
    protected JComboBox tasksComboBox;
    protected JTabbedPane[] taskPanels;
    protected JTabbedPane currentTaskPanel;
    protected FrameChangeListener configChangeListener;
    protected WindowListener windowCloseListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            try {
                TaskControllerFrame.this.taskController.stopTesting();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    protected ItemListener taskSelectionListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!(itemEvent.getItem() instanceof String)) {
                int n = ((TaskItem)itemEvent.getItem()).index;
                TaskControllerFrame.this.currentTask = TaskControllerFrame.this.allTasks[n];
                TaskControllerFrame.this.initializeTaskPanel(TaskControllerFrame.this.currentTask);
            } else {
                TaskControllerFrame.this.getContentPane().remove(TaskControllerFrame.this.currentTaskPanel);
            }
        }
    };
    protected TaskControllerListener tcListener = new TaskControllerListener.Adapter(){
        protected boolean isEditable = true;
        protected JFrame applicationFrame = KaraGuiFactory.getInstance().getApplicationFrame();
        protected MouseInputAdapter dummyMouse = new MouseInputAdapter(){

            protected MouseEvent translateEvent(MouseEvent mouseEvent, Component component) {
                int n = component.getLocationOnScreen().x - applicationFrame.getContentPane().getLocationOnScreen().x;
                int n2 = component.getLocationOnScreen().y - applicationFrame.getContentPane().getLocationOnScreen().y;
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return mouseEvent2;
            }

            protected void forwardToSliderOnly(MouseEvent mouseEvent, boolean bl) {
                Component component = applicationFrame.getContentPane().findComponentAt(mouseEvent.getPoint());
                if (component instanceof JSlider) {
                    component.dispatchEvent(this.translateEvent(mouseEvent, component));
                } else if (bl) {
                    ExceptionActionListener.reportException(applicationFrame, Configuration.getInstance().getString("language/$language/tasks/gui/donotmodifytitle"), new Exception(Configuration.getInstance().getString("language/$language/tasks/gui/donotmodify")));
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, false);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, false);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, false);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.forwardToSliderOnly(mouseEvent, false);
            }
        };

        protected void setEditable(boolean bl) {
            Component component = this.applicationFrame.getGlassPane();
            if (!bl && this.isEditable) {
                component.addMouseListener(this.dummyMouse);
                component.addMouseMotionListener(this.dummyMouse);
                component.setVisible(true);
            } else if (bl && !this.isEditable) {
                component.setVisible(false);
                component.removeMouseListener(this.dummyMouse);
                component.removeMouseMotionListener(this.dummyMouse);
            }
            this.isEditable = bl;
        }

        @Override
        public void startingTask(TaskInterface taskInterface) {
            this.setEditable(false);
            TaskControllerFrame.this.tasksComboBox.setEnabled(false);
        }

        @Override
        public void finishedTask(TaskInterface taskInterface) {
            this.setEditable(true);
            TaskControllerFrame.this.tasksComboBox.setEnabled(true);
        }
    };

    public TaskControllerFrame(TaskControllerInterface taskControllerInterface) {
        this.addWindowListener(this.windowCloseListener);
        KaraGuiFactory.getInstance().createKaraFrameUi(this, "language/$language/tasks/gui/frametitle");
        int n = Configuration.getInstance().getInt("tasksframe/width");
        int n2 = Configuration.getInstance().getInt("tasksframe/height");
        this.setSize(n, n2);
        KaraGuiFactory.positionFrame(this, 1.0f, 0.5f);
        this.taskController = taskControllerInterface;
        taskControllerInterface.addTcListener(this.tcListener);
        this.allTasks = taskControllerInterface.getTasks();
        this.currentTask = this.allTasks[0];
        JPanel jPanel = (JPanel)this.getContentPane();
        this.tasksComboBox = new JComboBox();
        this.taskPanels = new JTabbedPane[this.allTasks.length];
        jPanel.setLayout(new BorderLayout());
        this.tasksComboBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 10, 4));
        jPanel.add((Component)this.tasksComboBox, "North");
        this.initializeTaskPanel(this.currentTask);
        for (int i = 0; i < this.allTasks.length; ++i) {
            if (!(this.allTasks[i] instanceof DummyTask)) {
                TaskItem taskItem = new TaskItem(i);
                taskItem.setText(Configuration.getInstance().getString(this.allTasks[i].getTaskTitleKey()));
                this.tasksComboBox.addItem(taskItem);
                continue;
            }
            this.tasksComboBox.addItem("------------------------------------------------------------------------------------------------------------------------");
        }
        this.tasksComboBox.addItemListener(this.taskSelectionListener);
    }

    public TaskControllerInterface getTaskController() {
        return this.taskController;
    }

    protected int getTaskIndex(TaskInterface taskInterface) {
        for (int i = 0; i < this.allTasks.length; ++i) {
            if (this.allTasks[i] != taskInterface) continue;
            return i;
        }
        return -1;
    }

    protected void initializeTaskPanel(TaskInterface taskInterface) {
        int n = this.getTaskIndex(taskInterface);
        if (this.taskPanels[n] == null) {
            this.taskPanels[n] = new JTabbedPane();
            GuiFactory.getInstance().addUiSwitchListener(this.taskPanels[n]);
            JScrollPane jScrollPane = new JScrollPane(new HTMLEditorPane(taskInterface.getTaskTextKey()));
            this.taskPanels[n].addTab(Configuration.getInstance().getString("language/$language/tasks/gui/tasktexttitle"), jScrollPane);
            if (taskInterface.getTestCases().length > 0) {
                this.taskPanels[n].addTab(Configuration.getInstance().getString("language/$language/tasks/gui/testcasestitle"), new TestCasesPanel(this.taskController, taskInterface));
            } else if (taskInterface.getWorldResources().length > 0) {
                this.taskPanels[n].addTab(Configuration.getInstance().getString("language/$language/tasks/gui/worldstitle"), new WorldsPanel(this.taskController, taskInterface));
            }
            String string = Configuration.getInstance().getString("tasks/showprograms");
            if (taskInterface.getProgramResources().length > 0 && string.equalsIgnoreCase("yes")) {
                ProgramResource[] programResourceArray = taskInterface.getProgramResources();
                for (int i = 0; i < programResourceArray.length; ++i) {
                    this.taskPanels[n].addTab(Configuration.getInstance().getString(programResourceArray[i].getNameKey()), new ProgramPanel(this.taskController, programResourceArray[i]));
                }
            }
        }
        if (this.currentTaskPanel != null) {
            this.getContentPane().remove(this.currentTaskPanel);
        }
        this.currentTaskPanel = this.taskPanels[n];
        this.currentTaskPanel.setSelectedIndex(0);
        this.currentTaskPanel.validate();
        this.getContentPane().add((Component)this.currentTaskPanel, "Center");
        this.getContentPane().validate();
        this.repaint();
    }

    protected static class TaskItem {
        protected int index;
        protected String text;

        public TaskItem(int n) {
            this.index = n;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String toString() {
            return this.text;
        }
    }
}

