/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.kapps.InterpreterFacadeInterface;
import ch.karatojava.kapps.ProgramEditorFacadeInterface;
import ch.karatojava.kapps.TasksFacadeInterface;
import ch.karatojava.kapps.WorldEditorFacadeInterface;
import ch.karatojava.kapps.tasks.DefaultTaskController;
import ch.karatojava.kapps.tasks.TaskControllerFrame;
import ch.karatojava.util.Configuration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class TasksFacade
implements TasksFacadeInterface {
    protected WorldEditorFacadeInterface worldEditorFacade;
    protected ProgramEditorFacadeInterface programEditorFacade;
    protected InterpreterFacadeInterface interpreterFacade;
    protected boolean hasTasks;
    protected TaskControllerFrame tcFrame;

    public TasksFacade() {
        String string = Configuration.getInstance().getString("karamodel/$karamodel/tasks/$language");
        this.hasTasks = string.equalsIgnoreCase("yes");
    }

    @Override
    public void setFacades(WorldEditorFacadeInterface worldEditorFacadeInterface, ProgramEditorFacadeInterface programEditorFacadeInterface, InterpreterFacadeInterface interpreterFacadeInterface) {
        assert (worldEditorFacadeInterface != null);
        assert (programEditorFacadeInterface != null);
        assert (interpreterFacadeInterface != null);
        this.worldEditorFacade = worldEditorFacadeInterface;
        this.programEditorFacade = programEditorFacadeInterface;
        this.interpreterFacade = interpreterFacadeInterface;
    }

    @Override
    public int getNumberOfInitSteps() {
        return this.hasTasks ? 2 : 0;
    }

    @Override
    public TaskControllerFrame getTasksFrame() {
        return this.tcFrame;
    }

    @Override
    public JComponent getConfigGui() {
        return null;
    }

    @Override
    public int initialize(JProgressBar jProgressBar, JLabel jLabel, int n) {
        if (this.hasTasks) {
            jLabel.setText("creating task controller ...");
            DefaultTaskController defaultTaskController = new DefaultTaskController();
            defaultTaskController.setFacades(this.worldEditorFacade, this.programEditorFacade, this.interpreterFacade);
            defaultTaskController.initialize();
            jProgressBar.setValue(++n);
            jLabel.setText("creating task gui frame ...");
            this.tcFrame = new TaskControllerFrame(defaultTaskController);
            jProgressBar.setValue(++n);
        }
        return n;
    }
}

