/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks;

import ch.karatojava.kapps.tasks.TaskControllerInterface;
import ch.karatojava.kapps.tasks.TaskInterface;
import ch.karatojava.kapps.tasks.WorldResource;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WorldsPanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    protected static final String WORLDRESOURCE_CLIENT_PROPERTY = "world resource";
    protected WorldResource[] worldResources;
    protected TaskControllerInterface taskController;
    protected TaskInterface task;

    public WorldsPanel(TaskControllerInterface taskControllerInterface, TaskInterface taskInterface) {
        this.taskController = taskControllerInterface;
        this.task = taskInterface;
        this.worldResources = taskInterface.getWorldResources();
        this.createGui();
    }

    protected void createGui() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        this.setViewportView(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(GuiFactory.getInstance().createLabel("language/$language/tasks/gui/worldpanellabel"));
        for (int i = 0; i < this.worldResources.length; ++i) {
            JButton jButton = new JButton();
            jButton.setText(Configuration.getInstance().getString(this.worldResources[i].getNameKey()));
            jButton.putClientProperty(WORLDRESOURCE_CLIENT_PROPERTY, this.worldResources[i]);
            jButton.addActionListener(new ExceptionActionListener(){

                @Override
                public void action(ActionEvent actionEvent) throws Exception {
                    JButton jButton = (JButton)actionEvent.getSource();
                    WorldResource worldResource = (WorldResource)jButton.getClientProperty(WorldsPanel.WORLDRESOURCE_CLIENT_PROPERTY);
                    WorldsPanel.this.taskController.showWorld(worldResource);
                }
            });
            jPanel.add(Box.createVerticalStrut(10));
            jPanel.add(jButton);
        }
    }
}

