/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks.kara;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.karaide.worldobjects.TREE;
import ch.karatojava.kapps.tasks.kara.FollowwallTestCase;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import java.util.ArrayList;

public class FollowwallRandomTestCase
extends FollowwallTestCase {
    int sizeX;
    int sizeY;
    int numOfLeafs;
    ArrayList<WorldField> points;
    ArrayList<WorldField> neighbours;

    public FollowwallRandomTestCase() {
        WorldField worldField2;
        this.sizeY = this.sizeX = (int)(6.0 + 6.0 * Math.random());
        this.numOfLeafs = (this.sizeX - 4) * (this.sizeY - 4) * 2 / 3;
        this.points = new ArrayList();
        this.neighbours = new ArrayList();
        int n = this.sizeX / 2;
        int n2 = this.sizeY / 2;
        this.world = new World(this.sizeX, this.sizeY);
        this.points.add(this.world.getWorldFieldAt(n, n2));
        this.addNeighbours(n, n2);
        for (int i = 0; i < this.numOfLeafs - 1; ++i) {
            this.addOne();
        }
        for (WorldField worldField2 : this.points) {
            this.world.putObjectAt(LEAF.getInstance(), worldField2.getX(), worldField2.getY());
        }
        for (WorldField worldField2 : this.neighbours) {
            this.world.putObjectAt(TREE.getInstance(), worldField2.getX(), worldField2.getY());
        }
        Kara kara = (Kara)Kara.getKara("Kara").cloneWorldObject();
        int n3 = this.sizeY / 2;
        while (!(worldField2 = this.world.getWorldFieldAt(this.sizeX / 2, ++n3)).isEmpty()) {
        }
        this.world.putObjectAt(kara, this.sizeX / 2, n3);
        kara.setDirection(1);
    }

    protected void addNeighbours(int n, int n2) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i * j != 0 || i == 0 && j == 0 || this.points.contains(this.world.getWorldFieldAt(this.mod(n + i, this.sizeX), this.mod(n2 + j, this.sizeY))) || this.neighbours.contains(this.world.getWorldFieldAt(this.mod(n + i, this.sizeX), this.mod(n2 + j, this.sizeY)))) continue;
                this.neighbours.add(this.world.getWorldFieldAt(this.mod(n + i, this.sizeX), this.mod(n2 + j, this.sizeY)));
            }
        }
    }

    protected void addOne() {
        int n = (int)((double)(this.neighbours.size() - 1) * Math.random());
        WorldField worldField = this.neighbours.get(n);
        if (worldField.getX() > 1 && worldField.getX() < this.sizeX - 2 && worldField.getY() > 1 && worldField.getY() < this.sizeY - 2) {
            this.points.add(worldField);
            this.addNeighbours(worldField.getX(), worldField.getY());
            this.neighbours.remove(n);
        }
    }

    protected int mod(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n2 + n % n2;
    }
}

