/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.tasks.kara;

import ch.karatojava.interpreter.InterpreterListener;
import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.karaide.worldobjects.LEAF;
import ch.karatojava.kapps.tasks.AbstractTestCase;
import ch.karatojava.kapps.world.World;
import ch.karatojava.util.Configuration;

public class LevellabTestCase
extends AbstractTestCase {
    protected int lastWorldHashCode;
    protected boolean testPassed;
    protected int leafXPos;
    protected String cause;

    @Override
    public World getInitialWorld() {
        this.exception = null;
        World world = super.getInitialWorld();
        for (int i = 0; i < this.world.getSizeX(); ++i) {
            if (!this.world.isObjectOfTypeAt(LEAF.getInstance(), i, 0)) continue;
            this.leafXPos = i;
            break;
        }
        return world;
    }

    @Override
    public InterpreterListener getInterpreterListener() {
        return null;
    }

    @Override
    public boolean testPassed(World world) {
        if (world.hashCode() != this.lastWorldHashCode) {
            Kara kara = Kara.findKaraInWorld(world, "Kara");
            if (kara.getPosition().y == 0 && kara.getPosition().x == this.leafXPos) {
                if (!world.isObjectOfTypeAt(LEAF.getInstance(), this.leafXPos, 0)) {
                    this.testPassed = true;
                } else {
                    this.cause = this.getString("language/$language/tasks/kara/levellab/causeoffailure_leaf");
                    this.testPassed = false;
                }
            } else if (!world.isObjectOfTypeAt(LEAF.getInstance(), this.leafXPos, 0)) {
                this.cause = kara.getPosition().y == 0 ? this.getString("language/$language/tasks/kara/levellab/causeoffailure_position1") : this.getString("language/$language/tasks/kara/levellab/causeoffailure_position2");
                this.testPassed = false;
            } else {
                this.cause = kara.getPosition().y == 0 ? this.getString("language/$language/tasks/kara/levellab/causeoffailure_leaf_position1") : this.getString("language/$language/tasks/kara/levellab/causeoffailure_leaf_position2");
                this.testPassed = false;
            }
            this.testPassed = this.testPassed && this.exception == null;
            this.lastWorldHashCode = world.hashCode();
        }
        return this.testPassed;
    }

    @Override
    public String causeOfFailure() {
        String string = super.causeOfFailure();
        if (!string.equals("")) {
            this.cause = string;
        }
        return this.cause;
    }

    protected String getString(String string) {
        return Configuration.getInstance().getString(string);
    }
}

