/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turingkaraide.statetableeditor;

import ch.karatojava.kapps.actorfsm.SensorTypeInterface;
import ch.karatojava.kapps.actorfsm.State;
import ch.karatojava.kapps.actorfsm.Transition;
import ch.karatojava.util.gui.JGridPanel;
import ch.karatojava.util.gui.dndpanel.TrashableInterface;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class TuringKaraSensorPanel
extends JGridPanel {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_SENSORS_PER_ROW = 4;
    protected static final Border SENSOR_BORDER = new LineBorder(Color.lightGray, 1);
    protected SensorLabel[] sensorLabels;
    protected boolean editable;
    protected Transition transition;
    protected SensorTypeInterface[] sensors;

    public TuringKaraSensorPanel(Transition transition) {
        this(transition.getFrom().getSensors(), true);
        this.transition = transition;
        for (int i = 0; i < this.sensors.length; ++i) {
            int n = transition.getSensorInput(this.sensors[i]);
            assert (n != 2) : "TuringKaraSensorPanel.constructor: FALSE not allowed";
            this.sensorLabels[i].setSensorVisibility(n == 1);
        }
    }

    public TuringKaraSensorPanel(State state) {
        this(state.getSensors(), false);
        for (int i = 0; i < this.sensors.length; ++i) {
            this.sensorLabels[i].setSensorVisibility(true);
        }
    }

    protected TuringKaraSensorPanel(SensorTypeInterface[] sensorTypeInterfaceArray, boolean bl) {
        super(true, 4, sensorTypeInterfaceArray.length);
        this.editable = bl;
        this.sensors = sensorTypeInterfaceArray;
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 2));
        this.sensorLabels = new SensorLabel[sensorTypeInterfaceArray.length];
        for (int i = 0; i < sensorTypeInterfaceArray.length; ++i) {
            this.sensorLabels[i] = new SensorLabel(sensorTypeInterfaceArray[i]);
            this.add(this.sensorLabels[i]);
        }
    }

    protected class SensorLabel
    extends JLabel
    implements TrashableInterface {
        private static final long serialVersionUID = 1L;
        private SensorTypeInterface sensor;
        private boolean sensorUsed;
        private ImageIcon unselectedIcon;
        private MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (TuringKaraSensorPanel.this.transition != null) {
                    TuringKaraSensorPanel.this.transition.setSensorInput(SensorLabel.this.sensor, SensorLabel.this.sensorUsed ? 0 : 1);
                    SensorLabel.this.setSensorVisibility(!SensorLabel.this.sensorUsed);
                }
            }
        };

        public SensorLabel(SensorTypeInterface sensorTypeInterface) {
            this.sensor = sensorTypeInterface;
            this.sensorUsed = false;
            Dimension dimension = new Dimension(sensorTypeInterface.getIcon().getIconWidth() + 2, sensorTypeInterface.getIcon().getIconHeight() + 2);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.setSize(dimension);
            this.setOpaque(false);
            this.setBorder(SENSOR_BORDER);
            this.addMouseListener(this.mouseListener);
            BufferedImage bufferedImage = new BufferedImage(sensorTypeInterface.getIcon().getIconWidth(), sensorTypeInterface.getIcon().getIconHeight(), 6);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
            graphics2D.drawImage(sensorTypeInterface.getIcon().getImage(), 0, 0, null);
            graphics2D.dispose();
            this.unselectedIcon = new ImageIcon(bufferedImage);
            this.setSensorVisibility(false);
        }

        public void setSensorVisibility(boolean bl) {
            this.sensorUsed = bl;
            if (bl) {
                this.setIcon(this.sensor.getIcon());
            } else {
                this.setIcon(this.unselectedIcon);
            }
        }
    }
}

