/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turingkaraide.worldio;

import ch.karatojava.kapps.karaide.Kara;
import ch.karatojava.kapps.turingkaraide.TuringKara;
import ch.karatojava.kapps.turingkaraide.TuringObject;
import ch.karatojava.kapps.turingkaraide.worldio.XmlKara;
import ch.karatojava.kapps.turingkaraide.worldio.XmlWorld;
import ch.karatojava.kapps.turingkaraide.worldio.XmlWorldObject;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldObject;
import ch.karatojava.kapps.world.WorldObjectInterface;
import ch.karatojava.kapps.world.editor.io.WorldOutputterInterface;
import ch.karatojava.util.Configuration;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;

public class TuringKaraWorldOutputter
implements WorldOutputterInterface {
    private static TuringKaraWorldOutputter instance;
    public static String version;

    public static WorldOutputterInterface getInstance() {
        if (instance == null) {
            instance = new TuringKaraWorldOutputter();
        }
        return instance;
    }

    @Override
    public void outputWorld(World world, OutputStream outputStream) throws Exception {
        WorldField worldField;
        XmlWorld xmlWorld = new XmlWorld();
        xmlWorld.setSizex(world.getSizeX());
        xmlWorld.setSizey(world.getSizeY());
        xmlWorld.setVersion(version);
        List<WorldField> list = world.getObjectFieldsVector();
        for (int i = 0; i < list.size(); ++i) {
            worldField = list.get(i);
            WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
            for (int j = 0; j < worldObjectInterfaceArray.length; ++j) {
                Object object;
                WorldObject worldObject;
                WorldObjectInterface worldObjectInterface = worldObjectInterfaceArray[j];
                if (worldObjectInterface == null) continue;
                int n = worldObjectInterface.getType();
                if (n == 8) {
                    worldObject = (TuringKara)worldObjectInterface;
                    object = new XmlKara();
                    ((XmlKara)object).setDirection(((Kara)worldObject).getDirection());
                    ((XmlKara)object).setName(((Kara)worldObject).getIdentity());
                    ((XmlKara)object).setX(worldField.getX());
                    ((XmlKara)object).setY(worldField.getY());
                    xmlWorld.getXmlKara().add((XmlKara)object);
                    continue;
                }
                worldObject = (TuringObject)worldObjectInterface;
                object = new XmlWorldObject();
                ((XmlWorldObject)object).setType(((TuringObject)worldObject).getLetter());
                ((XmlWorldObject)object).setX(worldField.getX());
                ((XmlWorldObject)object).setY(worldField.getY());
                xmlWorld.getXmlWorldObject().add((XmlWorldObject)object);
            }
        }
        JAXBContext jAXBContext = JAXBContext.newInstance((String)"ch.karatojava.kapps.turingkaraide.worldio");
        worldField = jAXBContext.createMarshaller();
        worldField.setProperty("jaxb.formatted.output", Boolean.TRUE);
        worldField.marshal(xmlWorld, outputStream);
    }

    static {
        version = "KaraX 1.0 " + Configuration.getInstance().getString("karamodel/$karamodel/savefiletype");
    }
}

