/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turtleworld;

import ch.karatojava.kapps.turtleworld.TurtleWorld;
import java.awt.BasicStroke;
import java.awt.Color;

public class Turtle {
    protected static final int DEFAULT_PEN_WIDTH = 2;
    protected static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(2.0f, 1, 2);
    protected static final Color DEFAULT_COLOR = new Color(0, 0, 0);
    protected double x = 0.0;
    protected double y = 0.0;
    protected double direction = 0.0;
    protected boolean penDown = true;
    protected boolean xor;
    protected boolean visible = true;
    protected TurtleWorld turtleWorld;
    protected Color color = DEFAULT_COLOR;
    protected int penWidth = 2;
    protected BasicStroke lineStroke = DEFAULT_LINE_STROKE;

    public Turtle() {
    }

    public Turtle(TurtleWorld turtleWorld) {
        this();
        this.turtleWorld = turtleWorld;
    }

    public double getDirection() {
        return this.direction;
    }

    public void setDirection(double d) {
        if (d < 0.0 || d > 360.0) {
            throw new IllegalArgumentException("turtle.setDirection: direction must be 0..360");
        }
        this.direction = d;
        this.turtleWorld.repaint();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        int n = this.turtleWorld.getWorldSizeX() / 2;
        if (d < (double)(-n) || d > (double)n) {
            throw new IllegalArgumentException("turtle.setX: x must be -" + n + ".." + n);
        }
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        int n = this.turtleWorld.getWorldSizeY() / 2;
        if (d < (double)(-n) || d > (double)n) {
            throw new IllegalArgumentException("turtle.setY: y must be -" + n + ".." + n);
        }
        this.y = d;
    }

    public boolean isPenDown() {
        return this.penDown;
    }

    public void setPenDown(boolean bl) {
        this.penDown = bl;
    }

    public void penUp() {
        this.penDown = false;
    }

    public void penDown() {
        this.penDown = true;
    }

    public boolean isXor() {
        return this.xor;
    }

    public void setXor(boolean bl) {
        this.xor = bl;
    }

    public TurtleWorld getTurtleWorld() {
        return this.turtleWorld;
    }

    public void setTurtleWorld(TurtleWorld turtleWorld) {
        this.turtleWorld = turtleWorld;
    }

    public void moveto(double d, double d2) {
        int n = this.turtleWorld.getWorldSizeX() / 2;
        if (d < (double)(-n) || d > (double)n) {
            throw new IllegalArgumentException("turtle.moveto: xnew must be -" + n + ".." + n);
        }
        int n2 = this.turtleWorld.getWorldSizeY() / 2;
        if (d2 < (double)(-n2) || d2 > (double)n2) {
            throw new IllegalArgumentException("turtle.moveto: ynew must be -" + n2 + ".." + n2);
        }
        if (this.penDown) {
            this.turtleWorld.drawLine((int)this.x, (int)this.y, (int)d, (int)d2, this.color, this.lineStroke, this.xor);
        }
        this.x = d;
        this.y = d2;
        this.turtleWorld.repaint();
    }

    public void forward(double d) {
        double d2 = this.x;
        double d3 = this.y;
        this.x += Math.cos(Math.toRadians(this.direction)) * d;
        this.y += Math.sin(Math.toRadians(this.direction)) * d;
        int n = this.turtleWorld.getWorldSizeX() / 2;
        if (this.x < (double)(-n) || this.x > (double)n) {
            throw new IllegalArgumentException("turtle.forward: new x outside -" + n + ".." + n);
        }
        int n2 = this.turtleWorld.getWorldSizeY() / 2;
        if (this.y < (double)(-n2) || this.y > (double)n2) {
            throw new IllegalArgumentException("turtle.forward: new y outside -" + n2 + ".." + n2);
        }
        if (this.penDown) {
            this.turtleWorld.drawLine((int)d2, (int)d3, (int)this.x, (int)this.y, this.color, this.lineStroke, this.xor);
        }
        this.turtleWorld.repaint();
    }

    public void turn(double d) {
        if (d < 0.0 || d > 360.0) {
            throw new IllegalArgumentException("turtle.turn: angle must be 0..360");
        }
        this.direction = (this.direction + d) % 360.0;
        while (this.direction < 0.0) {
            this.direction += 360.0;
        }
        this.turtleWorld.repaint();
    }

    public void setColor(int n, int n2, int n3) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("turtle.setColor: r must be 0..255");
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("turtle.setColor: g must be 0..255");
        }
        if (n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("turtle.setColor: b must be 0..255");
        }
        this.color = new Color(n, n2, n3);
    }

    public Color getColor() {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public int getColorRed() {
        return this.color.getRed();
    }

    public int getColorGreen() {
        return this.color.getGreen();
    }

    public int getColorBlue() {
        return this.color.getBlue();
    }

    public void setPenWidth(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("turtle.setPenWidth: width must be 0..100");
        }
        this.penWidth = n;
        this.lineStroke = new BasicStroke(n, 1, 2);
    }

    public int getPenWidth() {
        return this.penWidth;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public String toString() {
        return "Turtle: {x => " + this.x + ", y => " + this.y + ", direction => " + this.direction + ", visible => " + this.visible + ", penWidth => " + this.penWidth + ", color => rgb(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")}";
    }
}

