/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.turtleworld;

import ch.karatojava.kapps.turtleworld.Turtle;
import ch.karatojava.kapps.turtleworld.TurtleWorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.gui.ZoomableJComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class TurtleWorld
extends ZoomableJComponent {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_WORLD_SIZE = 2000;
    protected static final int TURTLE_IMAGE_SIZE = 28;
    protected static final BufferedImage[] TURTLE_IMAGES = new BufferedImage[360];
    protected int worldSizeX;
    protected int worldSizeY;
    protected BufferedImage world;
    protected Graphics2D worldGraphics;
    protected List<Turtle> turtles;
    protected boolean modified;
    protected Line2D line;
    protected TurtleWorldEditor turtleWorldEditor;

    public TurtleWorld(TurtleWorldEditor turtleWorldEditor) {
        this.turtleWorldEditor = turtleWorldEditor;
        this.clear();
    }

    protected BufferedImage createWorld() {
        BufferedImage bufferedImage = new BufferedImage(this.worldSizeX, this.worldSizeY, 2);
        this.worldGraphics = (Graphics2D)bufferedImage.getGraphics();
        this.worldGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return bufferedImage;
    }

    public List<Turtle> getTurtles() {
        return this.turtles;
    }

    public void clear() {
        this.turtles = new ArrayList<Turtle>();
        this.addTurtle();
        this.worldSizeX = 2000;
        this.worldSizeY = 2000;
        this.line = new Line2D.Float();
        if (this.world == null) {
            this.world = this.createWorld();
        } else {
            this.worldGraphics.setPaintMode();
            this.worldGraphics.setColor(this.getParent().getBackground());
            this.worldGraphics.fillRect(0, 0, this.worldSizeX, this.worldSizeY);
        }
        this.setModified(false);
        this.repaint();
    }

    public int getWorldSizeX() {
        return this.worldSizeX;
    }

    public void setWorldSizeX(int n) {
        this.worldSizeX = n;
    }

    public int getWorldSizeY() {
        return this.worldSizeY;
    }

    public void setWorldSizeY(int n) {
        this.worldSizeY = n;
    }

    protected double transformX(double d) {
        return (double)(this.worldSizeX / 2) + d;
    }

    protected double transformY(double d) {
        return (double)(this.worldSizeX / 2) - d;
    }

    public void drawLine(double d, double d2, double d3, double d4, Color color, Stroke stroke, boolean bl) {
        int n = (int)this.transformX(d);
        int n2 = (int)this.transformY(d2);
        int n3 = (int)this.transformX(d3);
        int n4 = (int)this.transformY(d4);
        this.line.setLine(n, n2, n3, n4);
        this.worldGraphics.setPaint(color);
        this.worldGraphics.setStroke(stroke);
        if (bl) {
            this.worldGraphics.setXORMode(this.getParent().getBackground());
        } else {
            this.worldGraphics.setPaintMode();
        }
        this.worldGraphics.draw(this.line);
        this.repaint();
        this.setModified(true);
    }

    public Turtle addTurtle() {
        Turtle turtle = new Turtle();
        this.turtles.add(turtle);
        turtle.setTurtleWorld(this);
        this.setModified(true);
        return turtle;
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        graphics.drawImage(this.world, this.offsetX, this.offsetY, null);
        for (Turtle turtle : this.turtles) {
            if (!turtle.isVisible()) continue;
            int n = (int)((double)this.offsetX + this.transformX(turtle.getX()) - 14.0);
            int n2 = (int)((double)this.offsetY + this.transformY(turtle.getY()) - 14.0);
            graphics.drawImage(TURTLE_IMAGES[(int)turtle.getDirection()], n, n2, null);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (bl) {
            this.turtleWorldEditor.notifyModification();
        }
    }

    public BufferedImage getWorldImage() {
        return this.world;
    }

    public void setWorldImage(BufferedImage bufferedImage) {
        this.clear();
        this.worldGraphics.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        this.repaint();
    }

    public TurtleWorldEditor getTurtleWorldEditor() {
        return this.turtleWorldEditor;
    }

    @Override
    protected int getTotalHeight() {
        return this.getWorldSizeX();
    }

    @Override
    protected int getTotalWidth() {
        return this.getWorldSizeY();
    }

    static {
        Image image = Configuration.getInstance().getImage("icons/turtles/turtleFacingEastIcon");
        for (int i = 0; i < 360; ++i) {
            TurtleWorld.TURTLE_IMAGES[i] = new BufferedImage(28, 28, 2);
            Graphics2D graphics2D = (Graphics2D)TURTLE_IMAGES[i].getGraphics();
            graphics2D.rotate(Math.toRadians(-i), 14.0, 14.0);
            graphics2D.drawImage(image, 0, 0, null);
        }
    }
}

