/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world;

import ch.karatojava.kapps.world.WorldField;
import ch.karatojava.kapps.world.WorldInternalException;
import ch.karatojava.kapps.world.WorldListener;
import ch.karatojava.kapps.world.WorldObjectInterface;
import java.util.ArrayList;
import java.util.List;

public class World {
    public static final int MIN_WORLD_SIZE = 1;
    public static final int MAX_WORLD_SIZE = 1000;
    public static final int NORTH = 0;
    public static final int WEST = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    private int sizeX;
    private int sizeY;
    private WorldField[][] fields;
    private List<WorldField> objectFieldsList;
    private List<WorldListener> listeners;
    private WorldListener[] listenerArray = new WorldListener[0];
    private int worldTime = 0;
    private boolean eventFiring;

    public World(int n, int n2) {
        this.checkSize(n, n2);
        this.sizeX = n;
        this.sizeY = n2;
        this.eventFiring = false;
        this.listeners = new ArrayList<WorldListener>();
        this.clearAll();
    }

    public World() {
        this(0, 0);
    }

    public World(World world) {
        this(world.sizeX, world.sizeY);
        this.cloneObjects(world);
    }

    public final synchronized void incWorldTime() {
        this.worldTime = (this.worldTime + 1) % 12;
        this.fireWorldTimeEvent(false);
    }

    public final synchronized void resetWorldTime() {
        this.worldTime = 0;
        this.fireWorldTimeEvent(true);
    }

    public void checkSize(int n, int n2) {
        if (n > 1000 || n < 1 || n2 > 1000 || n2 < 1) {
            throw new WorldInternalException("language/$language/worldeditor/worldsizedialog/errmsg", new String[]{"1", "1000"});
        }
    }

    public static boolean sizeOk(int n, int n2) {
        return 1 <= n && n <= 1000 && 1 <= n2 && n2 <= 1000;
    }

    public static boolean directionOk(int n) {
        return 0 <= n && n <= 3;
    }

    public synchronized void setSize(int n, int n2) {
        int n3;
        int n4;
        this.checkSize(n, n2);
        int n5 = this.sizeX > n ? n : this.sizeX;
        int n6 = n4 = this.sizeY > n2 ? n2 : this.sizeY;
        if (n < this.sizeX || n2 < this.sizeY) {
            this.removeObjectOutsideWorld(n, n2);
        }
        WorldField[][] worldFieldArray = new WorldField[n][n2];
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                worldFieldArray[n3][i] = new WorldField(n3, i);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            System.arraycopy(this.fields[n3], 0, worldFieldArray[n3], 0, n4);
        }
        this.fields = worldFieldArray;
        this.sizeX = n;
        this.sizeY = n2;
        this.fireWorldSizeSetEvent(this.sizeX, this.sizeY);
    }

    public final synchronized int getSizeX() {
        return this.sizeX;
    }

    public final synchronized int getSizeY() {
        return this.sizeY;
    }

    public synchronized List<WorldListener> getListeners() {
        return new ArrayList<WorldListener>(this.listeners);
    }

    public final synchronized boolean isNoObjectAt(int n, int n2) {
        this.checkCoordinate(n, n2);
        return this.fields[n][n2].isEmpty();
    }

    public final synchronized boolean isNoObjectAtExcept(WorldObjectInterface worldObjectInterface, int n, int n2) {
        this.checkCoordinate(n, n2);
        return this.fields[n][n2].onlyContainsSameType(worldObjectInterface);
    }

    public final synchronized boolean isObjectOfTypeAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        this.checkCoordinate(n, n2);
        return this.fields[n][n2].containsSameType(worldObjectInterface);
    }

    public final synchronized WorldObjectInterface getObjectOfTypeAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        if (this.isObjectOfTypeAt(worldObjectInterface, n, n2)) {
            return this.fields[n][n2].getObjectByType(worldObjectInterface.getType());
        }
        return null;
    }

    public final synchronized boolean isObjectAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        return this.fields[n][n2].contains(worldObjectInterface);
    }

    public final synchronized int getWorldTime() {
        return this.worldTime;
    }

    public List<WorldField> getObjectFieldsVector() {
        return this.objectFieldsList;
    }

    public WorldField getWorldFieldAt(int n, int n2) {
        return this.fields[n][n2];
    }

    public synchronized void clearAll() {
        int n;
        int n2;
        if (this.objectFieldsList != null) {
            for (n2 = 0; n2 < this.objectFieldsList.size(); ++n2) {
                WorldField worldField = this.objectFieldsList.get(n2);
                WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
                for (n = 0; n < worldObjectInterfaceArray.length; ++n) {
                    if (worldObjectInterfaceArray[n] == null) continue;
                    worldObjectInterfaceArray[n].removedFromWorld();
                }
            }
        }
        this.fields = new WorldField[this.sizeX][this.sizeY];
        for (n2 = 0; n2 < this.sizeX; ++n2) {
            for (n = 0; n < this.sizeY; ++n) {
                this.fields[n2][n] = new WorldField(n2, n);
            }
        }
        this.objectFieldsList = new ArrayList<WorldField>();
        this.fireWorldClearedEvent();
    }

    public synchronized void addWorldListener(WorldListener worldListener) {
        if (!this.listeners.contains(worldListener)) {
            this.listeners.add(worldListener);
            this.listenerArray = new WorldListener[this.listeners.size()];
            this.listeners.toArray(this.listenerArray);
        }
    }

    public synchronized void removeWorldListener(WorldListener worldListener) {
        if (this.listeners.remove(worldListener)) {
            this.listenerArray = new WorldListener[this.listeners.size()];
            this.listeners.toArray(this.listenerArray);
        }
    }

    public synchronized void putObjectAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        worldObjectInterface.setObjectWorld(this);
        worldObjectInterface.setObjectPosition(n, n2);
        this.fields[n][n2].addWorldObject(worldObjectInterface);
        if (this.fields[n][n2].isEmpty()) {
            this.objectFieldsList.remove(this.fields[n][n2]);
            this.fireWorldObjectRemovedEvent(worldObjectInterface, n, n2);
        } else {
            if (!this.objectFieldsList.contains(this.fields[n][n2])) {
                this.objectFieldsList.add(this.fields[n][n2]);
            }
            this.fireWorldObjectAddedEvent(worldObjectInterface, n, n2);
        }
    }

    public synchronized void moveObjectAt(WorldObjectInterface worldObjectInterface, int n, int n2, int n3, int n4) {
        this.checkCoordinate(n, n2);
        this.checkCoordinate(n3, n4);
        if (n != n3 || n2 != n4) {
            this.fields[n][n2].removeWorldObject(worldObjectInterface);
            if (this.fields[n][n2].isEmpty()) {
                this.objectFieldsList.remove(this.fields[n][n2]);
            }
            worldObjectInterface.setObjectPosition(n3, n4);
            this.fields[n3][n4].addWorldObject(worldObjectInterface);
            if (!this.objectFieldsList.contains(this.fields[n3][n4])) {
                this.objectFieldsList.add(this.fields[n3][n4]);
            }
            this.fireWorldObjectMovedEvent(worldObjectInterface, n, n2, n3, n4);
        }
    }

    public synchronized boolean canPutObjectAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        this.checkCoordinate(n, n2);
        return this.fields[n][n2].canAdd(worldObjectInterface);
    }

    public synchronized void removeObjectOfSameTypeAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        WorldObjectInterface worldObjectInterface2 = this.fields[n][n2].getObjectByType(worldObjectInterface.getType());
        this.removeObjectAt(worldObjectInterface2, n, n2);
    }

    public synchronized void removeObjectAt(WorldObjectInterface worldObjectInterface, int n, int n2) {
        this.fields[n][n2].removeWorldObject(worldObjectInterface);
        if (this.fields[n][n2].isEmpty()) {
            this.objectFieldsList.remove(worldObjectInterface);
        }
        worldObjectInterface.removedFromWorld();
        this.fireWorldObjectRemovedEvent(worldObjectInterface, n, n2);
    }

    protected synchronized void fireWorldObjectAddedEvent(WorldObjectInterface worldObjectInterface, int n, int n2) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldObjectAdded(worldObjectInterface, n, n2);
        }
        this.eventFiring = false;
    }

    protected synchronized void fireWorldObjectMovedEvent(WorldObjectInterface worldObjectInterface, int n, int n2, int n3, int n4) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldObjectMoved(worldObjectInterface, n, n2, n3, n4);
        }
        this.eventFiring = false;
    }

    protected synchronized void fireWorldObjectRemovedEvent(WorldObjectInterface worldObjectInterface, int n, int n2) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldObjectRemoved(worldObjectInterface, n, n2);
        }
        this.eventFiring = false;
    }

    protected synchronized void fireWorldChangedEvent(Object object) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldChanged(object);
        }
        this.eventFiring = false;
    }

    protected synchronized void fireWorldClearedEvent() {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldCleared();
        }
        this.eventFiring = false;
    }

    protected synchronized void fireWorldSizeSetEvent(int n, int n2) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldSizeSet(n, n2);
        }
        this.eventFiring = false;
    }

    protected synchronized void fireWorldTimeEvent(boolean bl) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldTimeChanged(this.getWorldTime(), bl);
        }
        this.eventFiring = false;
    }

    public synchronized void fireWorldObjectChangedEvent(WorldObjectInterface worldObjectInterface) {
        if (this.eventFiring) {
            throw new WorldInternalException("language/$language/kawomodel/kararuntimeexception/recursiveevents");
        }
        this.eventFiring = true;
        WorldListener[] worldListenerArray = this.listenerArray;
        for (int i = 0; i < worldListenerArray.length; ++i) {
            worldListenerArray[i].worldObjectChanged(worldObjectInterface);
        }
        this.eventFiring = false;
    }

    public boolean coordinateOk(int n, int n2) {
        return 0 <= n && n < this.sizeX && 0 <= n2 && n2 < this.sizeY;
    }

    public void checkCoordinate(int n, int n2) {
        if (n < 0 || n >= this.sizeX || n2 < 0 || n2 >= this.sizeY) {
            throw new WorldInternalException("language/$language/kawomodel/karaexception/illegalposition", new String[]{"" + n, "" + n2});
        }
    }

    private void removeObjectOutsideWorld(int n, int n2) {
        int n3 = 0;
        while (n3 < this.objectFieldsList.size()) {
            WorldField worldField = this.objectFieldsList.get(n3);
            if (worldField.getX() >= n || worldField.getY() >= n2) {
                WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
                for (int i = 0; i < worldObjectInterfaceArray.length; ++i) {
                    if (worldObjectInterfaceArray[i] == null) continue;
                    worldObjectInterfaceArray[i].removedFromWorld();
                }
                this.objectFieldsList.remove(n3);
                continue;
            }
            ++n3;
        }
    }

    private void cloneObjects(World world) {
        for (int i = 0; i < world.objectFieldsList.size(); ++i) {
            WorldField worldField = world.objectFieldsList.get(i);
            WorldObjectInterface[] worldObjectInterfaceArray = worldField.getStack();
            for (int j = 0; j < worldObjectInterfaceArray.length; ++j) {
                if (worldObjectInterfaceArray[j] == null) continue;
                this.putObjectAt(worldObjectInterfaceArray[j].cloneWorldObject(), worldField.getX(), worldField.getY());
            }
        }
    }

    public boolean worldEqual(World world) {
        int n;
        WorldObjectInterface[] worldObjectInterfaceArray;
        WorldField worldField;
        int n2;
        List<WorldField> list;
        boolean bl = true;
        boolean bl2 = bl = world != null;
        if (bl) {
            boolean bl3 = bl = this.getSizeX() == world.getSizeX() && this.getSizeY() == world.getSizeY();
        }
        if (bl) {
            list = this.getObjectFieldsVector();
            for (n2 = 0; n2 < list.size() && bl; ++n2) {
                worldField = list.get(n2);
                worldObjectInterfaceArray = worldField.getStack();
                for (n = 0; n < worldObjectInterfaceArray.length && bl; ++n) {
                    if (worldObjectInterfaceArray[n] == null) continue;
                    bl = world.isObjectOfTypeAt(worldObjectInterfaceArray[n], worldField.getX(), worldField.getY());
                }
            }
        }
        if (bl) {
            list = world.getObjectFieldsVector();
            for (n2 = 0; n2 < list.size() && bl; ++n2) {
                worldField = list.get(n2);
                worldObjectInterfaceArray = worldField.getStack();
                for (n = 0; n < worldObjectInterfaceArray.length && bl; ++n) {
                    if (worldObjectInterfaceArray[n] == null) continue;
                    bl = this.isObjectOfTypeAt(worldObjectInterfaceArray[n], worldField.getX(), worldField.getY());
                }
            }
        }
        return bl;
    }

    public String toString() {
        int n;
        String string = this.hashCode() + ":\n|";
        for (n = 0; n < this.sizeY; ++n) {
            for (int i = 0; i < this.sizeX; ++i) {
                string = string + this.fields[i][n] + "|";
            }
            string = string + "\n|";
        }
        string = string.substring(0, string.length() - 1);
        for (n = 0; n < this.objectFieldsList.size(); ++n) {
            WorldField worldField = this.objectFieldsList.get(n);
            string = string + "\n" + worldField.getX() + "," + worldField.getY() + ": " + worldField;
        }
        string = string + "\n\n";
        return string;
    }
}

