/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world;

import ch.karatojava.kapps.world.WorldObjectInterface;

public class WorldField {
    protected int xCoord;
    protected int yCoord;
    protected WorldObjectInterface[] worldObjectStack;
    public static final int MAX_TYPE = 16;
    public static final int MAX_LEVEL = 8;
    public static final int EMPTY_ID = 0;
    public static final int TREE_ID = 1;
    public static final int LEAF_ID = 2;
    public static final int MUSHROOM_ID = 4;
    public static final int KARA_ID = 8;
    public static final int FORBIDDEN_ID = 9;
    public static final int MEETINGROOMFIELD_ID = 10;
    public static final int MONITORFIELD_ID = 11;
    public static final int STREET_ID = 16;
    public static final int[] levels;
    protected static boolean[] legalTypes;

    public WorldField(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        this.worldObjectStack = new WorldObjectInterface[8];
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public boolean isEmpty() {
        for (int i = this.worldObjectStack.length - 1; i >= 0; --i) {
            if (this.worldObjectStack[i] == null) continue;
            return false;
        }
        return true;
    }

    public WorldObjectInterface getTop() {
        for (int i = this.worldObjectStack.length - 1; i >= 0; --i) {
            if (this.worldObjectStack[i] == null) continue;
            return this.worldObjectStack[i];
        }
        return null;
    }

    public WorldObjectInterface[] getStack() {
        return this.worldObjectStack;
    }

    public WorldObjectInterface getObjectByType(int n) {
        for (int i = 0; i < this.worldObjectStack.length; ++i) {
            if (this.worldObjectStack[i] == null || this.worldObjectStack[i].getType() != n) continue;
            return this.worldObjectStack[i];
        }
        return null;
    }

    public WorldObjectInterface getObjectByLevel(int n) {
        return this.worldObjectStack[n];
    }

    public boolean contains(WorldObjectInterface worldObjectInterface) {
        for (int i = 0; i < this.worldObjectStack.length; ++i) {
            if (!worldObjectInterface.equals(this.worldObjectStack[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsSameType(WorldObjectInterface worldObjectInterface) {
        for (int i = 0; i < this.worldObjectStack.length; ++i) {
            if (this.worldObjectStack[i] == null || this.worldObjectStack[i].getType() != worldObjectInterface.getType()) continue;
            return true;
        }
        return false;
    }

    public boolean onlyContainsSameType(WorldObjectInterface worldObjectInterface) {
        if (this.containsSameType(worldObjectInterface)) {
            for (int i = 0; i < this.worldObjectStack.length; ++i) {
                if (this.worldObjectStack[i] == null || this.worldObjectStack[i].getType() == worldObjectInterface.getType()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canAdd(WorldObjectInterface worldObjectInterface) {
        for (int i = 0; i < this.worldObjectStack.length; ++i) {
            if (this.worldObjectStack[i] == null || this.worldObjectStack[i].canCombineWith(worldObjectInterface) && worldObjectInterface.canCombineWith(this.worldObjectStack[i])) continue;
            return false;
        }
        return true;
    }

    public void addWorldObject(WorldObjectInterface worldObjectInterface) {
        WorldObjectInterface worldObjectInterface2 = this.worldObjectStack[worldObjectInterface.getLevel()];
        this.worldObjectStack[worldObjectInterface.getLevel()] = worldObjectInterface2 != null ? worldObjectInterface2.mergeWith(worldObjectInterface) : worldObjectInterface;
    }

    public void removeWorldObject(WorldObjectInterface worldObjectInterface) {
        this.worldObjectStack[worldObjectInterface.getLevel()] = this.worldObjectStack[worldObjectInterface.getLevel()].equals(worldObjectInterface) ? null : this.worldObjectStack[worldObjectInterface.getLevel()].detach(worldObjectInterface);
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.worldObjectStack.length; ++i) {
            if (this.worldObjectStack[i] == null) continue;
            string = string + this.worldObjectStack[i];
        }
        return string;
    }

    static {
        legalTypes = new boolean[17];
        WorldField.legalTypes[0] = true;
        WorldField.legalTypes[1] = true;
        WorldField.legalTypes[2] = true;
        WorldField.legalTypes[4] = true;
        WorldField.legalTypes[8] = true;
        WorldField.legalTypes[16] = true;
        WorldField.legalTypes[9] = true;
        WorldField.legalTypes[10] = true;
        WorldField.legalTypes[11] = true;
        levels = new int[17];
        WorldField.levels[0] = -1;
        WorldField.levels[1] = 6;
        WorldField.levels[2] = 4;
        WorldField.levels[3] = -1;
        WorldField.levels[4] = 5;
        WorldField.levels[5] = -1;
        WorldField.levels[6] = -1;
        WorldField.levels[7] = -1;
        WorldField.levels[8] = 7;
        WorldField.levels[9] = 0;
        WorldField.levels[10] = 1;
        WorldField.levels[11] = 2;
        WorldField.levels[12] = -1;
        WorldField.levels[13] = -1;
        WorldField.levels[14] = -1;
        WorldField.levels[15] = -1;
        WorldField.levels[16] = 3;
    }
}

