/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.editor.AbstractEditor;
import ch.karatojava.kapps.world.World;
import ch.karatojava.kapps.world.WorldListener;
import ch.karatojava.kapps.world.editor.WorldEditorWorldListener;
import ch.karatojava.kapps.world.editor.WorldView;
import ch.karatojava.kapps.world.editor.io.WorldBuilderInterface;
import ch.karatojava.kapps.world.editor.io.WorldOutputterInterface;
import ch.karatojava.util.Configuration;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.border.TitledBorder;

public class WorldEditor
extends AbstractEditor {
    protected WorldView worldView;
    protected TitledBorder border;
    protected World world;
    protected boolean modified;
    protected WorldBuilderInterface worldBuilder;
    protected WorldOutputterInterface worldOutputter;
    protected WorldListener worldListener = new WorldEditorWorldListener(this);

    public WorldEditor(WorldBuilderInterface worldBuilderInterface, WorldOutputterInterface worldOutputterInterface) {
        this.world = this.createWorld();
        this.worldView = this.createWorldView(this.world);
        this.setWorld(this.world);
        this.worldBuilder = worldBuilderInterface;
        this.worldOutputter = worldOutputterInterface;
    }

    public void setModified() {
        this.modified = true;
        this.listenerSupport.fireModifiedContent();
    }

    public void setWorld(World world) {
        if (this.world != null) {
            for (int i = 0; i < this.world.getListeners().size(); ++i) {
                world.addWorldListener(this.world.getListeners().get(i));
            }
        }
        this.world = world;
        if (!this.world.getListeners().contains(this.worldListener)) {
            this.world.addWorldListener(this.worldListener);
        }
        this.worldView.setWorld(world);
    }

    public World getWorld() {
        return this.world;
    }

    public final WorldView getWorldView() {
        return this.worldView;
    }

    @Override
    public Object getContent() {
        return this.world;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public Object create(InputStream inputStream) throws Exception {
        return this.worldBuilder.buildWorld(inputStream);
    }

    @Override
    protected void doSave(OutputStream outputStream) throws Exception {
        this.worldOutputter.outputWorld(this.world, outputStream);
    }

    @Override
    protected void doSetContent(Object object) {
        this.setWorld((World)object);
    }

    @Override
    protected void doNewFile() {
        this.setWorld(this.createWorld());
        this.worldView.setZoomFactor(1.0);
    }

    @Override
    protected void resetModified() {
        this.modified = false;
    }

    protected World createWorld() {
        return new World(Configuration.getInstance().getInt("worldeditor/defaultsizex"), Configuration.getInstance().getInt("worldeditor/defaultsizey"));
    }

    protected WorldView createWorldView(World world) {
        return new WorldView(world);
    }
}

