/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.kapps.world.editor.WorldView;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.JDirShareFileChooser;
import ch.karatojava.util.gui.ImageOutputter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public class WorldExportWindow {
    private WorldEditor worldEditor;
    private static JDirShareFileChooser chooser;
    private static ActionListener chooserListener;
    private static JSlider qualitySlider;
    private JDialog dialog;
    private JRadioButton[] radioButtons = new JRadioButton[2];

    public WorldExportWindow(WorldEditor worldEditor) {
        this.worldEditor = worldEditor;
        this.createGui();
        GuiFactory.getInstance().addUiSwitchListener(this.dialog);
    }

    public void showExportDialog() {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(JOptionPane.getFrameForComponent(this.worldEditor.getWorldView()));
        this.dialog.setVisible(true);
        chooser.shareCurrentDirectory();
    }

    private void export() {
        File file;
        String string = chooser.getSelectedFile().getAbsolutePath();
        if (!string.endsWith(".jpg")) {
            string = string + ".jpg";
        }
        if ((file = new File(string)).exists() && WorldExportWindow.askOverwrite(string) != 0) {
            return;
        }
        WorldView worldView = new WorldView(this.worldEditor.getWorld());
        if (this.radioButtons[0].isSelected()) {
            worldView.setSize(this.worldEditor.getWorld().getSizeX() * 28 + 10, this.worldEditor.getWorld().getSizeY() * 28 + 10);
            worldView.setZoomFactor(1.0);
        } else {
            worldView.setSize(this.worldEditor.getWorldView().getSize());
            worldView.setDistances(this.worldEditor.getWorldView().getDistances());
            worldView.setZoomFactor(this.worldEditor.getWorldView().getZoomFactor());
        }
        worldView.setBackground(this.worldEditor.getWorldView().getBackground());
        float f = ((float)qualitySlider.getValue() + 1.0f) / 5.0f;
        try {
            ImageOutputter.generateJPEG(worldView.getExportImage(), file, f);
        }
        catch (Error error) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.worldEditor.getWorldView()), "The world you are trying to export is too big!\nPlease reduce the size of the world\nor export the visible part only.", "Error trying to export world", 0);
        }
        this.dialog.setVisible(false);
    }

    private void createGui() {
        this.dialog = new JDialog(JOptionPane.getFrameForComponent(this.worldEditor.getWorldView()), "Export as JPEG", true);
        this.dialog.getContentPane().setLayout(new BoxLayout(this.dialog.getContentPane(), 1));
        this.dialog.getContentPane().add(this.getFileChooserPanel());
        this.dialog.getContentPane().add(this.getSouthPanel());
    }

    private JComponent getFileChooserPanel() {
        chooserListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    WorldExportWindow.this.export();
                } else if (actionEvent.getActionCommand().equals("CancelSelection")) {
                    WorldExportWindow.this.dialog.setVisible(false);
                }
            }
        };
        chooser = KaraGuiFactory.getInstance().getImageExportFileChooser();
        chooser.addActionListener(chooserListener);
        chooser.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/filetitle"));
        return chooser;
    }

    private JPanel getSouthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.getOptionPanel());
        jPanel.add(this.getQualityPanel());
        return jPanel;
    }

    private JPanel getOptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/optiontitle"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        this.radioButtons[0] = new JRadioButton(Configuration.getInstance().getString("language/$language/worldeditor/export/world"), true);
        this.radioButtons[1] = new JRadioButton(Configuration.getInstance().getString("language/$language/worldeditor/export/visible"), false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtons[0]);
        buttonGroup.add(this.radioButtons[1]);
        jPanel.add(this.radioButtons[0]);
        jPanel.add(this.radioButtons[1]);
        return jPanel;
    }

    private JPanel getQualityPanel() {
        qualitySlider = new JSlider(0, 4, 4);
        qualitySlider.setMajorTickSpacing(1);
        qualitySlider.setPaintTicks(true);
        qualitySlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), GuiFactory.getInstance().createLabel("language/$language/actorfsm/editor/export/qualitymin"));
        hashtable.put(new Integer(100), GuiFactory.getInstance().createLabel("language/$language/actorfsm/editor/export/qualitymax"));
        qualitySlider.setLabelTable(hashtable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(GuiFactory.getInstance().createTitledBorder("language/$language/actorfsm/editor/export/qualitytitle"));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(qualitySlider);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private static int askOverwrite(String string) {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(chooser), "There exists a file with the name \n" + string + ".\n" + "Do want to overwrite the existing file?", "Overwrite?", 1);
    }
}

