/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.kapps.world.editor;

import ch.karatojava.kapps.KaraGuiFactory;
import ch.karatojava.kapps.world.WorldInternalException;
import ch.karatojava.kapps.world.editor.WorldEditor;
import ch.karatojava.util.Configuration;
import ch.karatojava.util.ExceptionActionListener;
import ch.karatojava.util.GuiFactory;
import ch.karatojava.util.gui.DialogKeyAdapter;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WorldSizeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int returnValue;
    private int sizeXValue;
    private int sizeYValue;
    private JTextField sizeX;
    private JTextField sizeY;
    private WorldEditor worldEditor;

    public WorldSizeDialog(WorldEditor worldEditor) {
        super(KaraGuiFactory.getInstance().getApplicationFrame(), Configuration.getInstance().getString("language/$language/worldeditor/worldsizedialog/title"), true);
        GuiFactory.getInstance().addUiSwitchListener(this);
        this.worldEditor = worldEditor;
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Configuration.getInstance().getString("language/$language/worldeditor/worldsizedialog/sizexlabel"));
        this.sizeX = new JTextField(3);
        JLabel jLabel2 = new JLabel(Configuration.getInstance().getString("language/$language/worldeditor/worldsizedialog/sizeylabel"));
        this.sizeY = new JTextField(3);
        JPanel jPanel2 = new JPanel();
        JButton jButton = GuiFactory.getInstance().createImageIconButton("icons/ok");
        JButton jButton2 = GuiFactory.getInstance().createImageIconButton("icons/cancel");
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(this.sizeX);
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(jLabel2);
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(this.sizeY);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        this.getRootPane().setDefaultButton(jButton);
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(15));
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalGlue());
        container.setLayout(new BoxLayout(container, 1));
        container.add(Box.createVerticalStrut(30));
        container.add(jPanel);
        container.add(Box.createVerticalStrut(10));
        container.add(jPanel2);
        container.add(Box.createVerticalStrut(10));
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WorldSizeDialog.this.returnValue = 2;
                WorldSizeDialog.this.setVisible(false);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        jButton.addActionListener(new ExceptionActionListener(){

            @Override
            public void action(ActionEvent actionEvent) throws Exception {
                WorldSizeDialog.this.setSizeXY();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorldSizeDialog.this.returnValue = 2;
                WorldSizeDialog.this.setVisible(false);
            }
        });
        DialogKeyAdapter dialogKeyAdapter = new DialogKeyAdapter(jButton, jButton2);
        this.addKeyListener(dialogKeyAdapter);
        this.sizeX.addKeyListener(dialogKeyAdapter);
        this.sizeY.addKeyListener(dialogKeyAdapter);
    }

    private void throwException() throws Exception {
        this.sizeX.requestFocus();
        throw new WorldInternalException("language/$language/worldeditor/worldsizedialog/errmsg", new String[]{"1", "1000"});
    }

    private void setSizeXY() throws Exception {
        try {
            int n = Integer.parseInt(this.sizeX.getText());
            int n2 = Integer.parseInt(this.sizeY.getText());
            if (1 <= n && n <= 1000 && 1 <= n2 && n2 <= 1000) {
                this.sizeXValue = n;
                this.sizeYValue = n2;
                this.returnValue = 0;
                this.setVisible(false);
            } else {
                this.throwException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            Frame frame = JOptionPane.getFrameForComponent(this.worldEditor.getWorldView());
            this.setLocationRelativeTo(frame);
            this.sizeX.setText(Integer.toString(this.worldEditor.getWorld().getSizeX()));
            this.sizeY.setText(Integer.toString(this.worldEditor.getWorld().getSizeY()));
            this.sizeX.requestFocus();
        }
        super.setVisible(bl);
    }

    public int getWorldSizeX() {
        return this.sizeXValue;
    }

    public int getWorldSizeY() {
        return this.sizeYValue;
    }

    public int getReturnValue() {
        return this.returnValue;
    }
}

