/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util;

import ch.karatojava.util.ResourceAccessFactory;
import ch.karatojava.util.ResourceAccessInterface;
import ch.karatojava.util.WeakRefPropertyChangeSupport;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class Configuration {
    public static final String IMAGE_DIRECTORY = "/kappsresources/icons/";
    public static final String PATH_SEPERATOR = "/";
    public static final String LIST_SEPERATOR = ",";
    public static final String VARIABLE_PREFIX = "$";
    public static final String CONFIGURABLES = "configurables";
    public static final String METADATA = "metadata";
    public static final String POSSIBLE_VALUES = "possiblevalues";
    public static final String DEFAULT_VALUE = "defaultvalue";
    private static Configuration instance;
    private Hashtable<String, String> currentValues;
    private Hashtable<String, List<String>> possibleValues;
    private List<String> configurables;
    private List<String> variables;
    private String imageDirectory;
    private ResourceAccessInterface resources;
    private WeakRefPropertyChangeSupport changeSupport;
    private WeakRefPropertyChangeSupport topLevelChangeSupport;

    private Configuration(ResourceAccessInterface resourceAccessInterface, String string) {
        assert (resourceAccessInterface != null) : "Configuration.constructor: resources == null";
        assert (string != null) : "Configuration.constructor: imageDirectory == null";
        this.resources = resourceAccessInterface;
        this.imageDirectory = string;
        this.changeSupport = new WeakRefPropertyChangeSupport(this);
        this.topLevelChangeSupport = new WeakRefPropertyChangeSupport(this);
        this.possibleValues = new Hashtable();
        this.currentValues = new Hashtable();
        this.configurables = Configuration.split(resourceAccessInterface.getString(CONFIGURABLES), LIST_SEPERATOR);
        assert (this.configurables.size() > 0) : "Configuration.constructor: configurables.size() == 0)";
        this.variables = new ArrayList<String>();
        for (int i = 0; i < this.configurables.size(); ++i) {
            String string2 = this.configurables.get(i);
            assert (!"".equals(string2)) : "Configuration.constructor: \"\".equals(configurable)";
            this.variables.add(VARIABLE_PREFIX + string2);
            List<String> list = Configuration.split(resourceAccessInterface.getString("metadata/" + string2 + PATH_SEPERATOR + POSSIBLE_VALUES), LIST_SEPERATOR);
            assert (list.size() > 0) : "Configuration.constructor: values.size() == 0)";
            this.possibleValues.put(string2, list);
            this.currentValues.put(string2, resourceAccessInterface.getString("metadata/" + string2 + PATH_SEPERATOR + DEFAULT_VALUE));
        }
    }

    public void setCurrentValue(String string, String string2) {
        assert (string2 != null) : "Configuration.setCurrentValue: value == null";
        List<String> list = this.possibleValues.get(string);
        assert (this.configurables.contains(string) && list.contains(string2)) : "Configuration.setCurrentValue: value == " + string2 + " is not a possible value for configurable == " + string;
        String string3 = this.currentValues.get(string);
        this.currentValues.put(string, string2);
        this.firePropertyChange(string, string3, string2);
    }

    public List<String> getConfigurables() {
        return new ArrayList<String>(this.configurables);
    }

    public List getPossibleValues(String string) {
        return this.possibleValues.get(string);
    }

    public final String getCurrentValue(String string) {
        return this.currentValues.get(string);
    }

    public String getString(String string) {
        return this.resources.getString(this.getKey(string));
    }

    public Image getImage(String string) {
        return this.getImageIcon(string).getImage();
    }

    public ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(this.resources.getResource(this.imageDirectory + this.getString(string)));
        }
        catch (Exception exception) {
            System.out.println("path not found: " + string);
        }
        if (imageIcon == null) {
            System.out.println("image not found: " + string);
        }
        return imageIcon;
    }

    public String getFormatString(String string, String[] stringArray) {
        return MessageFormat.format(this.resources.getString(this.getKey(string)), stringArray);
    }

    public int getInt(String string) {
        return Integer.parseInt(this.resources.getString(this.getKey(string)));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        if (bl) {
            this.topLevelChangeSupport.addPropertyChangeListener(propertyChangeListener);
        } else {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener, boolean bl) {
        assert (this.configurables.contains(string)) : "Configuration.addPropertyChangeListener: invalid configurable " + string;
        if (bl) {
            this.topLevelChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
        } else {
            this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public void addPropertyChangeListeners(String string, PropertyChangeListener propertyChangeListener, boolean bl) {
        List<String> list = Configuration.split(string, PATH_SEPERATOR);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (this.variables.contains(string2)) {
                this.addPropertyChangeListener(string2.substring(1, string2.length()), propertyChangeListener, bl);
                continue;
            }
            if (string2.charAt(0) == '$') assert (false) : "Configuration.addPropertyChangeListeners: no variable " + string2;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        if (bl) {
            this.topLevelChangeSupport.removePropertyChangeListener(propertyChangeListener);
        } else {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener, boolean bl) {
        if (bl) {
            this.topLevelChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
        } else {
            this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    private void firePropertyChange(String string, String string2, String string3) {
        this.changeSupport.firePropertyChange(string, string2, string3);
        this.topLevelChangeSupport.firePropertyChange(string, string2, string3);
    }

    private String getKey(String string) {
        List<String> list = Configuration.split(string, PATH_SEPERATOR);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : list) {
            if (this.variables.contains(string2)) {
                string2 = this.currentValues.get(string2.substring(1));
            }
            stringBuffer.append(string2);
            stringBuffer.append(PATH_SEPERATOR);
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public static Configuration getInstance() {
        assert (instance != null) : "Configuration.getInstace: instance == null";
        return instance;
    }

    public static void createInstance() {
        instance = new Configuration(ResourceAccessFactory.getResourceAccessImpl(), IMAGE_DIRECTORY);
    }

    public static void createInstance(String string) {
        if (instance == null) {
            instance = new Configuration(ResourceAccessFactory.getResourceAccessImpl(), string);
        }
    }

    public static List<String> split(String string, String string2) {
        assert (string != null) : "Configuration.split: s == null";
        assert (string2 != null) : "Configuration.split: seperators == null";
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(((String)stringTokenizer.nextElement()).trim());
        }
        return arrayList;
    }
}

