/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui;

import ch.karatojava.editor.ExampleFileFilter;
import ch.karatojava.util.GuiFactory;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class ImageOutputter {
    private static JFileChooser chooser;
    private static JSlider qualitySlider;

    private static void createGui() {
        chooser = new JFileChooser();
        chooser.setFileFilter(new ExampleFileFilter("jpg"));
        chooser.setMultiSelectionEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(new JLabel("Qualit\u00e4t:"));
        jPanel.add(Box.createHorizontalStrut(20));
        qualitySlider = new JSlider(0, 100, 100);
        qualitySlider.setMajorTickSpacing(20);
        qualitySlider.setMinorTickSpacing(10);
        qualitySlider.setPaintTicks(true);
        qualitySlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(2);
        hashtable.put(new Integer(0), new JLabel("gering"));
        hashtable.put(new Integer(100), new JLabel("hoch"));
        qualitySlider.setLabelTable(hashtable);
        jPanel.add(qualitySlider);
        jPanel.add(Box.createHorizontalStrut(10));
        chooser.add(jPanel);
        GuiFactory.getInstance().addUiSwitchListener(chooser);
    }

    private static int askOverwrite(String string) {
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(chooser), "There exists a file with the name \n" + string + ".\n" + "Do want to overwrite the existing file?", "Overwrite?", 1);
    }

    public static void generateJPEG(BufferedImage bufferedImage, File file, float f) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println("caught");
            exception.printStackTrace();
        }
        catch (Error error) {
            System.out.println("caught error");
        }
    }

    public static void generateJPEG(BufferedImage bufferedImage, Component component) {
        if (chooser == null) {
            ImageOutputter.createGui();
        }
        if (chooser.showSaveDialog(JOptionPane.getFrameForComponent(component)) == 0) {
            File file;
            String string = chooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".jpg")) {
                string = string + ".jpg";
            }
            if ((file = new File(string)).exists() && ImageOutputter.askOverwrite(string) != 0) {
                return;
            }
            float f = (float)qualitySlider.getValue() / 100.0f;
            ImageOutputter.generateJPEG(bufferedImage, file, f);
        }
    }
}

