/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class JGridPanel
extends JPanel {
    private static final long serialVersionUID = 3L;
    protected int rowOrColumnLength;
    protected int items;
    protected int maxItems;
    protected boolean rows;
    protected JPanel[] panels;

    public JGridPanel(boolean bl, int n, int n2) {
        this.rowOrColumnLength = n;
        this.rows = bl;
        this.maxItems = n2;
        this.items = 0;
        if (bl) {
            this.setLayout(new BoxLayout(this, 1));
        } else {
            this.setLayout(new BoxLayout(this, 0));
        }
        if (n2 > 0) {
            this.panels = new JPanel[this.rowsOrColumns()];
            for (int i = 0; i < this.panels.length; ++i) {
                this.panels[i] = new JPanel();
                if (bl) {
                    this.panels[i].setLayout(new BoxLayout(this.panels[i], 0));
                } else {
                    this.panels[i].setLayout(new BoxLayout(this.panels[i], 1));
                }
                this.add((Component)this.panels[i], i);
            }
        }
    }

    @Override
    public Component add(Component component) {
        int n;
        assert (this.items < this.maxItems) : "JGridPanel.add: items >= maxItems";
        this.panels[this.rowOrColumnIndex(this.items)].add(component);
        ++this.items;
        if (this.items == this.maxItems && this.maxItems % this.rowOrColumnLength > 0 && (n = this.maxPanelPreferredWidth() - this.panels[this.panels.length - 1].getPreferredSize().width) > 0) {
            if (this.rows) {
                this.panels[this.rowOrColumnIndex(this.items)].add(Box.createRigidArea(new Dimension(n, 0)));
            } else {
                this.panels[this.rowOrColumnIndex(this.items)].add(Box.createRigidArea(new Dimension(0, n)));
            }
        }
        return component;
    }

    private int maxPanelPreferredWidth() {
        int n = 0;
        for (int i = 0; i < this.panels.length; ++i) {
            n = Math.max(n, this.panels[i].getPreferredSize().width);
        }
        return n;
    }

    private int rowsOrColumns() {
        return 1 + this.maxItems / this.rowOrColumnLength;
    }

    private int rowOrColumnIndex(int n) {
        return n / this.rowOrColumnLength;
    }
}

