/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public abstract class ZoomableJComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected int status = 30;
    protected double maxScale = 5.0;
    protected double minScale = 0.08;
    protected double zoom = 1.0;
    protected static final int JUST_LOOKING = 30;
    protected static final int ZOOM = 1;
    protected static final int TRANS = 2;
    protected Point dragOrigin = new Point(-1, -1);
    protected int offsetX;
    protected int offsetY;
    protected int distX = 0;
    protected int distY = 0;
    protected Point eventStart;
    protected double dScaleDist = 150.0;
    protected MouseInputListener moveNzoomHandler = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 8) > 0 || (n & 0x10) > 0 && (n & 8) > 0) {
                ZoomableJComponent.this.status = 1;
                ZoomableJComponent.this.setCursor(8);
                ZoomableJComponent.this.eventStart = mouseEvent.getPoint();
            } else if ((n & 0x10) > 0) {
                ZoomableJComponent.this.status = 2;
                if (ZoomableJComponent.this.allowMove()) {
                    ZoomableJComponent.this.setCursor(13);
                }
                ZoomableJComponent.this.eventStart = mouseEvent.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (ZoomableJComponent.this.status == 1) {
                ZoomableJComponent.this.changeZoom(mouseEvent.getY());
            } else if (ZoomableJComponent.this.status == 2) {
                ZoomableJComponent.this.changeVisiblePart(mouseEvent.getPoint());
            }
            ZoomableJComponent.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ZoomableJComponent.this.status = 30;
            ZoomableJComponent.this.setNormalCursor();
        }
    };
    protected ComponentListener compListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ZoomableJComponent.this.calculateOffsets();
            ZoomableJComponent.this.repaint();
        }
    };

    public ZoomableJComponent() {
        this.addMouseListener(this.moveNzoomHandler);
        this.addMouseMotionListener(this.moveNzoomHandler);
        this.addComponentListener(this.compListener);
    }

    public void setZoomFactor(double d) {
        if (d < this.minScale) {
            d = this.minScale;
        } else if (d > this.maxScale) {
            d = this.maxScale;
        }
        this.zoom = d;
        this.calculateOffsets();
        this.repaint();
    }

    protected abstract int getTotalWidth();

    protected abstract int getTotalHeight();

    public void setZoomFitSize() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            double d;
            double d2 = (double)this.getWidth() / (double)this.getTotalWidth();
            if (d2 < (d = (double)this.getHeight() / (double)this.getTotalHeight())) {
                this.setZoomFactor(d2);
            } else {
                this.setZoomFactor(d);
            }
        }
    }

    public double getZoomFactor() {
        return this.zoom;
    }

    protected void calculateOffsets() {
        this.offsetX = (this.getWidth() - this.getTotalWidth()) / 2 + this.distX;
        this.offsetY = (this.getHeight() - this.getTotalHeight()) / 2 + this.distY;
    }

    protected boolean allowMove() {
        return this.getTotalWidth() > this.getWidth() || this.getTotalHeight() > this.getHeight();
    }

    protected void checkDistances() {
        if (this.getTotalWidth() > this.getWidth()) {
            if (this.distX > 5 - (this.getWidth() - this.getTotalWidth()) / 2) {
                this.distX = 5 - (this.getWidth() - this.getTotalWidth()) / 2;
            }
            if (this.distX < (this.getWidth() - this.getTotalWidth()) / 2 - 5) {
                this.distX = (this.getWidth() - this.getTotalWidth()) / 2 - 5;
            }
        } else {
            this.distX = 0;
        }
        if (this.getTotalHeight() > this.getHeight()) {
            if (this.distY > 5 - (this.getHeight() - this.getTotalHeight()) / 2) {
                this.distY = 5 - (this.getHeight() - this.getTotalHeight()) / 2;
            }
            if (this.distY < (this.getHeight() - this.getTotalHeight()) / 2 - 5) {
                this.distY = (this.getHeight() - this.getTotalHeight()) / 2 - 5;
            }
        } else {
            this.distY = 0;
        }
    }

    protected void changeZoom(int n) {
        double d = this.zoom + 2.0 * ((double)n - (double)this.eventStart.y) / this.dScaleDist;
        this.eventStart.y = n;
        this.setZoomFactor(d);
    }

    protected void changeVisiblePart(Point point) {
        this.distX = this.distX - this.eventStart.x + point.x;
        this.distY = this.distY - this.eventStart.y + point.y;
        this.checkDistances();
        this.calculateOffsets();
        this.eventStart = point;
    }

    protected void setNormalCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }
}

