/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.dndpanel;

import ch.karatojava.util.gui.dndpanel.LightweightDragDrop;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DndPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final BasicStroke DND_LINE_STROKE = new BasicStroke(2.0f, 1, 2);
    private static final AlphaComposite DND_LINE_ALPHA = AlphaComposite.getInstance(3, 0.4f);
    private static final AlphaComposite DND_IMAGE_ALPHA = AlphaComposite.getInstance(3, 0.4f);
    private static final Color DND_SUPPORTED = new Color(0, 255, 0, 125);
    private static final Color DND_NOT_SUPPORTED = new Color(255, 0, 0, 125);
    private static final boolean ANTIALIASING = true;
    private static final boolean PAINT_DRAG_IMAGE = true;
    private static final boolean PAINT_DRAG_LINE = true;
    private static final int MIN_DRAG_DISTANCE = 9;
    private Point pointSrc;
    private Component dndSource;
    private LightweightDragDrop lwdndSource;
    private int dndSourceX;
    private int dndSourceY;
    private int mousePressedX;
    private int mousePressedY;
    private boolean dragging;
    private Point pointDst;
    private Line2D dndLine = new Line2D.Float();
    private Color colorDND;
    private Object dndObject;
    private BufferedImage dndDragImage;
    private int dndDragImageWidth;
    private int dndDragImageHeight;
    private boolean dragAborted;
    private MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (DndPanel.this.dndSource != null) {
                int n;
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                if (!DndPanel.this.dragging && (n = (DndPanel.this.mousePressedX - n2) * (DndPanel.this.mousePressedX - n2) + (DndPanel.this.mousePressedY - n3) * (DndPanel.this.mousePressedY - n3)) >= 9) {
                    DndPanel.this.dragging = true;
                }
                if (DndPanel.this.dragging) {
                    ((DndPanel)DndPanel.this).pointDst.x = DndPanel.this.dndSourceX + n2;
                    ((DndPanel)DndPanel.this).pointDst.y = DndPanel.this.dndSourceY + n3;
                    DndPanel.this.colorDND = DND_NOT_SUPPORTED;
                    if (!DndPanel.this.dragAborted) {
                        Component component = DndPanel.this.findComponentAt(DndPanel.this.dndSourceX + n2, DndPanel.this.dndSourceY + n3);
                        if ((component = DndPanel.this.findDragDropComponent(component)) != null) {
                            int n4 = component.getLocationOnScreen().x - DndPanel.this.getLocationOnScreen().x;
                            int n5 = component.getLocationOnScreen().y - DndPanel.this.getLocationOnScreen().y;
                            MouseEvent mouseEvent2 = new MouseEvent(DndPanel.this.dndSource, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), DndPanel.this.dndSourceX + n2 - n4, DndPanel.this.dndSourceY + n3 - n5, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            if (((LightweightDragDrop)((Object)component)).acceptsDrop(mouseEvent2, DndPanel.this.dndObject)) {
                                DndPanel.this.colorDND = DND_SUPPORTED;
                            }
                        }
                    }
                    DndPanel.this.repaint();
                }
            }
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component;
            DndPanel.this.dragAborted = false;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (component = DndPanel.this.findDragDropComponent((Component)mouseEvent.getSource())) != null) {
                DndPanel.this.mousePressedX = mouseEvent.getX();
                DndPanel.this.mousePressedY = mouseEvent.getY();
                DndPanel.this.dndSourceX = component.getLocationOnScreen().x - DndPanel.this.getLocationOnScreen().x;
                DndPanel.this.dndSourceY = component.getLocationOnScreen().y - DndPanel.this.getLocationOnScreen().y;
                LightweightDragDrop lightweightDragDrop = (LightweightDragDrop)((Object)component);
                DndPanel.this.dndObject = lightweightDragDrop.acceptsDrag(mouseEvent);
                if (DndPanel.this.dndObject != null) {
                    DndPanel.this.pointSrc = new Point(DndPanel.this.dndSourceX + DndPanel.this.mousePressedX, DndPanel.this.dndSourceY + DndPanel.this.mousePressedY);
                    DndPanel.this.pointDst = new Point(DndPanel.this.dndSourceX + DndPanel.this.mousePressedX, DndPanel.this.dndSourceY + DndPanel.this.mousePressedY);
                    DndPanel.this.dndSource = (Component)mouseEvent.getSource();
                    DndPanel.this.lwdndSource = lightweightDragDrop;
                    DndPanel.this.dndDragImage = lightweightDragDrop.getDragImage(DndPanel.this.dndObject);
                    DndPanel.this.dndDragImageWidth = DndPanel.this.dndDragImage.getWidth();
                    DndPanel.this.dndDragImageHeight = DndPanel.this.dndDragImage.getHeight();
                    DndPanel.this.colorDND = DND_SUPPORTED;
                    DndPanel.this.dragAborted = false;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (DndPanel.this.dndSource != null) {
                boolean bl = false;
                if (!DndPanel.this.dragAborted && DndPanel.this.dragging) {
                    ((DndPanel)DndPanel.this).pointDst.x = DndPanel.this.dndSourceX + mouseEvent.getX();
                    ((DndPanel)DndPanel.this).pointDst.y = DndPanel.this.dndSourceY + mouseEvent.getY();
                    Component component = DndPanel.this.findComponentAt(DndPanel.this.dndSourceX + mouseEvent.getX(), DndPanel.this.dndSourceY + mouseEvent.getY());
                    if ((component = DndPanel.this.findDragDropComponent(component)) != null) {
                        int n = component.getLocationOnScreen().x - DndPanel.this.getLocationOnScreen().x;
                        int n2 = component.getLocationOnScreen().y - DndPanel.this.getLocationOnScreen().y;
                        MouseEvent mouseEvent2 = new MouseEvent(DndPanel.this.dndSource, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), ((DndPanel)DndPanel.this).pointDst.x - n, ((DndPanel)DndPanel.this).pointDst.y - n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        if (((LightweightDragDrop)((Object)component)).acceptsDrop(mouseEvent2, DndPanel.this.dndObject)) {
                            ((LightweightDragDrop)((Object)component)).dropTransferObject(mouseEvent2, DndPanel.this.dndObject);
                            bl = true;
                        }
                    }
                }
                DndPanel.this.lwdndSource.draggingFinished(mouseEvent, DndPanel.this.dndObject, bl);
                DndPanel.this.lwdndSource = null;
                DndPanel.this.pointSrc = null;
                DndPanel.this.pointDst = null;
                DndPanel.this.dndSource = null;
                DndPanel.this.dndObject = null;
                DndPanel.this.dndDragImage = null;
                DndPanel.this.dragging = false;
                DndPanel.this.repaint();
            }
        }
    };

    private Component findDragDropComponent(Component component) {
        while (component != null && !(component instanceof LightweightDragDrop) && !(component instanceof DndPanel)) {
            component = component.getParent();
        }
        if (component instanceof LightweightDragDrop) {
            return component;
        }
        return null;
    }

    public void abortDragging() {
        this.colorDND = DND_NOT_SUPPORTED;
        this.dragAborted = true;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintDragLine((Graphics2D)graphics);
        this.paintDragImage((Graphics2D)graphics);
    }

    public void addThisMouseInputListener(Component component) {
        component.addMouseListener(this.mouseListener);
        component.addMouseMotionListener(this.mouseMotionListener);
    }

    public void addThisMouseInputListenerToChildren() {
        this.initializeDndPanel(this);
    }

    public void addThisMouseInputListenerToChildren(Container container) {
        this.initializeDndPanel(container);
    }

    private void initializeDndPanel(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof LightweightDragDrop) {
                this.addThisMouseInputListener(componentArray[i]);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            this.initializeDndPanel((Container)componentArray[i]);
        }
    }

    public static DndPanel findDndPanel(Component component) {
        while (component != null && !(component instanceof DndPanel)) {
            component = component.getParent();
        }
        return (DndPanel)component;
    }

    public static BufferedImage createBufferedImage(JComponent jComponent) {
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setClip(0, 0, n, n2);
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void removeThisMouseInputListener(Component component) {
        component.removeMouseListener(this.mouseListener);
        component.removeMouseMotionListener(this.mouseMotionListener);
        this.dndSource = null;
    }

    private void paintDragImage(Graphics2D graphics2D) {
        if (this.dragging) {
            graphics2D.setComposite(DND_IMAGE_ALPHA);
            graphics2D.drawImage((Image)this.dndDragImage, this.pointDst.x - this.dndDragImageWidth / 2, this.pointDst.y - this.dndDragImageHeight / 2, null);
            this.paintDragLine(graphics2D);
        }
    }

    private void paintDragLine(Graphics2D graphics2D) {
        if (this.dragging) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.dndLine.setLine(this.pointSrc.getX(), this.pointSrc.getY(), this.pointDst.getX(), this.pointDst.getY());
            graphics2D.setPaintMode();
            graphics2D.setStroke(DND_LINE_STROKE);
            graphics2D.setPaint(this.colorDND);
            graphics2D.setComposite(DND_LINE_ALPHA);
            graphics2D.draw(this.dndLine);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }
}

