/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.jedit;

import ch.karatojava.util.gui.jedit.InputHandler;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public class DefaultInputHandler
extends InputHandler {
    private Hashtable<KeyStroke, Object> bindings;
    private Hashtable<KeyStroke, Object> currentBindings;

    public DefaultInputHandler() {
        this.currentBindings = new Hashtable();
        this.bindings = this.currentBindings;
    }

    @Override
    public void addDefaultKeyBindings() {
        this.addKeyBinding("BACK_SPACE", BACKSPACE);
        this.addKeyBinding("C+BACK_SPACE", BACKSPACE_WORD);
        this.addKeyBinding("DELETE", DELETE);
        this.addKeyBinding("C+DELETE", DELETE_WORD);
        this.addKeyBinding("ENTER", INSERT_BREAK);
        this.addKeyBinding("TAB", INSERT_TAB);
        this.addKeyBinding("INSERT", OVERWRITE);
        this.addKeyBinding("C+\\", TOGGLE_RECT);
        this.addKeyBinding("HOME", HOME);
        this.addKeyBinding("END", END);
        this.addKeyBinding("S+HOME", SELECT_HOME);
        this.addKeyBinding("S+END", SELECT_END);
        this.addKeyBinding("C+HOME", DOCUMENT_HOME);
        this.addKeyBinding("C+END", DOCUMENT_END);
        this.addKeyBinding("CS+HOME", SELECT_DOC_HOME);
        this.addKeyBinding("CS+END", SELECT_DOC_END);
        this.addKeyBinding("PAGE_UP", PREV_PAGE);
        this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
        this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
        this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
        this.addKeyBinding("LEFT", PREV_CHAR);
        this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
        this.addKeyBinding("C+LEFT", PREV_WORD);
        this.addKeyBinding("CS+LEFT", SELECT_PREV_WORD);
        this.addKeyBinding("RIGHT", NEXT_CHAR);
        this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
        this.addKeyBinding("C+RIGHT", NEXT_WORD);
        this.addKeyBinding("CS+RIGHT", SELECT_NEXT_WORD);
        this.addKeyBinding("UP", PREV_LINE);
        this.addKeyBinding("S+UP", SELECT_PREV_LINE);
        this.addKeyBinding("DOWN", NEXT_LINE);
        this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
        this.addKeyBinding("C+ENTER", REPEAT);
        this.addKeyBinding("C+C", COPY_CLIPBOARD);
        this.addKeyBinding("C+V", PASTE_CLIPBOARD);
        this.addKeyBinding("C+X", CUT_CLIPBOARD);
        this.addKeyBinding("A+7", INSERT_OR_SYMBOL);
        this.addKeyBinding("A+8", INSERT_LEFT_BRACKET);
        this.addKeyBinding("A+9", INSERT_RIGHT_BRACKET);
        this.addKeyBinding("A+5", INSERT_LEFT_SQUAREBRACKET);
        this.addKeyBinding("A+6", INSERT_RIGHT_SQUAREBRACKET);
    }

    @Override
    public void addKeyBinding(String string, ActionListener actionListener) {
        Hashtable<KeyStroke, Object> hashtable = this.bindings;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            KeyStroke keyStroke = DefaultInputHandler.parseKeyStroke(stringTokenizer.nextToken());
            if (keyStroke == null) {
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Hashtable<KeyStroke, Object> hashtable2 = hashtable.get(keyStroke);
                if (hashtable2 instanceof Hashtable) {
                    hashtable = hashtable2;
                    continue;
                }
                hashtable2 = new Hashtable<KeyStroke, Object>();
                hashtable.put(keyStroke, hashtable2);
                hashtable = hashtable2;
                continue;
            }
            hashtable.put(keyStroke, actionListener);
        }
    }

    @Override
    public void removeKeyBinding(String string) {
        throw new InternalError("Not yet implemented");
    }

    @Override
    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    @Override
    public InputHandler copy() {
        return new DefaultInputHandler(this);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 17 || n == 16 || n == 18 || n == 157) {
            return;
        }
        if ((n2 & 0xFFFFFFFE) != 0 || keyEvent.isActionKey() || n == 8 || n == 127 || n == 10 || n == 9 || n == 27) {
            if (this.grabAction != null) {
                this.handleGrabAction(keyEvent);
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
            Object object = this.currentBindings.get(keyStroke);
            if (object == null) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    this.repeatCount = 0;
                    this.repeat = false;
                    keyEvent.consume();
                }
                this.currentBindings = this.bindings;
                return;
            }
            if (object instanceof ActionListener) {
                this.currentBindings = this.bindings;
                this.executeAction((ActionListener)object, keyEvent.getSource(), null);
                keyEvent.consume();
                return;
            }
            if (object instanceof Hashtable) {
                this.currentBindings = (Hashtable)object;
                keyEvent.consume();
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        if (c != '\uffff' && (n & 8) == 0 && c >= ' ' && c != '\u007f') {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.toUpperCase(c));
            Object object = this.currentBindings.get(keyStroke);
            if (object instanceof Hashtable) {
                this.currentBindings = (Hashtable)object;
                return;
            }
            if (object instanceof ActionListener) {
                this.currentBindings = this.bindings;
                this.executeAction((ActionListener)object, keyEvent.getSource(), String.valueOf(c));
                return;
            }
            this.currentBindings = this.bindings;
            if (this.grabAction != null) {
                this.handleGrabAction(keyEvent);
                return;
            }
            if (this.repeat && Character.isDigit(c)) {
                this.repeatCount *= 10;
                this.repeatCount += c - 48;
                return;
            }
            this.executeAction(INSERT_CHAR, keyEvent.getSource(), String.valueOf(keyEvent.getKeyChar()));
            this.repeatCount = 0;
            this.repeat = false;
        }
    }

    public static KeyStroke parseKeyStroke(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string.indexOf(43);
        if (n3 != -1) {
            block8: for (int i = 0; i < n3; ++i) {
                switch (Character.toUpperCase(string.charAt(i))) {
                    case 'A': {
                        n2 |= 8;
                        continue block8;
                    }
                    case 'C': {
                        n2 |= 2;
                        continue block8;
                    }
                    case 'M': {
                        n2 |= 4;
                        continue block8;
                    }
                    case 'S': {
                        n2 |= 1;
                    }
                }
            }
        }
        if ((string2 = string.substring(n3 + 1)).length() == 1) {
            char c = Character.toUpperCase(string2.charAt(0));
            if (n2 == 0) {
                return KeyStroke.getKeyStroke(c);
            }
            return KeyStroke.getKeyStroke((int)c, n2);
        }
        if (string2.length() == 0) {
            System.err.println("Invalid key stroke: " + string);
            return null;
        }
        try {
            n = KeyEvent.class.getField("VK_".concat(string2)).getInt(null);
        }
        catch (Exception exception) {
            System.err.println("Invalid key stroke: " + string);
            return null;
        }
        return KeyStroke.getKeyStroke(n, n2);
    }

    private DefaultInputHandler(DefaultInputHandler defaultInputHandler) {
        this.currentBindings = defaultInputHandler.bindings;
        this.bindings = this.currentBindings;
    }
}

