/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.jedit;

import ch.karatojava.util.gui.jedit.KeywordMap;
import ch.karatojava.util.gui.jedit.TokenMarker;
import javax.swing.text.Segment;

public class RubyTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public RubyTokenMarker() {
        this(RubyTokenMarker.getKeywords());
    }

    public RubyTokenMarker(KeywordMap keywordMap) {
        this.keywords = keywordMap;
    }

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block17: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            if (this.doKeyword(segment, i, c)) break;
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(n3 - i, (byte)1);
                            this.lastOffset = this.lastKeyword = n3;
                            break block17;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == n2) {
                                if (this.doKeyword(segment, i, c)) break;
                                bl = false;
                                this.addToken(n4 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            if (!this.doKeyword(segment, i, c)) continue block17;
                            break;
                        }
                        case '/': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block17;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block17;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block17;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block17;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block17;
                    }
                    if (c != '\"') continue block17;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block17;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block17;
                    }
                    if (c != '\'') continue block17;
                    this.addToken(n4 - this.lastOffset, (byte)3);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block17;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (!bl) {
                    by = 0;
                }
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("and", (byte)6);
            cKeywords.add("begin", (byte)6);
            cKeywords.add("break", (byte)6);
            cKeywords.add("case", (byte)6);
            cKeywords.add("class", (byte)6);
            cKeywords.add("def", (byte)6);
            cKeywords.add("defined?", (byte)6);
            cKeywords.add("do", (byte)6);
            cKeywords.add("else", (byte)6);
            cKeywords.add("elsif", (byte)6);
            cKeywords.add("end", (byte)6);
            cKeywords.add("ensure", (byte)6);
            cKeywords.add("false", (byte)6);
            cKeywords.add("for", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("in", (byte)6);
            cKeywords.add("module", (byte)6);
            cKeywords.add("next", (byte)6);
            cKeywords.add("nil", (byte)6);
            cKeywords.add("not", (byte)6);
            cKeywords.add("or", (byte)6);
            cKeywords.add("redo", (byte)6);
            cKeywords.add("rescue", (byte)6);
            cKeywords.add("retry", (byte)6);
            cKeywords.add("return", (byte)6);
            cKeywords.add("self", (byte)6);
            cKeywords.add("super", (byte)6);
            cKeywords.add("then", (byte)6);
            cKeywords.add("true", (byte)6);
            cKeywords.add("undef", (byte)6);
            cKeywords.add("unless", (byte)6);
            cKeywords.add("until", (byte)6);
            cKeywords.add("when", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("yield", (byte)6);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }
}

