/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.rieditor;

import ch.karatojava.util.gui.rieditor.ItemInterface;
import ch.karatojava.util.gui.rieditor.RowInterface;
import ch.karatojava.util.gui.rieditor.RowItemEditor;
import ch.karatojava.util.gui.rieditor.RowItemModelInterface;
import java.util.ArrayList;
import java.util.List;

public class DefaultRow
implements RowInterface {
    private List<ItemInterface> items;
    private RowItemModelInterface model;

    public DefaultRow(RowItemModelInterface rowItemModelInterface) {
        this.model = rowItemModelInterface;
        this.items = new ArrayList<ItemInterface>();
    }

    public DefaultRow(RowItemModelInterface rowItemModelInterface, DefaultRow defaultRow) {
        this(rowItemModelInterface);
        int n = defaultRow.items.size();
        for (int i = 0; i < n; ++i) {
            ItemInterface itemInterface = defaultRow.items.get(i);
            this.items.add(itemInterface.createCopy(this));
        }
    }

    @Override
    public RowItemModelInterface getRowItemModel() {
        return this.model;
    }

    @Override
    public ItemInterface get(int n) {
        return this.items.get(n);
    }

    @Override
    public ItemInterface[] getItems() {
        ItemInterface[] itemInterfaceArray = new ItemInterface[this.items.size()];
        this.items.toArray(itemInterfaceArray);
        return itemInterfaceArray;
    }

    @Override
    public void addItem(ItemInterface itemInterface, int n) {
        this.items.add(n, itemInterface);
        RowItemEditor rowItemEditor = this.model.getRowItemEditor();
        if (rowItemEditor != null) {
            rowItemEditor.modelItemAdded(this, n);
        }
    }

    @Override
    public void addItem(ItemInterface itemInterface) {
        this.addItem(itemInterface, this.items.size());
    }

    @Override
    public void removeItem(ItemInterface itemInterface) {
        int n = this.items.indexOf(itemInterface);
        this.items.remove(itemInterface);
        RowItemEditor rowItemEditor = this.model.getRowItemEditor();
        if (rowItemEditor != null) {
            rowItemEditor.modelItemRemoved(this, itemInterface, n);
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public int indexOf(ItemInterface itemInterface) {
        return this.items.indexOf(itemInterface);
    }

    @Override
    public RowInterface createCopy(RowItemModelInterface rowItemModelInterface) {
        return new DefaultRow(rowItemModelInterface, this);
    }
}

