/*
 * Decompiled with CFR 0.152.
 */
package ch.karatojava.util.gui.rieditor;

import ch.karatojava.util.gui.rieditor.ItemUiInterface;
import ch.karatojava.util.gui.rieditor.RowInterface;
import ch.karatojava.util.gui.rieditor.RowUiInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DefaultRowUi
extends JPanel
implements RowUiInterface {
    private static final long serialVersionUID = 1L;
    private static final Color INDEX_LABEL_FONT_COLOR = new Color(160, 160, 255);
    private static final Color INDEX_LABEL_COLOR = new Color(200, 200, 255);
    private RowInterface row;
    private JLabel indexLabel;
    private int nHeaderComponents;
    private int nFooterComponents;
    private ArrayList<ItemUiInterface> itemUIs;

    public DefaultRowUi(RowInterface rowInterface) {
        this.row = rowInterface;
        this.itemUIs = new ArrayList();
    }

    @Override
    public JComponent getUiComponent() {
        return this;
    }

    @Override
    public RowInterface getRow() {
        return this.row;
    }

    @Override
    public ItemUiInterface getItemUi(int n) {
        return this.itemUIs.get(n);
    }

    @Override
    public int getItemUiIndex(Point point) {
        Component[] componentArray = this.getComponents();
        Rectangle rectangle = new Rectangle();
        for (int i = this.nHeaderComponents; i < componentArray.length - this.nFooterComponents; ++i) {
            componentArray[i].getBounds(rectangle);
            if (rectangle.x > point.x || point.x > rectangle.x + rectangle.width) continue;
            return i - this.nHeaderComponents;
        }
        return -1;
    }

    public void createUi(boolean bl) {
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        this.nHeaderComponents = 0;
        this.indexLabel = new IndexLabel();
        if (bl) {
            this.updateIndexDisplay();
            this.add(this.indexLabel);
            ++this.nHeaderComponents;
        }
        Component[] componentArray = this.createHeaderComponents();
        this.nHeaderComponents += componentArray.length;
        for (int i = 0; i < this.nHeaderComponents; ++i) {
            this.add(componentArray[i]);
        }
        this.add(Box.createHorizontalGlue());
        Component[] componentArray2 = this.createFooterComponents();
        this.nFooterComponents = componentArray2.length;
        for (int i = 0; i < this.nFooterComponents; ++i) {
            this.add(componentArray2[i]);
        }
    }

    @Override
    public void addItemUi(ItemUiInterface itemUiInterface, int n) {
        this.add((Component)itemUiInterface.getUiComponent(), this.nHeaderComponents + n);
        this.itemUIs.add(n, itemUiInterface);
        this.revalidate();
    }

    @Override
    public void updateIndexDisplay() {
        if (this.row != null) {
            int n = this.row.getRowItemModel().indexOf(this.row);
            this.indexLabel.setText(" " + n + " ");
        }
    }

    @Override
    public void removeUiItem(int n) {
        this.remove(this.nHeaderComponents + n);
        this.itemUIs.remove(n);
    }

    protected Component[] createHeaderComponents() {
        return new Component[0];
    }

    protected Component[] createFooterComponents() {
        return new Component[0];
    }

    public static class IndexLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private final int INSET = 5;
        private RoundRectangle2D re = new RoundRectangle2D.Double();

        public IndexLabel() {
            this.setAlignmentY(1.0f);
            this.setForeground(INDEX_LABEL_FONT_COLOR);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Dimension dimension = new Dimension(fontMetrics.stringWidth(" 00 "), fontMetrics.getHeight());
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.re.setRoundRect(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 5.0, 5.0);
            graphics2D.setPaint(INDEX_LABEL_COLOR);
            graphics2D.fill(this.re);
            super.paintComponent(graphics);
        }
    }
}

