/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;

public class ActionUtils {
    static String[] EMPTY_STRING_ARRAY = new String[0];
    static String SPACES = "                ";

    public static String getIndent(String line) {
        int i;
        if (line == null || line.length() == 0) {
            return "";
        }
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return line.substring(0, i);
    }

    public static String[] getSelectedLines(JTextComponent target) {
        String[] lines = null;
        try {
            PlainDocument pDoc = (PlainDocument)target.getDocument();
            int start = pDoc.getParagraphElement(target.getSelectionStart()).getStartOffset();
            int end2 = target.getSelectionStart() == target.getSelectionEnd() ? pDoc.getParagraphElement(target.getSelectionEnd()).getEndOffset() : pDoc.getParagraphElement(target.getSelectionEnd() - 1).getEndOffset();
            target.select(start, end2);
            lines = pDoc.getText(start, end2 - start).split("\n");
            target.select(start, end2);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, ex);
            lines = EMPTY_STRING_ARRAY;
        }
        return lines;
    }

    public static String getLine(JTextComponent target) {
        return ActionUtils.getLineAt(target, target.getCaretPosition());
    }

    public static String getLineAt(JTextComponent target, int pos) {
        String line = null;
        Document doc = target.getDocument();
        if (doc instanceof PlainDocument) {
            PlainDocument pDoc = (PlainDocument)doc;
            int start = pDoc.getParagraphElement(pos).getStartOffset();
            int end2 = pDoc.getParagraphElement(pos).getEndOffset();
            try {
                line = doc.getText(start, end2 - start);
                if (line != null && line.endsWith("\n")) {
                    line = line.substring(0, line.length() - 1);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return line;
    }

    public static Frame getFrameFor(Component comp) {
        Window w = SwingUtilities.getWindowAncestor(comp);
        if (w != null && w instanceof Frame) {
            Frame frame = (Frame)w;
            return frame;
        }
        return null;
    }

    public static String getTokenStringAt(SyntaxDocument doc, int pos) {
        String word = "";
        Token t = doc.getTokenAt(pos);
        if (t != null) {
            try {
                word = doc.getText(t.start, t.length);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return word;
    }

    public static SyntaxDocument getSyntaxDocument(JTextComponent component) {
        if (component == null) {
            return null;
        }
        Document doc = component.getDocument();
        if (doc instanceof SyntaxDocument) {
            return (SyntaxDocument)doc;
        }
        return null;
    }

    public static int getLineNumber(JTextComponent editor, int pos) throws BadLocationException {
        if (ActionUtils.getSyntaxDocument(editor) != null) {
            SyntaxDocument sdoc = ActionUtils.getSyntaxDocument(editor);
            return sdoc.getLineNumberAt(pos);
        }
        Document doc = editor.getDocument();
        return doc.getDefaultRootElement().getElementIndex(pos);
    }

    public static int getColumnNumber(JTextComponent editor, int pos) throws BadLocationException {
        Rectangle r = editor.modelToView(pos);
        int start = editor.viewToModel(new Point(0, r.y));
        int column = pos - start;
        return column;
    }

    public static int getDocumentPosition(JTextComponent editor, int line, int column) {
        int lineHeight = editor.getFontMetrics(editor.getFont()).getHeight();
        int charWidth = editor.getFontMetrics(editor.getFont()).charWidth('m');
        int y = line * lineHeight;
        int x = column * charWidth;
        Point pt = new Point(x, y);
        int pos = editor.viewToModel(pt);
        return pos;
    }

    public static int getLineCount(JTextComponent pane) {
        SyntaxDocument sdoc = ActionUtils.getSyntaxDocument(pane);
        if (sdoc != null) {
            return sdoc.getLineCount();
        }
        int count = 0;
        try {
            int p = pane.getDocument().getLength() - 1;
            if (p > 0) {
                count = ActionUtils.getLineNumber(pane, p);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return count;
    }

    public static void insertIntoCombo(JComboBox combo, Object item) {
        MutableComboBoxModel model = (MutableComboBoxModel)combo.getModel();
        if (model.getSize() == 0) {
            model.insertElementAt(item, 0);
            return;
        }
        Object o = model.getElementAt(0);
        if (o.equals(item)) {
            return;
        }
        model.removeElement(item);
        model.insertElementAt(item, 0);
        combo.setSelectedIndex(0);
    }

    public static String repeatString(String source, int repeat2) {
        if (repeat2 < 0) {
            throw new IllegalArgumentException("Cannot repeat " + repeat2 + " times.");
        }
        if (repeat2 == 0 || source == null || source.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < repeat2; ++i) {
            buffer.append(source);
        }
        return buffer.toString();
    }

    public static boolean isEmptyOrBlanks(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static int getTabSize(JTextComponent text) {
        Integer tabs = (Integer)text.getDocument().getProperty("tabSize");
        return null == tabs ? 0 : tabs;
    }

    public static void insertMagicString(JTextComponent target, int dot, String toInsert) throws BadLocationException {
        Document doc = target.getDocument();
        if (toInsert.indexOf(124) >= 0) {
            int ofst = toInsert.indexOf(124);
            int ofst2 = toInsert.indexOf(124, ofst + 1);
            toInsert = toInsert.replace("|", "");
            doc.insertString(dot, toInsert, null);
            dot = target.getCaretPosition();
            int strLength = toInsert.length();
            if (ofst2 > 0) {
                target.select(dot + ofst - strLength, dot + ofst2 - strLength - 1);
            } else {
                target.setCaretPosition(dot + ofst - strLength);
            }
        } else {
            doc.insertString(dot, toInsert, null);
        }
    }
}

