/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import javax.swing.JLabel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;

public class CaretMonitor
implements CaretListener {
    private JLabel label;
    private JTextComponent text;

    public CaretMonitor(JTextComponent text, JLabel label) {
        this.label = label;
        this.text = text;
        text.addCaretListener(this);
    }

    public void caretUpdate(CaretEvent evt) {
        block5: {
            if (this.text.getDocument() instanceof SyntaxDocument) {
                try {
                    if (this.text.getSelectionStart() == this.text.getSelectionEnd()) {
                        int pos = evt.getDot();
                        String loc = String.format("%d:%d (%d)", ActionUtils.getLineNumber(this.text, pos) + 1, ActionUtils.getColumnNumber(this.text, pos) + 1, pos);
                        this.label.setText(loc);
                        break block5;
                    }
                    int start = this.text.getSelectionStart();
                    int end2 = this.text.getSelectionEnd();
                    String loc = String.format("%d:%d - %d:%d (%d)", ActionUtils.getLineNumber(this.text, start) + 1, ActionUtils.getColumnNumber(this.text, start) + 1, ActionUtils.getLineNumber(this.text, end2) + 1, ActionUtils.getColumnNumber(this.text, end2) + 1, end2 - start);
                    this.label.setText(loc);
                }
                catch (BadLocationException ex) {
                    this.label.setText("Ex: " + ex.getMessage());
                }
            } else {
                this.label.setText("Position");
            }
        }
    }

    protected void finalize() throws Throwable {
        this.text.removeCaretListener(this);
        super.finalize();
    }
}

