/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class JavaIndentAction
extends TextAction
implements SyntaxAction {
    public JavaIndentAction() {
        super("JAVA_INDENT");
    }

    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null) {
            SyntaxDocument sDoc;
            String line = ActionUtils.getLine(target);
            String prefix = ActionUtils.getIndent(line);
            Integer tabSize = (Integer)target.getDocument().getProperty("tabSize");
            if (line.trim().endsWith("{")) {
                prefix = prefix + ActionUtils.SPACES.substring(0, tabSize);
            }
            if ((sDoc = ActionUtils.getSyntaxDocument(target)) != null && line.trim().equals("}")) {
                int pos = target.getCaretPosition();
                int start = sDoc.getParagraphElement(pos).getStartOffset();
                int end2 = sDoc.getParagraphElement(pos).getEndOffset();
                if (end2 >= sDoc.getLength()) {
                    --end2;
                }
                if (line.startsWith(ActionUtils.SPACES.substring(0, tabSize))) {
                    try {
                        sDoc.replace(start, end2 - start, line.substring(tabSize) + "\n", null);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                } else {
                    target.replaceSelection("\n" + prefix);
                }
            } else {
                target.replaceSelection("\n" + prefix);
            }
        }
    }

    public void config(Configuration config, String prefix, String name) {
    }

    public TextAction getAction(String key) {
        return this;
    }
}

